/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.service.impl.FundingSourceTypeServiceImpl;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class FundingSourceTypeServiceTest {
    private static final String FUNDING_TYPE_ID = "fundingSourceTypeCode";
    private static final String FUNDING_TYPE_VALID_ID_VALUE = "6";
    private static final String FUNDING_TYPE_INVALID_ID_VALUE = "100001";
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testFundingSourceTypeFound() {
        this.mockFundingSourceType(FUNDING_TYPE_VALID_ID_VALUE, true);
    }

    @Test
    public void testFundingSourceTypeNotFound() {
        this.mockFundingSourceType(FUNDING_TYPE_INVALID_ID_VALUE, false);
    }

    private void mockFundingSourceType(String typeIdValue, boolean valid) {
        FundingSourceTypeServiceImpl funSrcTypeServiceImpl = new FundingSourceTypeServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(FUNDING_TYPE_ID, typeIdValue);
        final FundingSourceType fundingSourceType = this.getFundingSourceType(valid);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(FundingSourceType.class, fieldValues);
                this.will(1.returnValue((Object)fundingSourceType));
            }
        });
        funSrcTypeServiceImpl.setBusinessObjectService(businessObjectService);
        Assert.assertEquals((Object)fundingSourceType, (Object)funSrcTypeServiceImpl.getFundingSourceType(typeIdValue));
    }

    private FundingSourceType getFundingSourceType(boolean isValid) {
        FundingSourceType ret = null;
        if (isValid) {
            ret = new FundingSourceType();
            ret.setDescription("Award");
            ret.setFundingSourceTypeCode(FUNDING_TYPE_VALID_ID_VALUE);
        }
        return ret;
    }
}

