/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.kuali.kra.bo.SponsorHierarchy;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

class NihSponsorHandlingTestHelper {
    static final String SPONSOR_CODE_FOR_HIERARCHY_A = "005979";
    static final String SPONSOR_CODE_FOR_HIERARCHY_B = "000340";
    private Sponsorable sponsorable;
    private BusinessObjectService boService;
    private SponsorService spService;
    private KeyPersonnelService kpService;
    private static final String SPONSOR_HIERARCHY_NAME = "Sponsor Groups";

    NihSponsorHandlingTestHelper(Sponsorable sponsorable, BusinessObjectService boService, SponsorService spService, KeyPersonnelService kpService) {
        this.sponsorable = sponsorable;
        this.boService = boService;
        this.spService = spService;
        this.kpService = kpService;
        this.init();
    }

    public void testIsSponsorNihMultiplePi_DevelopmentProposal_NoSponsorAdded() {
        this.verifyNonNihMultiplePiSponsorFound(this.getSponsorHierarchyNodes().get(0));
    }

    public void testIsSponsorNihMultiplePi_DevelopmentProposal_SponsorAdded() {
        this.setUpSponsorNihMultiplePi();
        this.verifyNihMultiplePiSponsorFound(this.getSponsorHierarchyNodes().get(1));
    }

    private void init() {
        this.prepareSponsorHierarchy();
    }

    private List<SponsorHierarchy> getSponsorHierarchyNodes() {
        return new ArrayList<SponsorHierarchy>(this.boService.findAll(SponsorHierarchy.class));
    }

    private void prepareSponsorHierarchy() {
        SponsorHierarchy sponsorHierarchyNode = new SponsorHierarchy();
        sponsorHierarchyNode.setHierarchyName(SPONSOR_HIERARCHY_NAME);
        sponsorHierarchyNode.setSponsorCode(SPONSOR_CODE_FOR_HIERARCHY_A);
        this.boService.save((PersistableBusinessObject)sponsorHierarchyNode);
    }

    public void setUpSponsorNihMultiplePi() {
        SponsorHierarchy sponsorHierarchyNode = new SponsorHierarchy();
        sponsorHierarchyNode.setHierarchyName("NIH Multiple PI");
        sponsorHierarchyNode.setSponsorCode(SPONSOR_CODE_FOR_HIERARCHY_B);
        this.boService.save((PersistableBusinessObject)sponsorHierarchyNode);
    }

    private void save(SponsorHierarchy node) {
        this.boService.save((PersistableBusinessObject)node);
    }

    private void verifyNihMultiplePiSponsorFound(SponsorHierarchy sponsorHierarchy) {
        this.save(sponsorHierarchy);
        this.sponsorable.setSponsorCode(sponsorHierarchy.getSponsorCode());
        Assert.assertTrue((boolean)this.spService.isSponsorNihMultiplePi(this.sponsorable));
    }

    private void verifyNonNihMultiplePiSponsorFound(SponsorHierarchy sponsorHierarchy) {
        this.save(sponsorHierarchy);
        this.sponsorable.setSponsorCode(sponsorHierarchy.getSponsorCode());
        Assert.assertFalse((boolean)this.spService.isSponsorNihMultiplePi(this.sponsorable));
    }
}

