/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.SponsorHierarchy;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.service.NihSponsorHandlingTestHelper;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.kra.service.impl.SponsorServiceImpl;
import org.kuali.kra.service.impl.adapters.BusinessObjectServiceAdapter;
import org.kuali.kra.service.impl.adapters.KeyPersonnelServiceAdapter;
import org.kuali.kra.service.impl.adapters.ParameterServiceAdapter;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NihSponsorHandlingUnitTest {
    private NihSponsorHandlingTestHelper helper;
    private List<ProposalPersonRole> roles;
    private static final String NIH = "NIH";
    private static final String GROUP_HIERARCHY_NAME = "Sponsor Groups";
    private static final String PI_PARM_NAME = "personrole.nih.pi";
    private static final String COI_PARM_NAME = "personrole.nih.coi";
    private static final String KEY_PERSON_PARM_NAME = "personrole.nih.kp";
    private static final String KEY_PERSON_DESCRIPTION = "Key Person";
    private static final String NIH_COI_DESCRIPTION = "PI/Multiple";
    private static final String NIH_PI_DESCRIPTION = "PI/Contact";
    private static final String NONNIH_COI_DESCRIPTION = "Co-Investigator";
    private static final String NONNIH_PI_DESCRIPTION = "Principal Investigator";

    @Before
    public void setUp() {
        this.roles = this.defineRoles();
        Award sponsorable = new Award();
        sponsorable.setSponsorCode("005979");
        BusinessObjectService bos = this.getBusinessObjectService();
        this.helper = new NihSponsorHandlingTestHelper((Sponsorable)sponsorable, bos, this.getSponsorService(bos), this.getKeyPersonnelService());
    }

    @After
    public void tearDown() {
        this.helper = null;
        this.roles = null;
    }

    @Test
    public void testIsSponsorNihMultiplePi_DevelopmentProposal_NoSponsorAdded() {
        this.helper.testIsSponsorNihMultiplePi_DevelopmentProposal_NoSponsorAdded();
    }

    @Test
    public void testIsSponsorNihMultiplePi_DevelopmentProposal_SponsorAdded() {
        this.helper.testIsSponsorNihMultiplePi_DevelopmentProposal_SponsorAdded();
    }

    private List<ProposalPersonRole> defineRoles() {
        ArrayList<ProposalPersonRole> roles = new ArrayList<ProposalPersonRole>();
        ProposalPersonRole role = new ProposalPersonRole();
        role.setProposalPersonRoleId("PI");
        role.setDescription(NONNIH_PI_DESCRIPTION);
        roles.add(role);
        role = new ProposalPersonRole();
        role.setProposalPersonRoleId("COI");
        role.setDescription(NONNIH_COI_DESCRIPTION);
        roles.add(role);
        role = new ProposalPersonRole();
        role.setProposalPersonRoleId("KP");
        role.setDescription(KEY_PERSON_DESCRIPTION);
        roles.add(role);
        return roles;
    }

    private BusinessObjectService getBusinessObjectService() {
        final HashMap sponsorHierarchies = new HashMap();
        return new BusinessObjectServiceAdapter(){

            public Collection findAll(Class klass) {
                if (ProposalPersonRole.class.equals((Object)klass)) {
                    return NihSponsorHandlingUnitTest.this.roles;
                }
                if (SponsorHierarchy.class.equals((Object)klass)) {
                    return sponsorHierarchies.values();
                }
                return null;
            }

            public Collection findMatching(Class klass, Map fieldValues) {
                return SponsorHierarchy.class.equals((Object)klass) ? sponsorHierarchies.values() : null;
            }

            @Override
            public PersistableBusinessObject save(PersistableBusinessObject bo) {
                if (bo instanceof SponsorHierarchy) {
                    SponsorHierarchy sh = (SponsorHierarchy)bo;
                    sponsorHierarchies.put(String.format("%s:%s", sh.getSponsorCode(), sh.getHierarchyName()), sh);
                }
                return bo;
            }

            public int countMatching(Class clazz, Map fieldValues) {
                if (SponsorHierarchy.class.equals((Object)clazz)) {
                    String aValue = (String)fieldValues.get("hierarchyName");
                    if (sponsorHierarchies.values().toString().contains(aValue)) {
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
        };
    }

    public ParameterService getParameterService() {
        return new ParameterServiceAdapter(){

            public String getParameterValue(String namespaceCode, String detailTypeCode, String parameterName) {
                if ("KC-GEN".equals(namespaceCode) && "All".equals(detailTypeCode)) {
                    if ("sponsorGroupHierarchyName".equals(parameterName)) {
                        return NihSponsorHandlingUnitTest.GROUP_HIERARCHY_NAME;
                    }
                    if ("sponsorLevelHierarchy".equals(parameterName)) {
                        return NihSponsorHandlingUnitTest.NIH;
                    }
                    if (NihSponsorHandlingUnitTest.PI_PARM_NAME.equals(parameterName)) {
                        return NihSponsorHandlingUnitTest.NIH_PI_DESCRIPTION;
                    }
                    if (NihSponsorHandlingUnitTest.COI_PARM_NAME.equals(parameterName)) {
                        return NihSponsorHandlingUnitTest.NIH_COI_DESCRIPTION;
                    }
                    if (NihSponsorHandlingUnitTest.KEY_PERSON_PARM_NAME.equals(parameterName)) {
                        return NihSponsorHandlingUnitTest.KEY_PERSON_DESCRIPTION;
                    }
                    return null;
                }
                return super.getParameterValueAsString(namespaceCode, detailTypeCode, parameterName);
            }
        };
    }

    private KeyPersonnelService getKeyPersonnelService() {
        return new KeyPersonnelServiceAdapter(){

            @Override
            public Map<String, String> loadKeyPersonnelRoleDescriptions(boolean sponsorIsNih) {
                HashMap<String, String> results = new HashMap<String, String>();
                if (sponsorIsNih) {
                    results.put("PI", NihSponsorHandlingUnitTest.NIH_PI_DESCRIPTION);
                    results.put("COI", NihSponsorHandlingUnitTest.NIH_COI_DESCRIPTION);
                    results.put("KP", NihSponsorHandlingUnitTest.KEY_PERSON_DESCRIPTION);
                } else {
                    results.put("PI", NihSponsorHandlingUnitTest.NONNIH_PI_DESCRIPTION);
                    results.put("COI", NihSponsorHandlingUnitTest.NONNIH_COI_DESCRIPTION);
                    results.put("KP", NihSponsorHandlingUnitTest.KEY_PERSON_DESCRIPTION);
                }
                return results;
            }
        };
    }

    private SponsorService getSponsorService(BusinessObjectService bos) {
        SponsorServiceImpl impl = new SponsorServiceImpl();
        impl.setBusinessObjectService(bos);
        impl.setParameterService(this.getParameterService());
        return impl;
    }
}

