/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.service.impl.OrganizationServiceImpl;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class OrganizationServiceTest {
    private Mockery context = new JUnit4Mockery();
    private static final String ORGANIZATION_ID = "organizationId";
    private static final String ORGANIZATION_VALID_ID_VALUE = "000001";
    private static final String ORGANIZATION_INVALID_ID_VALUE = "100001";

    @Test
    public void testGetOrganizationFound() {
        this.mockOrganization(ORGANIZATION_VALID_ID_VALUE, true);
    }

    @Test
    public void testGetOrganizationNotFound() {
        this.mockOrganization(ORGANIZATION_INVALID_ID_VALUE, false);
    }

    private void mockOrganization(String organizationIdValue, boolean validOrganization) {
        OrganizationServiceImpl organizationServiceImpl = new OrganizationServiceImpl();
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(ORGANIZATION_ID, organizationIdValue);
        final Organization organization = this.getOrganization(validOrganization);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(Organization.class, fieldValues);
                this.will(1.returnValue((Object)organization));
            }
        });
        organizationServiceImpl.setBusinessObjectService(businessObjectService);
        Assert.assertEquals((Object)organization, (Object)organizationServiceImpl.getOrganization(organizationIdValue));
    }

    private Organization getOrganization(boolean validOrganization) {
        if (validOrganization) {
            return new Organization();
        }
        return null;
    }
}

