/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.impl.SequenceUtils;
import org.kuali.kra.service.impl.versioningartifacts.SimpleSequenceOwner;

public class SequenceUtilsTest
implements Serializable {
    MockSequenceOwner owner;
    MockGenericsAssociate<SequenceAssociate> testAssociate1;
    MockGenericsAssociate<NonGenericAssociate> testAssociate2;
    NonGenericAssociate testAssociate3;
    NonGenericAssociate testAssociate4;
    NonGenericAssociate testAssociate5;

    @Before
    public void setUp() throws Exception {
        MockSequenceOwner owner = new MockSequenceOwner();
        MockGenericsAssociate gen1 = new MockGenericsAssociate();
        owner.setGenericAssociate(gen1);
        this.testAssociate1 = new MockGenericsAssociate();
        gen1.getAssociateCollection().add(this.testAssociate1);
    }

    @Test
    public void testInheritedGenericList() throws VersionException {
        MockSequenceOwner owner = new MockSequenceOwner();
        for (int i = 0; i < 3; ++i) {
            owner.getGenericList().add(this.getNewGenericAssociate());
        }
        SequenceUtils myUtils = new SequenceUtils();
        MockSequenceOwner sequencedOwner = (MockSequenceOwner)myUtils.sequence((SequenceOwner)owner);
        for (NonGenericAssociate associate1 : sequencedOwner.getGenericList()) {
            for (NonGenericAssociate associate2 : associate1.getAssociateCollection()) {
                Assert.assertTrue((boolean)associate2.getStateReset());
            }
            Assert.assertTrue((boolean)associate1.getStateReset());
        }
    }

    @Test
    public void testInheritedGenericField() throws VersionException {
        MockSequenceOwner owner = new MockSequenceOwner();
        for (int i = 0; i < 3; ++i) {
            owner.getGenericList().add(this.getNewGenericAssociate());
            owner.getGenericList().get(i).setGenericAssociate(this.getNewGenericAssociate());
        }
        SequenceUtils myUtils = new SequenceUtils();
        MockSequenceOwner sequencedOwner = (MockSequenceOwner)myUtils.sequence((SequenceOwner)owner);
        for (NonGenericAssociate associate1 : sequencedOwner.getGenericList()) {
            for (NonGenericAssociate associate2 : associate1.getAssociateCollection()) {
                Assert.assertTrue((boolean)associate2.getStateReset());
            }
            Assert.assertTrue((boolean)associate1.getStateReset());
            Assert.assertTrue((boolean)((NonGenericAssociate)associate1.getGenericAssociate()).getStateReset());
            Assert.assertFalse((boolean)associate1.getChildNonVersionedField().getStateReset());
            Assert.assertFalse((boolean)((NonGenericAssociate)associate1.getNonVersionedField()).getStateReset());
        }
    }

    private NonGenericAssociate getNewGenericAssociate() {
        int i;
        NonGenericAssociate newAssociate = new NonGenericAssociate();
        for (i = 0; i < 3; ++i) {
            newAssociate.getAssociateCollection().add(new NonGenericAssociate());
        }
        for (i = 0; i < 3; ++i) {
            newAssociate.getNonGenericCollection().add(new NonGenericAssociate());
        }
        newAssociate.setGenericAssociate(new NonGenericAssociate());
        newAssociate.setNonGenericAssociate(new NonGenericAssociate());
        newAssociate.setNonVersionedField(new NonGenericAssociate());
        newAssociate.setChildNonVersionedField(new NonGenericAssociate());
        return newAssociate;
    }

    public class NonGenericAssociate
    extends MockGenericsAssociate<NonGenericAssociate>
    implements Serializable {
        private List nonGenericCollection;
        private NonGenericAssociate nonGenericAssociate;
        @SkipVersioning
        private NonGenericAssociate childNonVersionedField;

        public NonGenericAssociate() {
            this.nonGenericCollection = new ArrayList();
        }

        public List getNonGenericCollection() {
            return this.nonGenericCollection;
        }

        public void setNonGenericCollection(List nonGenericCollection) {
            this.nonGenericCollection = nonGenericCollection;
        }

        public NonGenericAssociate getChildNonVersionedField() {
            return this.childNonVersionedField;
        }

        public void setChildNonVersionedField(NonGenericAssociate childNonVersionedField) {
            this.childNonVersionedField = childNonVersionedField;
        }

        public NonGenericAssociate getNonGenericAssociate() {
            return this.nonGenericAssociate;
        }

        public void setNonGenericAssociate(NonGenericAssociate nonGenericAssociate) {
            this.nonGenericAssociate = nonGenericAssociate;
        }
    }

    public class MockGenericsAssociate<T>
    implements SequenceAssociate<MockSequenceOwner>,
    Serializable {
        private MockSequenceOwner mockOwner;
        private Boolean stateReset = false;
        private List<T> associateCollection = new ArrayList<T>();
        private T genericAssociate;
        @SkipVersioning
        private T nonVersionedField;

        public MockSequenceOwner getSequenceOwner() {
            return this.mockOwner;
        }

        public void setSequenceOwner(MockSequenceOwner newlyVersionedOwner) {
            this.mockOwner = newlyVersionedOwner;
        }

        public Integer getSequenceNumber() {
            return this.mockOwner.getSequenceNumber();
        }

        public void resetPersistenceState() {
            this.stateReset = true;
        }

        public Boolean getStateReset() {
            return this.stateReset;
        }

        public void setStateReset(Boolean stateReset) {
            this.stateReset = stateReset;
        }

        public List<T> getAssociateCollection() {
            return this.associateCollection;
        }

        public void setAssociateCollection(List<T> associateCollection) {
            this.associateCollection = associateCollection;
        }

        public T getGenericAssociate() {
            return this.genericAssociate;
        }

        public void setGenericAssociate(T genericAssociate) {
            this.genericAssociate = genericAssociate;
        }

        public T getNonVersionedField() {
            return this.nonVersionedField;
        }

        public void setNonVersionedField(T nonVersionedField) {
            this.nonVersionedField = nonVersionedField;
        }
    }

    public class MockSequenceOwner
    extends SimpleSequenceOwner
    implements Serializable {
        private MockGenericsAssociate genericAssociate;
        private NonGenericAssociate nonGenericAssociate;
        private List nonGenericList = new ArrayList();
        private List<NonGenericAssociate> genericList = new ArrayList<NonGenericAssociate>();

        public NonGenericAssociate getNonGenericAssociate() {
            return this.nonGenericAssociate;
        }

        public void setNonGenericAssociate(NonGenericAssociate nonGenericAssociate) {
            this.nonGenericAssociate = nonGenericAssociate;
        }

        public List getNonGenericList() {
            return this.nonGenericList;
        }

        public void setNonGenericList(List nonGenericList) {
            this.nonGenericList = nonGenericList;
        }

        public MockGenericsAssociate getGenericAssociate() {
            return this.genericAssociate;
        }

        public void setGenericAssociate(MockGenericsAssociate genericAssociate) {
            this.genericAssociate = genericAssociate;
        }

        public List<NonGenericAssociate> getGenericList() {
            return this.genericList;
        }

        public void setGenericList(List<NonGenericAssociate> genericList) {
            this.genericList = genericList;
        }
    }
}

