/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.service.impl.VersionHistoryServiceImpl;
import org.kuali.kra.service.impl.versioningartifacts.SequenceOwnerImpl;
import org.kuali.kra.service.impl.versioningartifacts.SimpleSequenceOwner;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class VersionHistoryServiceTest {
    private static final String SEQUENCE_OWNER_NAME_A = "Owner A";
    private static final String SEQUENCE_OWNER_NAME_B = "Owner B";
    private VersionHistoryService service;
    private SequenceOwner<SequenceOwnerImpl> sequenceOwner1;
    private SequenceOwner<SimpleSequenceOwner> sequenceOwner2;
    private SequenceOwner<SequenceOwnerImpl> sequenceOwner3;
    private SequenceOwner<SequenceOwnerImpl> sequenceOwner4;
    private SequenceOwner<SimpleSequenceOwner> sequenceOwner5;

    @Before
    public void setUp() {
        this.sequenceOwner1 = this.createSequenceOwner(1001);
        this.sequenceOwner2 = this.createSimpleSequenceOwner(2001);
        this.sequenceOwner3 = this.createSequenceOwner(1002);
        this.sequenceOwner4 = this.createSequenceOwner(1003);
        this.sequenceOwner5 = this.createSimpleSequenceOwner(2002);
        VersionHistoryServiceImpl impl = new VersionHistoryServiceImpl();
        impl.setBusinessObjectService((BusinessObjectService)new MockBusinessObjectService());
        this.service = impl;
    }

    @After
    public void tearDown() {
        this.sequenceOwner4 = null;
        this.sequenceOwner3 = null;
        this.sequenceOwner1 = null;
        this.sequenceOwner5 = null;
        this.sequenceOwner2 = null;
    }

    @Test
    public void testFindingNewVersionHistory_OneAdded() {
        this.createAndCheckNewActiveVersion(this.sequenceOwner1, "jtester");
        this.checkOwner(SEQUENCE_OWNER_NAME_A, SequenceOwnerImpl.class, 1, 1001, "jtester");
    }

    @Test
    public void testVersionHistory_MultipleMixedTypesAdded() {
        this.createAndCheckNewActiveVersion(this.sequenceOwner1, "user1");
        this.checkOwner(SEQUENCE_OWNER_NAME_A, SequenceOwnerImpl.class, 1, 1001, "user1");
    }

    private void checkOwner(String ownerName, Class<? extends SequenceOwner<?>> ownerType, int expectedNumberOfVersionsForName, int expectedActiveSequenceNumber, String userNameForActiveVersion) {
        VersionHistory foundHistory = this.verifyFindActiveVersion(ownerName, ownerType, expectedActiveSequenceNumber, userNameForActiveVersion);
        this.verifyLoadHistories(ownerName, ownerType, expectedNumberOfVersionsForName, foundHistory, expectedActiveSequenceNumber);
    }

    private VersionHistory createAndCheckNewActiveVersion(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner, String userName) {
        VersionHistory history = this.service.updateVersionHistory(sequenceOwner, VersionStatus.ACTIVE, userName);
        Assert.assertEquals((Object)VersionStatus.ACTIVE, (Object)history.getStatus());
        return history;
    }

    private SequenceOwner<SequenceOwnerImpl> createSequenceOwner(int sequenceNumber) {
        SequenceOwnerImpl owner = new SequenceOwnerImpl();
        owner.setName(SEQUENCE_OWNER_NAME_A);
        owner.setSequenceNumber(sequenceNumber);
        return owner;
    }

    private SequenceOwner<SimpleSequenceOwner> createSimpleSequenceOwner(int sequenceNumber) {
        SimpleSequenceOwner owner = new SimpleSequenceOwner();
        owner.setName(SEQUENCE_OWNER_NAME_B);
        owner.setSequenceNumber(sequenceNumber);
        return owner;
    }

    private VersionHistory verifyFindActiveVersion(String ownerName, Class<? extends SequenceOwner<?>> ownerType, int expectedActiveSequenceNumber, String userNameForActiveVersion) {
        VersionHistory foundHistory = this.service.findActiveVersion(ownerType, ownerName);
        Assert.assertNotNull((String)"Found history object was null", (Object)foundHistory);
        Assert.assertEquals((long)expectedActiveSequenceNumber, (long)foundHistory.getSequenceOwner().getSequenceNumber().intValue());
        Assert.assertEquals((Object)userNameForActiveVersion, (Object)foundHistory.getUserId());
        Assert.assertTrue((String)"Version not active", (boolean)foundHistory.isActiveVersion());
        return foundHistory;
    }

    private void verifyLoadHistories(String ownerName, Class<? extends SequenceOwner<?>> ownerType, int expectedNumberOfVersionsForName, VersionHistory foundHistory, int expectedActiveSequenceNumber) {
        List histories = this.service.loadVersionHistory(ownerType, ownerName);
        Assert.assertEquals((long)expectedNumberOfVersionsForName, (long)histories.size());
        for (VersionHistory vh : histories) {
            SequenceOwner owner = vh.getSequenceOwner();
            if (owner.getSequenceNumber() == expectedActiveSequenceNumber) {
                Assert.assertEquals((Object)VersionStatus.ACTIVE, (Object)vh.getStatus());
                continue;
            }
            Assert.assertEquals((Object)VersionStatus.ARCHIVED, (Object)vh.getStatus());
        }
    }

    private class MockBusinessObjectService
    implements BusinessObjectService {
        private Map<Long, VersionHistory> mockHistory = new TreeMap<Long, VersionHistory>();

        private MockBusinessObjectService() {
        }

        public Collection findAll(Class clazz) {
            return this.mockHistory.values();
        }

        public PersistableBusinessObject save(PersistableBusinessObject bo) {
            VersionHistory versionHistory = (VersionHistory)bo;
            if (versionHistory.getVersionHistoryId() == null) {
                versionHistory.setVersionHistoryId(Long.valueOf(System.currentTimeMillis() + (long)versionHistory.hashCode()));
            }
            this.mockHistory.put(versionHistory.getVersionHistoryId(), versionHistory);
            return bo;
        }

        public PersistableBusinessObject findByPrimaryKey(Class clazz, Map primaryKeys) {
            return null;
        }

        public Collection findMatching(Class clazz, Map fieldValues) {
            Collection collection = clazz.equals(VersionHistory.class) ? this.handleVersionHistoryClass(fieldValues, (String)fieldValues.get("sequenceOwnerVersionNameValue")) : this.handleSequenceOwnerImplClass(clazz, "name");
            return collection;
        }

        private Collection handleSequenceOwnerImplClass(Class clazz, String versionNameField) {
            ArrayList<SequenceOwner> collection = new ArrayList<SequenceOwner>();
            String className = clazz.getName();
            for (Long id : this.mockHistory.keySet()) {
                VersionHistory vh = this.mockHistory.get(id);
                SequenceOwner sequenceOwner = vh.getSequenceOwner();
                String versionName = (String)ObjectUtils.getPropertyValue((Object)sequenceOwner, (String)sequenceOwner.getVersionNameField());
                if (!vh.getSequenceOwnerClassName().equals(className) || !vh.getSequenceOwnerVersionNameValue().equals(versionName)) continue;
                collection.add(sequenceOwner);
            }
            return collection;
        }

        private Collection handleVersionHistoryClass(Map fieldValues, String versionName) {
            ArrayList<VersionHistory> collection = new ArrayList<VersionHistory>();
            String className = (String)fieldValues.get("sequenceOwnerClassName");
            for (Long id : this.mockHistory.keySet()) {
                boolean conditionsForInclusion;
                VersionHistory vh = this.mockHistory.get(id);
                boolean bl = conditionsForInclusion = vh.getSequenceOwnerClassName().equals(className) && vh.getSequenceOwnerVersionNameValue().equals(versionName);
                if (fieldValues.containsKey("statusForOjb")) {
                    conditionsForInclusion &= fieldValues.get("statusForOjb").equals(vh.getStatusForOjb());
                }
                if (!conditionsForInclusion) continue;
                collection.add(vh);
            }
            return collection;
        }

        public Collection findMatchingOrderBy(Class clazz, Map fieldValues, String sortField, boolean sortAscending) {
            return null;
        }

        public BusinessObject getReferenceIfExists(BusinessObject bo, String referenceName) {
            return null;
        }

        public PersistableBusinessObject linkAndSave(PersistableBusinessObject bo) {
            return bo;
        }

        public List<? extends PersistableBusinessObject> linkAndSave(List<? extends PersistableBusinessObject> businessObjects) {
            return businessObjects;
        }

        public void linkUserFields(PersistableBusinessObject bo) {
        }

        public void linkUserFields(List<PersistableBusinessObject> bos) {
        }

        public PersistableBusinessObject retrieve(PersistableBusinessObject object) {
            return null;
        }

        public List<? extends PersistableBusinessObject> save(List<? extends PersistableBusinessObject> businessObjects) {
            for (PersistableBusinessObject persistableBusinessObject : businessObjects) {
                this.save(persistableBusinessObject);
            }
            return businessObjects;
        }

        public int countMatching(Class clazz, Map fieldValues) {
            return 0;
        }

        public int countMatching(Class clazz, Map positiveFieldValues, Map negativeFieldValues) {
            return 0;
        }

        public void delete(PersistableBusinessObject bo) {
        }

        public void delete(List<? extends PersistableBusinessObject> boList) {
        }

        public void deleteMatching(Class clazz, Map fieldValues) {
        }

        public <T extends BusinessObject> Collection<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending) {
            return null;
        }

        public <T extends BusinessObject> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey) {
            return null;
        }

        public PersistableBusinessObject manageReadOnly(PersistableBusinessObject bo) {
            return null;
        }
    }
}

