/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.bo.CommentType;
import org.kuali.kra.service.impl.AwardCommentServiceImpl;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class AwardCommentServiceImplTest {
    final Collection<CommentType> commentTypeList = new ArrayList<CommentType>();
    AwardCommentServiceImpl awardCommentServiceImpl;
    final Map<String, Object> queryMap = new HashMap<String, Object>();
    private String AWARD_COMMENT_SCREEN_FLAG = "awardCommentScreenFlag";
    private String SOME_COMMENTS = "some comments";
    private String SOME_OTHER_COMMENTS = "some other comments";
    private String ONE = "1";
    private String TWO = "2";
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.awardCommentServiceImpl = new AwardCommentServiceImpl();
        this.queryMap.put(this.AWARD_COMMENT_SCREEN_FLAG, "Y");
        CommentType commentType1 = new CommentType();
        CommentType commentType2 = new CommentType();
        commentType1.setAwardCommentScreenFlag(Boolean.valueOf(true));
        commentType1.setDescription(this.SOME_COMMENTS);
        commentType1.setCommentTypeCode(this.ONE);
        commentType2.setAwardCommentScreenFlag(Boolean.valueOf(true));
        commentType2.setDescription(this.SOME_OTHER_COMMENTS);
        commentType2.setCommentTypeCode(this.TWO);
        this.commentTypeList.add(commentType1);
        this.commentTypeList.add(commentType2);
    }

    @After
    public void tearDown() throws Exception {
        this.awardCommentServiceImpl = null;
    }

    @Test
    public void testRetrieveCommentTypesToAwardFormForPanelHeaderDisplay() {
        final BusinessObjectService MOCKED_BUSINESS_OBJECT_SERVICE = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(MOCKED_BUSINESS_OBJECT_SERVICE)).findMatching(CommentType.class, AwardCommentServiceImplTest.this.queryMap);
                this.will(1.returnValue(AwardCommentServiceImplTest.this.commentTypeList));
            }
        });
        this.awardCommentServiceImpl.setBusinessObjectService(MOCKED_BUSINESS_OBJECT_SERVICE);
        Assert.assertTrue((this.awardCommentServiceImpl.retrieveCommentTypes().size() == 2 ? 1 : 0) != 0);
    }
}

