/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.commitments.AwardFandaRateService;
import org.kuali.kra.award.commitments.AwardFandaRateServiceImpl;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class AwardFandaRateServiceImplTest
extends KcUnitTestBase {
    private static final String FISCAL_LEAP_YEAR_STRING = "2008";
    private static final String FISCAL_NON_LEAP_YEAR_STRING = "2010";
    private static final List<String> MOCK_EXPECTED_DATE_NON_LEAP_YEAR = new ArrayList<String>();
    private static final List<String> MOCK_EXPECTED_DATE_LEAP_YEAR = new ArrayList<String>();
    private static final List<String> MOCK_EXPECTED_DATE_EMPTY = new ArrayList<String>();
    private AwardFandaRateServiceImpl awardFandaRateService;

    @Override
    @Before
    public void setUp() throws Exception {
        this.awardFandaRateService = (AwardFandaRateServiceImpl)KraServiceLocator.getService(AwardFandaRateService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.awardFandaRateService = null;
    }

    @Test
    public final void testGetStartAndEndDatesWhenValidFiscalLeapYearPassed() {
        MOCK_EXPECTED_DATE_LEAP_YEAR.add("07/01/2007");
        MOCK_EXPECTED_DATE_LEAP_YEAR.add("06/30/2008");
        Assert.assertEquals(MOCK_EXPECTED_DATE_LEAP_YEAR, (Object)this.awardFandaRateService.getStartAndEndDatesBasedOnFiscalYear(FISCAL_LEAP_YEAR_STRING));
    }

    @Test
    public final void testGetStartAndEndDatesWhenValidFiscalNonLeapYearPassed() {
        MOCK_EXPECTED_DATE_NON_LEAP_YEAR.add("07/01/2009");
        MOCK_EXPECTED_DATE_NON_LEAP_YEAR.add("06/30/2010");
        Assert.assertEquals(MOCK_EXPECTED_DATE_NON_LEAP_YEAR, (Object)this.awardFandaRateService.getStartAndEndDatesBasedOnFiscalYear(FISCAL_NON_LEAP_YEAR_STRING));
    }

    @Test
    public final void testGetStartAndEndDatesWhenInvalidFiscalYearPassed() {
        AwardFandaRateServiceImpl awardFandaRateService = new AwardFandaRateServiceImpl();
        Assert.assertEquals(MOCK_EXPECTED_DATE_EMPTY, (Object)awardFandaRateService.getStartAndEndDatesBasedOnFiscalYear(""));
    }
}

