/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.AwardNumberServiceImpl;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.dao.KraLookupDao;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class AwardNumberServiceTest {
    private Mockery context = new JUnit4Mockery();
    AwardNumberServiceImpl awardNumberServiceImpl;
    List<Award> awardList;
    Award rootAward;
    private long SEQUENCE_NUMBER = 1234L;

    @Before
    public void setUp() throws Exception {
        this.awardNumberServiceImpl = new AwardNumberServiceImpl();
        this.rootAward = new Award();
        this.rootAward.setAwardNumber("000001-00001");
        Award node1 = new Award();
        node1.setAwardNumber("000001-00002");
        Award node2 = new Award();
        node2.setAwardNumber("000001-00003");
        this.awardList = new ArrayList<Award>();
        this.awardList.add(node1);
        this.awardList.add(node2);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testGetNextAwardNumber() {
        AwardNumberService awardNumberService = this.createAwardNumberService();
        String awardNumber = awardNumberService.getNextAwardNumber();
        Assert.assertNotNull((Object)awardNumber);
        Assert.assertEquals((long)12L, (long)awardNumber.length());
        String first6Chars = awardNumber.substring(0, 6);
        Assert.assertTrue((boolean)StringUtils.isNumeric((String)first6Chars));
        String last6chars = awardNumber.substring(6, 12);
        Assert.assertEquals((Object)"-00001", (Object)last6chars);
    }

    @Test
    public final void testGenerateNextNodeNumber() {
        final KraLookupDao MOCKED_KRA_LOOKUP_DAO = (KraLookupDao)this.context.mock(KraLookupDao.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KraLookupDao)this.one(MOCKED_KRA_LOOKUP_DAO)).findCollectionUsingWildCard(Award.class, "awardNumber", "000001%", true);
                this.will(1.returnValue(AwardNumberServiceTest.this.awardList));
            }
        });
        this.awardNumberServiceImpl.setKraLookupDao(MOCKED_KRA_LOOKUP_DAO);
        Assert.assertTrue((boolean)this.awardNumberServiceImpl.getNextAwardNumberInHierarchy(this.rootAward.getAwardNumber()).equals("000001-00004"));
    }

    private AwardNumberService createAwardNumberService() {
        final SequenceAccessorService sequenceAccessorService = (SequenceAccessorService)this.context.mock(SequenceAccessorService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SequenceAccessorService)this.one(sequenceAccessorService)).getNextAvailableSequenceNumber("SEQ_AWARD_AWARD_NUMBER");
                this.will(2.returnValue((Object)AwardNumberServiceTest.this.SEQUENCE_NUMBER));
            }
        });
        AwardNumberServiceImpl awardNumberService = new AwardNumberServiceImpl();
        awardNumberService.setSequenceAccessorService(sequenceAccessorService);
        return awardNumberService;
    }
}

