/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder;
import org.kuali.kra.award.lookup.keyvalue.FrequencyCodeValuesFinder;
import org.kuali.kra.award.lookup.keyvalue.ReportClassValuesFinder;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.service.AwardReportsService;
import org.kuali.kra.service.impl.AwardReportsServiceImpl;
import org.kuali.kra.util.ValuesFinderUtility;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class AwardReportsServiceImplTest
extends AwardReportsServiceImpl {
    private static final String P_AND_I_PARAM = "6";
    public static final String MOCK_EXPECTED_STRING = "1;test1,2;test2,3;test3,4;test4,5;test5";
    public static final int MOCK_EXPECTED_NUMBER_OF_NEW_AWARD_REPORT_TERM_OBJECTS = 5;
    public static final int MOCK_EXPECTED_NUMBER_OF_NEW_AWARD_REPORT_TERM_RECIPIENT_OBJECTS = 1;
    public static final String DUMMY_REPORT_CLASS_CODE = "1";
    public static final String DUMMY_REPORT_CODE = "1";
    public static final String DUMMY_FREQUNCY_CODE = "1";
    AwardReportsService awardReportsService;
    List<KeyValue> KeyValueList;
    Map<String, Object> hashMap;
    Award award;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.award = new Award();
        this.awardReportsService = new AwardReportsServiceImpl();
        this.KeyValueList = new ArrayList<KeyValue>();
        this.hashMap = new HashMap<String, Object>();
        this.KeyValueList.add((KeyValue)new ConcreteKeyValue("1", "test1"));
        this.KeyValueList.add((KeyValue)new ConcreteKeyValue("2", "test2"));
        this.KeyValueList.add((KeyValue)new ConcreteKeyValue("3", "test3"));
        this.KeyValueList.add((KeyValue)new ConcreteKeyValue("4", "test4"));
        this.KeyValueList.add((KeyValue)new ConcreteKeyValue("5", "test5"));
        this.award.getAwardReportTermItems().add(new AwardReportTerm());
    }

    @After
    public void tearDown() throws Exception {
        this.award = null;
        this.awardReportsService = null;
        this.hashMap = null;
    }

    @Test
    public final void testProcessFrequencyBaseCodes() {
        AwardReportsServiceImpl service = new AwardReportsServiceImpl();
        Assert.assertEquals((Object)MOCK_EXPECTED_STRING, (Object)ValuesFinderUtility.processKeyValueList(this.KeyValueList));
    }

    @Test
    public final void testAddEmptyNewAwardReportTermRecipients() {
        AwardReportsServiceImpl service = new AwardReportsServiceImpl();
        service.addEmptyNewAwardReportTermRecipients(this.award, this.hashMap);
        Assert.assertTrue((boolean)this.hashMap.containsKey("newAwardReportTermRecipientsList"));
        Assert.assertEquals((long)1L, (long)((List)this.hashMap.get("newAwardReportTermRecipientsList")).size());
    }

    @Test
    public final void testAddEmptyNewAwardReportTerms() {
        AwardReportsServiceImpl service = new AwardReportsServiceImpl();
        service.addEmptyNewAwardReportTerms(this.hashMap, this.KeyValueList);
        Assert.assertTrue((boolean)this.hashMap.containsKey("newAwardReportTermList"));
        Assert.assertEquals((long)5L, (long)((List)this.hashMap.get("newAwardReportTermList")).size());
    }

    @Test
    public final void testAssignReportClassesForPanelHeaderDisplay() {
        AwardReportsServiceImpl service = new AwardReportsServiceImpl(){

            protected ReportClassValuesFinder getReportClassValuesFinder() {
                return new ReportClassValuesFinder(){

                    public List<KeyValue> getKeyValues() {
                        return AwardReportsServiceImplTest.this.KeyValueList;
                    }
                };
            }
        };
        service.assignReportClassesForPanelHeaderDisplay(this.hashMap);
        Assert.assertTrue((boolean)this.hashMap.containsKey("reportClasses"));
    }

    @Test
    public final void testGetFrequencyCodes() {
        AwardReportsServiceImpl service = new AwardReportsServiceImpl(){

            protected FrequencyCodeValuesFinder getFrequencyCodeValuesFinder(String reportClassCode, String reportCode) {
                return new FrequencyCodeValuesFinder(reportClassCode, reportCode){

                    public List<KeyValue> getKeyValues() {
                        return AwardReportsServiceImplTest.this.KeyValueList;
                    }
                };
            }
        };
        Assert.assertEquals((Object)MOCK_EXPECTED_STRING, (Object)service.getFrequencyCodes("1", "1"));
    }

    @Test
    public final void testGetFrequencyBaseCodes() {
        AwardReportsServiceImpl service = new AwardReportsServiceImpl(){

            protected FrequencyBaseCodeValuesFinder getFrequencyBaseCodeValuesFinder(String frequencyCode) {
                return new FrequencyBaseCodeValuesFinder(frequencyCode){

                    public List<KeyValue> getKeyValues() {
                        return AwardReportsServiceImplTest.this.KeyValueList;
                    }
                };
            }
        };
        Assert.assertEquals((Object)MOCK_EXPECTED_STRING, (Object)service.getFrequencyBaseCodes("1"));
    }

    @Test
    public final void testSetReportClassForPaymentsAndInvoicesSubPanelSuccess() {
        AwardReportsServiceImpl service = new AwardReportsServiceImpl();
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parameterService)).getParameterValueAsString(AwardDocument.class, "reportClassForPaymentsAndInvoices");
                this.will(4.returnValue((Object)AwardReportsServiceImplTest.P_AND_I_PARAM));
            }
        });
        final HashMap<String, String> primaryKeyField = new HashMap<String, String>();
        final ReportClass reportClass = new ReportClass();
        primaryKeyField.put("reportClassCode", P_AND_I_PARAM);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(ReportClass.class, primaryKeyField);
                this.will(5.returnValue((Object)reportClass));
            }
        });
        service.setParameterService(parameterService);
        service.setBusinessObjectService(businessObjectService);
        service.setReportClassForPaymentsAndInvoicesSubPanel(this.hashMap);
        Assert.assertTrue((boolean)this.hashMap.containsKey("reportClassForPaymentsAndInvoicesPanel"));
    }
}

