/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.AwardAmountInfoServiceImpl;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.paymentschedule.FrequencyBaseConstants;
import org.kuali.kra.scheduling.sequence.ScheduleSequence;
import org.kuali.kra.scheduling.service.ScheduleService;
import org.kuali.kra.scheduling.util.Time24HrFmt;
import org.kuali.kra.service.impl.AwardScheduleGenerationServiceImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

@RunWith(value=JMock.class)
public class AwardScheduleGenerationServiceImplTest {
    private static final int START_DATE_YEAR_2009 = 2009;
    private static final int START_DATE_YEAR_2011 = 2011;
    private static final int FIRST_DAY_OF_MONTH = 1;
    private static final int ZERO = 0;
    private static final int THIRTY_DAYS = 30;
    private static final int THREE_MONTHS = 3;
    private static final String ZERO_HOURS = "00:00";
    private static final String REPORT_CLASS_CODE_CODE_SIX = "6";
    private static final String PERIOD_IN_YEARS = "1";
    private static final String SF_269_EXPENDITURE_REPORT_CODE = "33";
    Award award;
    List<AwardReportTerm> awardReportTerms;
    AwardReportTerm newAwardReportTerm;
    Frequency frequency;
    AwardScheduleGenerationServiceImpl awardScheduleGenerationServiceImpl;
    Calendar calendar;
    Calendar calendar1;
    Map<String, java.util.Date> mapOfDates;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.award = new Award();
        this.frequency = new Frequency();
        this.awardReportTerms = new ArrayList<AwardReportTerm>();
        this.newAwardReportTerm = new AwardReportTerm();
        this.awardScheduleGenerationServiceImpl = new AwardScheduleGenerationServiceImpl();
        this.awardScheduleGenerationServiceImpl.setAwardAmountInfoService((AwardAmountInfoService)new AwardAmountInfoServiceImpl());
        this.calendar = new GregorianCalendar();
        this.calendar1 = new GregorianCalendar();
        this.setMapOfDatesOnAward(this.award);
        this.mapOfDates = new HashMap<String, java.util.Date>();
        this.awardScheduleGenerationServiceImpl.initializeDatesForThisAward(this.award, this.mapOfDates);
    }

    @After
    public void tearDown() throws Exception {
        this.frequency = null;
        this.newAwardReportTerm = null;
        this.awardReportTerms = null;
        this.awardScheduleGenerationServiceImpl = null;
        this.newAwardReportTerm = null;
        this.calendar = null;
        this.calendar1 = null;
    }

    public void setMapOfDatesOnAward(Award award) {
        this.calendar.clear();
        this.calendar.set(2009, 3, 1);
        award.setAwardEffectiveDate(new Date(this.calendar.getTimeInMillis()));
        this.calendar.clear();
        this.calendar.set(2009, 4, 1);
        award.setAwardExecutionDate(new Date(this.calendar.getTimeInMillis()));
        this.calendar.clear();
        this.calendar.set(2009, 8, 1);
        award.setProjectEndDate(new Date(this.calendar.getTimeInMillis()));
        this.calendar.clear();
        this.calendar.set(2009, 5, 1);
        award.setAwardEffectiveDate(new Date(this.calendar.getTimeInMillis()));
    }

    @Test
    public final void testGetStartDate() {
        this.newAwardReportTerm.setFrequencyBaseCode(FrequencyBaseConstants.AWARD_EXECUTION_DATE.getfrequencyBase());
        this.calendar.clear();
        this.calendar.set(2009, 4, 1);
        this.newAwardReportTerm.setFrequency(this.frequency);
        this.newAwardReportTerm.setAward(this.award);
        this.newAwardReportTerm.setDueDate(new Date(this.calendar.getTimeInMillis()));
        java.util.Date startDate = this.awardScheduleGenerationServiceImpl.getStartDate(this.newAwardReportTerm, this.mapOfDates);
        Assert.assertEquals((Object)this.calendar.getTime(), (Object)startDate);
        this.newAwardReportTerm.setFrequencyBaseCode(FrequencyBaseConstants.AWARD_EFFECTIVE_DATE.getfrequencyBase());
        this.calendar.clear();
        this.calendar.set(2009, 5, 1);
        this.newAwardReportTerm.setFrequency(this.frequency);
        this.newAwardReportTerm.setAward(this.award);
        this.newAwardReportTerm.setDueDate(new Date(this.calendar.getTimeInMillis()));
        startDate = this.awardScheduleGenerationServiceImpl.getStartDate(this.newAwardReportTerm, this.mapOfDates);
        Assert.assertEquals((Object)this.calendar.getTime(), (Object)startDate);
    }

    @Test
    public final void testGetEndDate() {
        this.calendar.clear();
        this.calendar.set(2009, 6, 1, 0, 0, 0);
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parameterService)).getParameterValueAsString(AwardDocument.class, "scheduleGenerationPeriodInYearsWhenFrequencyBaseCodeIsFinalExpirationDate");
                this.will(1.returnValue((Object)AwardScheduleGenerationServiceImplTest.PERIOD_IN_YEARS));
            }
        });
        this.awardScheduleGenerationServiceImpl.setParameterService(parameterService);
        java.util.Date endDate = this.awardScheduleGenerationServiceImpl.getEndDate(FrequencyBaseConstants.FINAL_EXPIRATION_DATE.getfrequencyBase(), this.calendar.getTime(), this.mapOfDates);
        this.calendar.add(1, 1);
        Assert.assertEquals((Object)this.calendar.getTime(), (Object)endDate);
        endDate = this.awardScheduleGenerationServiceImpl.getEndDate(FrequencyBaseConstants.AWARD_EFFECTIVE_DATE.getfrequencyBase(), this.calendar.getTime(), this.mapOfDates);
        this.calendar.clear();
        this.calendar.set(2009, 8, 1, 0, 0, 0);
        Assert.assertEquals((Object)this.calendar.getTime(), (Object)endDate);
    }

    @Test
    public final void testGetUpdatedStartDate() {
        this.calendar.clear();
        this.calendar.set(2009, 6, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2009, 6, 1, 0, 0, 0);
        this.frequency.setNumberOfDays(null);
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(null);
        this.frequency.setAdvanceNumberOfMonths(null);
        java.util.Date startDate = this.awardScheduleGenerationServiceImpl.getStartDateFromTheBaseDate(this.calendar, this.frequency);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)startDate);
        this.frequency.setNumberOfDays(Integer.valueOf(30));
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(null);
        this.frequency.setAdvanceNumberOfMonths(null);
        startDate = this.awardScheduleGenerationServiceImpl.getStartDateFromTheBaseDate(this.calendar, this.frequency);
        this.calendar1.add(6, 30);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)startDate);
        this.calendar.clear();
        this.calendar.set(2009, 6, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2009, 6, 1, 0, 0, 0);
        this.frequency.setNumberOfDays(null);
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(Integer.valueOf(30));
        this.frequency.setAdvanceNumberOfMonths(null);
        startDate = this.awardScheduleGenerationServiceImpl.getStartDateFromTheBaseDate(this.calendar, this.frequency);
        this.calendar1.add(6, -30);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)startDate);
        this.calendar.clear();
        this.calendar.set(2009, 6, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2009, 6, 1, 0, 0, 0);
        this.frequency.setNumberOfDays(null);
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(null);
        this.frequency.setAdvanceNumberOfMonths(Integer.valueOf(3));
        startDate = this.awardScheduleGenerationServiceImpl.getStartDateFromTheBaseDate(this.calendar, this.frequency);
        this.calendar1.add(2, -3);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)startDate);
    }

    @Test
    public final void testAddOffSetPeriodToStartDate() {
        this.frequency.setNumberOfDays(Integer.valueOf(30));
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(null);
        this.frequency.setAdvanceNumberOfMonths(null);
        this.calendar.clear();
        this.calendar.set(2011, 7, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2011, 7, 1, 0, 0, 0);
        this.frequency.setNumberOfDays(Integer.valueOf(30));
        this.awardScheduleGenerationServiceImpl.addOffSetPeriodToStartDate(this.frequency, this.calendar);
        this.calendar1.add(6, 30);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)this.calendar.getTime());
        this.frequency.setNumberOfDays(null);
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(Integer.valueOf(30));
        this.frequency.setAdvanceNumberOfMonths(null);
        this.calendar.clear();
        this.calendar.set(2011, 7, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2011, 7, 1, 0, 0, 0);
        this.frequency.setAdvanceNumberOfDays(Integer.valueOf(30));
        this.awardScheduleGenerationServiceImpl.addOffSetPeriodToStartDate(this.frequency, this.calendar);
        this.calendar1.add(6, -30);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)this.calendar.getTime());
        this.frequency.setNumberOfDays(null);
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(null);
        this.frequency.setAdvanceNumberOfMonths(Integer.valueOf(3));
        this.calendar.clear();
        this.calendar.set(2011, 7, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2011, 7, 1, 0, 0, 0);
        this.frequency.setAdvanceNumberOfMonths(Integer.valueOf(3));
        this.awardScheduleGenerationServiceImpl.addOffSetPeriodToStartDate(this.frequency, this.calendar);
        this.calendar1.add(2, -3);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)this.calendar.getTime());
        this.frequency.setNumberOfDays(null);
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(null);
        this.frequency.setAdvanceNumberOfMonths(null);
        this.calendar.clear();
        this.calendar.set(2011, 7, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2011, 7, 1, 0, 0, 0);
        this.awardScheduleGenerationServiceImpl.addOffSetPeriodToStartDate(this.frequency, this.calendar);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)this.calendar.getTime());
    }

    @Test
    public void testAddNumberOfMonthsToStartDate() {
        this.frequency.setNumberOfDays(null);
        this.frequency.setNumberOfMonths(Integer.valueOf(3));
        this.frequency.setAdvanceNumberOfDays(null);
        this.frequency.setAdvanceNumberOfMonths(null);
        this.calendar.clear();
        this.calendar.set(2011, 7, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2011, 7, 1, 0, 0, 0);
        this.awardScheduleGenerationServiceImpl.addNumberOfMonthsToStartDate(this.frequency, this.calendar);
        this.calendar1.add(2, 3);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)this.calendar.getTime());
        this.frequency.setNumberOfDays(null);
        this.frequency.setNumberOfMonths(null);
        this.frequency.setAdvanceNumberOfDays(null);
        this.frequency.setAdvanceNumberOfMonths(null);
        this.calendar.clear();
        this.calendar.set(2011, 7, 1, 0, 0, 0);
        this.calendar1.clear();
        this.calendar1.set(2011, 7, 1, 0, 0, 0);
        this.awardScheduleGenerationServiceImpl.addNumberOfMonthsToStartDate(this.frequency, this.calendar);
        Assert.assertEquals((Object)this.calendar1.getTime(), (Object)this.calendar.getTime());
    }

    @Test
    public void testGetDatesSuccessCaseWhenRepeatFlagIsTrue() throws ParseException {
        this.calendar.clear();
        this.calendar.set(2009, 11, 1, 0, 0, 0);
        final java.util.Date START_DATE = this.calendar.getTime();
        final int DAY_OF_MONTH = this.calendar.get(5);
        this.calendar.add(1, 1);
        final java.util.Date END_DATE = this.calendar.getTime();
        final ArrayList<java.util.Date> DATES = new ArrayList<java.util.Date>();
        DATES.add(START_DATE);
        this.frequency.setRepeatFlag(Boolean.valueOf(true));
        this.frequency.setNumberOfMonths(Integer.valueOf(3));
        this.newAwardReportTerm = new AwardReportTerm();
        this.newAwardReportTerm.setFrequency(this.frequency);
        this.newAwardReportTerm.setReportClassCode(REPORT_CLASS_CODE_CODE_SIX);
        this.newAwardReportTerm.setFrequencyBaseCode(FrequencyBaseConstants.FINAL_EXPIRATION_DATE.getfrequencyBase());
        this.newAwardReportTerm.setReportCode(SF_269_EXPENDITURE_REPORT_CODE);
        final ScheduleService scheduleService = (ScheduleService)this.context.mock(ScheduleService.class);
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ScheduleService)this.one(scheduleService)).getScheduledDates((java.util.Date)this.with(2.equal((Object)START_DATE)), (java.util.Date)this.with(2.equal((Object)END_DATE)), (Time24HrFmt)this.with(2.equal((Object)new Time24HrFmt(AwardScheduleGenerationServiceImplTest.ZERO_HOURS))), (ScheduleSequence)this.with(2.any(ScheduleSequence.class)), Integer.valueOf(this.with(2.equal((Object)DAY_OF_MONTH))));
                this.will(2.returnValue((Object)DATES));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parameterService)).getParameterValueAsString(AwardDocument.class, "scheduleGenerationPeriodInYearsWhenFrequencyBaseCodeIsFinalExpirationDate");
                this.will(3.returnValue((Object)AwardScheduleGenerationServiceImplTest.PERIOD_IN_YEARS));
            }
        });
        this.awardScheduleGenerationServiceImpl.setScheduleService(scheduleService);
        this.awardScheduleGenerationServiceImpl.setParameterService(parameterService);
        Assert.assertEquals(DATES, (Object)this.awardScheduleGenerationServiceImpl.getDates(this.newAwardReportTerm, this.mapOfDates, 0));
    }

    @Test
    public void testGetDatesSuccessCaseWhenRepeatFlagIsFalse() throws ParseException {
        this.calendar.clear();
        this.calendar.set(2009, 7, 1, 0, 0, 0);
        final java.util.Date START_DATE = this.calendar.getTime();
        final int DAY_OF_MONTH = this.calendar.get(5);
        this.calendar.add(1, 1);
        final java.util.Date END_DATE = this.calendar.getTime();
        final ArrayList<java.util.Date> DATES = new ArrayList<java.util.Date>();
        DATES.add(START_DATE);
        this.frequency.setRepeatFlag(Boolean.valueOf(false));
        this.frequency.setNumberOfMonths(Integer.valueOf(3));
        this.newAwardReportTerm = new AwardReportTerm();
        this.newAwardReportTerm.setFrequency(this.frequency);
        this.newAwardReportTerm.setReportClassCode(REPORT_CLASS_CODE_CODE_SIX);
        this.newAwardReportTerm.setFrequencyBaseCode(FrequencyBaseConstants.AWARD_EXECUTION_DATE.getfrequencyBase());
        this.newAwardReportTerm.setReportCode(SF_269_EXPENDITURE_REPORT_CODE);
        final ScheduleService scheduleService = (ScheduleService)this.context.mock(ScheduleService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ScheduleService)this.never(scheduleService)).getScheduledDates((java.util.Date)this.with(4.equal((Object)START_DATE)), (java.util.Date)this.with(4.equal((Object)END_DATE)), (Time24HrFmt)this.with(4.equal((Object)new Time24HrFmt(AwardScheduleGenerationServiceImplTest.ZERO_HOURS))), (ScheduleSequence)this.with(4.any(ScheduleSequence.class)), Integer.valueOf(this.with(4.equal((Object)DAY_OF_MONTH))));
                this.will(4.returnValue((Object)DATES));
            }
        });
        this.awardScheduleGenerationServiceImpl.setScheduleService(scheduleService);
        Assert.assertEquals(DATES, (Object)this.awardScheduleGenerationServiceImpl.getDates(this.newAwardReportTerm, this.mapOfDates, 0));
    }
}

