/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardTemplateReportTermService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class AwardTemplateReportTermServiceImplTest
extends KcUnitTestBase {
    private AwardTemplateReportTermService awardTemplateReportTermService = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.awardTemplateReportTermService = (AwardTemplateReportTermService)KraServiceLocator.getService(AwardTemplateReportTermService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.awardTemplateReportTermService = null;
        super.tearDown();
    }

    @Test
    public void testGetReportTypesUsingReportClassCode() throws Exception {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("1");
        properties.add("7");
        properties.add("5");
        properties.add("40");
        properties.add("35");
        properties.add("39");
        Collection reprotTypes = this.awardTemplateReportTermService.getReportTypesUsingReportClassCode("2");
        AwardTemplateReportTermServiceImplTest.assertEquals((long)properties.size(), (long)reprotTypes.size());
        for (Object aReportType : reprotTypes) {
            AwardTemplateReportTermServiceImplTest.assertTrue((boolean)properties.contains(aReportType));
        }
    }

    @Test
    public void testGetReportTypeForAjaxCall() throws Exception {
        String properties = ",1;None,7;Progress/Status,5;Final,40;DD 1342,35;Form provided by sponsor,39;SF 1018";
        String resultFields = this.awardTemplateReportTermService.getReportTypeForAjaxCall("2");
        AwardTemplateReportTermServiceImplTest.assertEquals((Object)properties, (Object)resultFields);
    }

    @Test
    public void testGetFrequencyUsingReportCodeAndClass() throws Exception {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("1");
        Collection frequencies = this.awardTemplateReportTermService.getFrequencyUsingReportCodeAndClass("1", "2");
        AwardTemplateReportTermServiceImplTest.assertEquals((long)properties.size(), (long)frequencies.size());
        for (Object aFrequency : frequencies) {
            AwardTemplateReportTermServiceImplTest.assertTrue((boolean)properties.contains(aFrequency));
        }
    }

    @Test
    public void testGetFrequencyForAjaxCall() throws Exception {
        String properties = ",1;None";
        String resultFields = this.awardTemplateReportTermService.getFrequencyForAjaxCall("1", "2");
        AwardTemplateReportTermServiceImplTest.assertEquals((Object)properties, (Object)resultFields);
    }

    @Test
    public void testGetFrequencyBaseUsingFrequencyCode() throws Exception {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("1");
        properties.add("2");
        properties.add("6");
        Collection frequencyBases = this.awardTemplateReportTermService.getFrequencyBaseUsingFrequencyCode("2");
        AwardTemplateReportTermServiceImplTest.assertEquals((long)properties.size(), (long)frequencyBases.size());
        for (Object aFrequencyBase : frequencyBases) {
            AwardTemplateReportTermServiceImplTest.assertTrue((boolean)properties.contains(aFrequencyBase));
        }
    }

    @Test
    public void testGetFrequencyBaseForAjaxCall() throws Exception {
        String properties = ",2;Project Start Date,1;Execution Date,6;As Required";
        String resultFields = this.awardTemplateReportTermService.getFrequencyBaseForAjaxCall("2");
        AwardTemplateReportTermServiceImplTest.assertEquals((Object)properties, (Object)resultFields);
    }
}

