/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.CoeusModule;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.impl.CustomAttributeDocumentMaintainableImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CustomAttributeDocumentMaintainableImplTest
extends KcUnitTestBase {
    Collection<CoeusModule> modules;
    CustomAttributeDocumentMaintainableImpl maintainable;
    private static final String IMPLEMENTED_MODS = "1,2,3,7,8";
    private static final String NON_IMPLEMENTED_MODS = "4,5,6,9,11";

    @Override
    @Before
    public void setUp() throws Exception {
        this.modules = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findAll(CoeusModule.class);
        this.maintainable = new CustomAttributeDocumentMaintainableImpl();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.modules = null;
        this.maintainable = null;
    }

    @Test
    public void testConvertModuleNumberToDocumentTypeCode() {
        CustomAttributeDocumentMaintainableImplTest.assertEquals((long)10L, (long)this.modules.size());
        for (CoeusModule module : this.modules) {
            String results;
            if (IMPLEMENTED_MODS.contains(module.getModuleCode())) {
                results = this.maintainable.convertModuleNumberToDocumentTypeCode(Integer.parseInt(module.getModuleCode()));
                switch (Integer.parseInt(module.getModuleCode())) {
                    case 1: {
                        CustomAttributeDocumentMaintainableImplTest.assertEquals((Object)"AWRD", (Object)results);
                        break;
                    }
                    case 2: {
                        CustomAttributeDocumentMaintainableImplTest.assertEquals((Object)"INPR", (Object)results);
                        break;
                    }
                    case 3: {
                        CustomAttributeDocumentMaintainableImplTest.assertEquals((Object)"PRDV", (Object)results);
                        break;
                    }
                    case 7: {
                        CustomAttributeDocumentMaintainableImplTest.assertEquals((Object)"PROT", (Object)results);
                        break;
                    }
                    case 8: {
                        CustomAttributeDocumentMaintainableImplTest.assertEquals((Object)"COI", (Object)results);
                        break;
                    }
                    default: {
                        CustomAttributeDocumentMaintainableImplTest.assertTrue((String)("should never get here, Current Module Number: " + module.getModuleCode()), (boolean)false);
                        break;
                    }
                }
                continue;
            }
            if (NON_IMPLEMENTED_MODS.contains(module.getModuleCode())) {
                try {
                    results = this.maintainable.convertModuleNumberToDocumentTypeCode(Integer.parseInt(module.getModuleCode()));
                    CustomAttributeDocumentMaintainableImplTest.assertTrue((String)("Current Module Number: " + module.getModuleCode()), (boolean)false);
                }
                catch (IllegalArgumentException iae) {
                    CustomAttributeDocumentMaintainableImplTest.assertTrue((String)("Current Module Number: " + module.getModuleCode()), (boolean)true);
                }
                catch (Exception e) {
                    CustomAttributeDocumentMaintainableImplTest.assertTrue((String)("Current Module Number: " + module.getModuleCode()), (boolean)false);
                }
                continue;
            }
            CustomAttributeDocumentMaintainableImplTest.assertTrue((boolean)false);
        }
    }
}

