/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.CustomAttribute;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.TestUtilities;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.service.CustomAttributeService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class CustomAttributeServiceImplTest
extends KcUnitTestBase {
    private Map<String, CustomAttributeDocument> testCustomAttributeDocuments;
    private DocumentService documentService = null;
    private CustomAttributeService customAttributeService = null;
    private BusinessObjectService businessObjectService = null;
    private ProposalDevelopmentService proposalDevelopmentService;
    private static final String TEST_DOCUMENT_TYPE_CODE = "PRDV";
    private static final String TEST_DOCUMENT_NUMBER = "2000";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.testCustomAttributeDocuments = TestUtilities.setupTestCustomAttributeDocuments();
        this.documentService = KRADServiceLocatorWeb.getDocumentService();
        this.customAttributeService = (CustomAttributeService)KraServiceLocator.getService(CustomAttributeService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        this.testCustomAttributeDocuments = null;
        this.documentService = null;
        this.customAttributeService = null;
        this.businessObjectService = null;
        super.tearDown();
    }

    @Test
    public void testGetDefaultCustomAttributesForDocumentType() throws Exception {
        Map customAttributeDocuments = this.customAttributeService.getDefaultCustomAttributeDocuments(TEST_DOCUMENT_TYPE_CODE, new ArrayList());
        CustomAttributeServiceImplTest.assertNotNull((Object)customAttributeDocuments);
        CustomAttributeServiceImplTest.assertEquals((long)this.testCustomAttributeDocuments.size(), (long)customAttributeDocuments.size());
        for (Map.Entry<String, CustomAttributeDocument> testCustomAttributeDocumentEntry : this.testCustomAttributeDocuments.entrySet()) {
            CustomAttributeDocument testCustomAttributeDocument = testCustomAttributeDocumentEntry.getValue();
            CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)customAttributeDocuments.get(testCustomAttributeDocument.getCustomAttributeId().toString());
            CustomAttributeServiceImplTest.assertNotNull((Object)customAttributeDocument);
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttributeDocument.getDocumentTypeName(), (Object)customAttributeDocument.getDocumentTypeName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttributeDocument.isRequired(), (Object)customAttributeDocument.isRequired());
            CustomAttribute testCustomAttribute = testCustomAttributeDocument.getCustomAttribute();
            CustomAttribute customAttribute = customAttributeDocument.getCustomAttribute();
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getId(), (Object)customAttribute.getId());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getName(), (Object)customAttribute.getName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLabel(), (Object)customAttribute.getLabel());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getDataTypeCode(), (Object)customAttribute.getDataTypeCode());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getDataLength(), (Object)customAttribute.getDataLength());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getGroupName(), (Object)customAttribute.getGroupName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLookupClass(), (Object)customAttribute.getLookupClass());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLookupReturn(), (Object)customAttribute.getLookupReturn());
        }
    }

    @Test
    public void testGetDefaultCustomAttributesForDocumentTypeNullDocument() throws Exception {
        Map customAttributeDocuments = this.customAttributeService.getDefaultCustomAttributeDocuments(TEST_DOCUMENT_TYPE_CODE, new ArrayList());
        CustomAttributeServiceImplTest.assertNotNull((Object)customAttributeDocuments);
        CustomAttributeServiceImplTest.assertNotNull(this.testCustomAttributeDocuments);
        CustomAttributeServiceImplTest.assertEquals((long)this.testCustomAttributeDocuments.size(), (long)customAttributeDocuments.size());
        for (Map.Entry<String, CustomAttributeDocument> testCustomAttributeDocumentEntry : this.testCustomAttributeDocuments.entrySet()) {
            CustomAttributeDocument testCustomAttributeDocument = testCustomAttributeDocumentEntry.getValue();
            CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)customAttributeDocuments.get(testCustomAttributeDocument.getCustomAttributeId().toString());
            CustomAttributeServiceImplTest.assertNotNull((Object)customAttributeDocument);
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttributeDocument.getDocumentTypeName(), (Object)customAttributeDocument.getDocumentTypeName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttributeDocument.isRequired(), (Object)customAttributeDocument.isRequired());
            CustomAttribute testCustomAttribute = testCustomAttributeDocument.getCustomAttribute();
            CustomAttribute customAttribute = customAttributeDocument.getCustomAttribute();
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getId(), (Object)customAttribute.getId());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getName(), (Object)customAttribute.getName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLabel(), (Object)customAttribute.getLabel());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getDataTypeCode(), (Object)customAttribute.getDataTypeCode());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getDataLength(), (Object)customAttribute.getDataLength());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getGroupName(), (Object)customAttribute.getGroupName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLookupClass(), (Object)customAttribute.getLookupClass());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLookupReturn(), (Object)customAttribute.getLookupReturn());
        }
    }

    @Test
    public void testGetDefaultCustomAttributesFromNewDocument() throws Exception {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.documentService.getNewDocument(ProposalDevelopmentDocument.class);
        document.initialize();
        Map customAttributeDocuments = document.getCustomAttributeDocuments();
        CustomAttributeServiceImplTest.assertNotNull((Object)customAttributeDocuments);
        CustomAttributeServiceImplTest.assertNotNull(this.testCustomAttributeDocuments);
        CustomAttributeServiceImplTest.assertEquals((long)this.testCustomAttributeDocuments.size(), (long)customAttributeDocuments.size());
        for (Map.Entry<String, CustomAttributeDocument> testCustomAttributeDocumentEntry : this.testCustomAttributeDocuments.entrySet()) {
            CustomAttributeDocument testCustomAttributeDocument = testCustomAttributeDocumentEntry.getValue();
            CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)customAttributeDocuments.get(testCustomAttributeDocument.getCustomAttributeId().toString());
            CustomAttributeServiceImplTest.assertNotNull((Object)customAttributeDocument);
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttributeDocument.getDocumentTypeName(), (Object)customAttributeDocument.getDocumentTypeName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttributeDocument.isRequired(), (Object)customAttributeDocument.isRequired());
            CustomAttribute testCustomAttribute = testCustomAttributeDocument.getCustomAttribute();
            CustomAttribute customAttribute = customAttributeDocument.getCustomAttribute();
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getId(), (Object)customAttribute.getId());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getName(), (Object)customAttribute.getName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLabel(), (Object)customAttribute.getLabel());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getDataTypeCode(), (Object)customAttribute.getDataTypeCode());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getDataLength(), (Object)customAttribute.getDataLength());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getGroupName(), (Object)customAttribute.getGroupName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLookupClass(), (Object)customAttribute.getLookupClass());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLookupReturn(), (Object)customAttribute.getLookupReturn());
        }
    }

    @Test
    public void testGetDefaultCustomAttributesFromSavedDocument() throws Exception {
        ProposalDevelopmentDocument document = this.getDocument();
        Map customAttributeDocuments = document.getCustomAttributeDocuments();
        CustomAttributeServiceImplTest.assertNotNull((Object)customAttributeDocuments);
        CustomAttributeServiceImplTest.assertNotNull(this.testCustomAttributeDocuments);
        CustomAttributeServiceImplTest.assertEquals((long)this.testCustomAttributeDocuments.size(), (long)customAttributeDocuments.size());
        for (Map.Entry<String, CustomAttributeDocument> testCustomAttributeDocumentEntry : this.testCustomAttributeDocuments.entrySet()) {
            CustomAttributeDocument testCustomAttributeDocument = testCustomAttributeDocumentEntry.getValue();
            CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)customAttributeDocuments.get(testCustomAttributeDocument.getCustomAttributeId().toString());
            CustomAttributeServiceImplTest.assertNotNull((Object)customAttributeDocument);
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttributeDocument.getDocumentTypeName(), (Object)customAttributeDocument.getDocumentTypeName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttributeDocument.isRequired(), (Object)customAttributeDocument.isRequired());
            CustomAttribute testCustomAttribute = testCustomAttributeDocument.getCustomAttribute();
            CustomAttribute customAttribute = customAttributeDocument.getCustomAttribute();
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getId(), (Object)customAttribute.getId());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getName(), (Object)customAttribute.getName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLabel(), (Object)customAttribute.getLabel());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getDataTypeCode(), (Object)customAttribute.getDataTypeCode());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getDataLength(), (Object)customAttribute.getDataLength());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getGroupName(), (Object)customAttribute.getGroupName());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLookupClass(), (Object)customAttribute.getLookupClass());
            CustomAttributeServiceImplTest.assertEquals((Object)testCustomAttribute.getLookupReturn(), (Object)customAttribute.getLookupReturn());
        }
    }

    @Test
    public void testGetLookupReturns() throws Exception {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("degreeCode");
        properties.add("degreeLevel");
        properties.add("description");
        List lookupReturnFields = this.customAttributeService.getLookupReturns("org.kuali.kra.bo.DegreeType");
        CustomAttributeServiceImplTest.assertEquals((long)properties.size(), (long)lookupReturnFields.size());
        for (Object returnField : lookupReturnFields) {
            CustomAttributeServiceImplTest.assertTrue((boolean)properties.contains(returnField));
        }
    }

    @Test
    public void testGetLookupReturnsForAjaxCall() throws Exception {
        String properties = ",degreeCode;Degree Code,degreeLevel;Degree Level,description;Description";
        String lookupReturnFields = this.customAttributeService.getLookupReturnsForAjaxCall("org.kuali.kra.bo.DegreeType");
        CustomAttributeServiceImplTest.assertEquals((Object)properties, (Object)lookupReturnFields);
    }

    private ProposalDevelopmentDocument getDocument() throws WorkflowException {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.documentService.getNewDocument("ProposalDevelopmentDocument");
        document.initialize();
        Date requestedStartDateInitial = new Date(System.currentTimeMillis());
        Date requestedEndDateInitial = new Date(System.currentTimeMillis());
        this.setBaseDocumentFields(document, "ProposalDevelopmentDocumentTest test doc", "005770", "project title", requestedStartDateInitial, requestedEndDateInitial, "1", "1", "000001", "000120");
        this.documentService.saveDocument((Document)document);
        ProposalDevelopmentDocument savedDocument = (ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(document.getDocumentNumber());
        return savedDocument;
    }

    private void setBaseDocumentFields(ProposalDevelopmentDocument document, String description, String sponsorCode, String title, Date requestedStartDateInitial, Date requestedEndDateInitial, String activityTypeCode, String proposalTypeCode, String ownedByUnit, String primeSponsorCode) {
        document.getDocumentHeader().setDocumentDescription(description);
        document.getDevelopmentProposal().setSponsorCode(sponsorCode);
        document.getDevelopmentProposal().setTitle(title);
        document.getDevelopmentProposal().setRequestedStartDateInitial(requestedStartDateInitial);
        document.getDevelopmentProposal().setRequestedEndDateInitial(requestedEndDateInitial);
        document.getDevelopmentProposal().setActivityTypeCode(activityTypeCode);
        document.getDevelopmentProposal().setProposalTypeCode(proposalTypeCode);
        document.getDevelopmentProposal().setOwnedByUnitNumber(ownedByUnit);
        document.getDevelopmentProposal().setPrimeSponsorCode(primeSponsorCode);
        this.proposalDevelopmentService.initializeUnitOrganizationLocation(document);
        this.proposalDevelopmentService.initializeProposalSiteNumbers(document);
    }
}

