/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Calendar;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.FiscalYearMonthService;
import org.kuali.kra.service.impl.FiscalYearMonthServiceImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;

public class FiscalYearMonthServiceImplTest
extends KcUnitTestBase {
    FiscalYearMonthServiceImpl fiscalYearMonthService;

    @Override
    @Before
    public void setUp() throws Exception {
        this.fiscalYearMonthService = (FiscalYearMonthServiceImpl)KraServiceLocator.getService(FiscalYearMonthService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.fiscalYearMonthService = null;
    }

    @Test
    public void testGetFiscalYearMonth() {
        Integer result = this.fiscalYearMonthService.getFiscalYearMonth();
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(6), (Object)result);
    }

    @Test
    public void testGetFiscalYearFromDate() {
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(6), (Object)this.fiscalYearMonthService.getFiscalYearMonth());
        Calendar january = Calendar.getInstance();
        january.set(2, 0);
        january.set(5, 1);
        january.set(1, 2012);
        Integer result = this.fiscalYearMonthService.getFiscalYearFromDate(january);
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(2012), (Object)result);
        Calendar july = Calendar.getInstance();
        july.set(2, 6);
        july.set(5, 1);
        july.set(1, 2012);
        result = this.fiscalYearMonthService.getFiscalYearFromDate(july);
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(2013), (Object)result);
    }

    @Test
    public void testGetCurrentFiscalData1() {
        Calendar july = Calendar.getInstance();
        july.set(2, 6);
        july.set(5, 1);
        july.set(1, 2012);
        Map data = this.fiscalYearMonthService.getCurrentFiscalData(july);
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(0), data.get("month"));
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(2013), data.get("year"));
        Calendar june = Calendar.getInstance();
        june.set(2, 5);
        june.set(5, 1);
        june.set(1, 2012);
        data = this.fiscalYearMonthService.getCurrentFiscalData(june);
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(11), data.get("month"));
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(2012), data.get("year"));
        Calendar august = Calendar.getInstance();
        august.set(2, 7);
        august.set(5, 1);
        august.set(1, 2012);
        data = this.fiscalYearMonthService.getCurrentFiscalData(august);
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(1), data.get("month"));
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(2013), data.get("year"));
    }

    @Test
    public void testGetFiscalYearStartDate1() {
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(6), (Object)this.fiscalYearMonthService.getFiscalYearMonth());
        Calendar result = this.fiscalYearMonthService.getFiscalYearStartDate(Integer.valueOf(2010));
        FiscalYearMonthServiceImplTest.assertEquals((long)6L, (long)result.get(2));
        FiscalYearMonthServiceImplTest.assertEquals((long)2009L, (long)result.get(1));
        FiscalYearMonthServiceImplTest.assertEquals((long)1L, (long)result.get(5));
    }

    @Test
    public void testGetFiscalYearEndDate1() {
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(6), (Object)this.fiscalYearMonthService.getFiscalYearMonth());
        Calendar result = this.fiscalYearMonthService.getFiscalYearEndDate(Integer.valueOf(2010));
        FiscalYearMonthServiceImplTest.assertEquals((long)5L, (long)result.get(2));
        FiscalYearMonthServiceImplTest.assertEquals((long)2010L, (long)result.get(1));
        FiscalYearMonthServiceImplTest.assertEquals((long)30L, (long)result.get(5));
    }

    @Test
    public void testGetCurrentFiscalData2() {
        Parameter parm = this.getParameterService().getParameter("KC-GEN", "Document", "KC_FISCAL_START_MONTH");
        Parameter.Builder parameterForUpdate = Parameter.Builder.create((ParameterContract)parm);
        parameterForUpdate.setValue("0");
        this.getParameterService().updateParameter(parameterForUpdate.build());
        Calendar january = Calendar.getInstance();
        january.set(2, 0);
        january.set(5, 1);
        january.set(1, 2012);
        Map data = this.fiscalYearMonthService.getCurrentFiscalData(january);
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(0), data.get("month"));
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(2012), data.get("year"));
        Calendar december = Calendar.getInstance();
        december.set(2, 11);
        december.set(5, 1);
        december.set(1, 2012);
        data = this.fiscalYearMonthService.getCurrentFiscalData(december);
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(11), data.get("month"));
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(2012), data.get("year"));
        Calendar july = Calendar.getInstance();
        july.set(2, 6);
        july.set(5, 1);
        july.set(1, 2012);
        data = this.fiscalYearMonthService.getCurrentFiscalData(july);
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(6), data.get("month"));
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(2012), data.get("year"));
    }

    @Test
    public void testGetFiscalYearStartDate2() {
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(0), (Object)this.fiscalYearMonthService.getFiscalYearMonth());
        Calendar result = this.fiscalYearMonthService.getFiscalYearStartDate(Integer.valueOf(2010));
        FiscalYearMonthServiceImplTest.assertEquals((long)0L, (long)result.get(2));
        FiscalYearMonthServiceImplTest.assertEquals((long)2010L, (long)result.get(1));
        FiscalYearMonthServiceImplTest.assertEquals((long)1L, (long)result.get(5));
    }

    @Test
    public void testGetFiscalYearEndDate2() {
        FiscalYearMonthServiceImplTest.assertEquals((Object)new Integer(0), (Object)this.fiscalYearMonthService.getFiscalYearMonth());
        Calendar result = this.fiscalYearMonthService.getFiscalYearEndDate(Integer.valueOf(2010));
        FiscalYearMonthServiceImplTest.assertEquals((long)11L, (long)result.get(2));
        FiscalYearMonthServiceImplTest.assertEquals((long)2010L, (long)result.get(1));
        FiscalYearMonthServiceImplTest.assertEquals((long)31L, (long)result.get(5));
    }
}

