/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.impl.KcPersonServiceImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class KcPersonServiceImplTest
extends KcUnitTestBase {
    private KcPersonService service;
    private KcPersonServiceImpl service2;

    @Before
    public void getServices() throws Exception {
        this.service = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        this.service2 = (KcPersonServiceImpl)KraServiceLocator.getService(KcPersonService.class);
    }

    @Test
    public void testCorrectClass() {
        KcPersonServiceImplTest.assertTrue((String)"Should be the same", (boolean)this.service.getClass().equals(KcPersonServiceImpl.class));
    }

    @Test
    public void testGetKcPersons() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("names.nameCode", "PRFR");
        List kcPersons = this.service.getKcPersons(fieldValues);
        Iterator i = kcPersons.iterator();
        boolean foundExpectedPerson = false;
        while (i.hasNext()) {
            KcPerson person = (KcPerson)i.next();
            if (!"admin".equals(person.getUserName())) continue;
            foundExpectedPerson = true;
        }
        KcPersonServiceImplTest.assertTrue((String)"Should have found 'admin'", (boolean)foundExpectedPerson);
    }

    @Test
    public void testGetKcPersonByUserName() {
        String userName = "quickstart";
        KcPerson person = this.service.getKcPersonByUserName(userName);
        KcPersonServiceImplTest.assertTrue((String)("Should have found 'quickstart', but found:" + person.getUserName()), (boolean)userName.equals(person.getUserName()));
    }

    @Test
    public void testGetKcPersonByPersonId() {
        String personID = "10000000002";
        String expectedUserName = "jtester";
        KcPerson person = this.service.getKcPersonByPersonId(personID);
        KcPersonServiceImplTest.assertTrue((String)("Should have found:" + expectedUserName + ", but found:" + person.getUserName()), (boolean)expectedUserName.equals(person.getUserName()));
    }
}

