/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.service.impl.KcPessimisticLockServiceImpl;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class KcPessimisticLockServiceImplTest {
    private static final long ONE_DAY = 86400000L;
    private Mockery context = new JUnit4Mockery();
    private List<PessimisticLock> locks;
    private Timestamp cronJobTime;

    @Before
    public void setUp() {
        long now = System.currentTimeMillis();
        this.cronJobTime = new Timestamp(now);
        this.locks = new ArrayList<PessimisticLock>();
        this.locks.add(this.createPessimisticLock(now - 43200000L));
        this.locks.add(this.createPessimisticLock(now - 172800000L));
        this.locks.add(this.createPessimisticLock(now - 86399999L));
        this.locks.add(this.createPessimisticLock(now - 86400001L));
    }

    private PessimisticLock createPessimisticLock(long timestamp) {
        PessimisticLock lock = new PessimisticLock();
        lock.setGeneratedTimestamp(new Timestamp(timestamp));
        return lock;
    }

    @Test
    public void testExpiredLocks() {
        KcPessimisticLockServiceImpl pessimisticLockService = new KcPessimisticLockServiceImpl();
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parameterService)).getParameterValueAsString(ProposalDevelopmentDocument.class, "pessimisticLocking.expirationAge");
                this.will(1.returnValue((Object)"1440"));
            }
        });
        pessimisticLockService.setParameterService(parameterService);
        final DateTimeService dateTimeService = (DateTimeService)this.context.mock(DateTimeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DateTimeService)this.one(dateTimeService)).getCurrentTimestamp();
                this.will(2.returnValue((Object)KcPessimisticLockServiceImplTest.this.cronJobTime));
            }
        });
        pessimisticLockService.setDateTimeService(dateTimeService);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findAll(PessimisticLock.class);
                this.will(3.returnValue((Object)KcPessimisticLockServiceImplTest.this.locks));
                ((BusinessObjectService)this.one(businessObjectService)).delete((PersistableBusinessObject)KcPessimisticLockServiceImplTest.this.locks.get(1));
                ((BusinessObjectService)this.one(businessObjectService)).delete((PersistableBusinessObject)KcPessimisticLockServiceImplTest.this.locks.get(3));
            }
        });
        pessimisticLockService.setBusinessObjectService(businessObjectService);
        pessimisticLockService.clearExpiredLocks();
    }
}

