/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.sql.Date;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class KraAuthorizationServiceImplTest
extends KcUnitTestBase {
    private KraAuthorizationService kraAuthService;
    private IdentityService identityManagementService;
    private RoleService roleManagementService;
    private ProposalDevelopmentService proposalDevelopmentService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        this.proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
        this.identityManagementService = (IdentityService)KraServiceLocator.getService(IdentityService.class);
        this.roleManagementService = (RoleService)KraServiceLocator.getService(RoleService.class);
    }

    @Test
    public void testGetUsernames() throws Exception {
        ProposalDevelopmentDocument doc = this.createProposal("Proposal-1", "000001");
        List usernames = this.kraAuthService.getUserNames((Permissionable)doc, "Aggregator");
        KraAuthorizationServiceImplTest.assertTrue((usernames.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddRole() throws Exception {
        ProposalDevelopmentDocument doc = this.createProposal("Proposal-2", "000001");
        Principal userMajors = this.identityManagementService.getPrincipalByPrincipalName("majors");
        this.kraAuthService.addRole(userMajors.getPrincipalId(), "Aggregator", (Permissionable)doc);
        List usernames = this.kraAuthService.getUserNames((Permissionable)doc, "Aggregator");
        KraAuthorizationServiceImplTest.assertTrue((usernames.size() == 2 ? 1 : 0) != 0);
        KraAuthorizationServiceImplTest.assertTrue((boolean)usernames.contains("majors"));
    }

    @Test
    public void testAddNarrativeWriterRole() throws Exception {
        ProposalDevelopmentDocument doc = this.createProposal("Proposal-3", "000001");
        Principal userChew = this.identityManagementService.getPrincipalByPrincipalName("chew");
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Narrative Writer", (Permissionable)doc);
        List usernames = this.kraAuthService.getUserNames((Permissionable)doc, "Narrative Writer");
        KraAuthorizationServiceImplTest.assertTrue((usernames.size() == 1 ? 1 : 0) != 0);
        KraAuthorizationServiceImplTest.assertTrue((boolean)usernames.contains("chew"));
    }

    @Test
    public void testRemoveRole() throws Exception {
        ProposalDevelopmentDocument currentDoc = this.createProposal("Proposal-3", "000001");
        this.kraAuthService.removeRole(GlobalVariables.getUserSession().getPrincipalId(), "Aggregator", (Permissionable)currentDoc);
        List names = this.kraAuthService.getUserNames((Permissionable)currentDoc, "Aggregator");
        KraAuthorizationServiceImplTest.assertTrue((names.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNarrativeWriterRole() throws Exception {
        Principal userChew = this.identityManagementService.getPrincipalByPrincipalName("chew");
        ProposalDevelopmentDocument currentDoc = this.createProposal("Proposal-3", "000001");
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Narrative Writer", (Permissionable)currentDoc);
        List usernames = this.kraAuthService.getUserNames((Permissionable)currentDoc, "Narrative Writer");
        KraAuthorizationServiceImplTest.assertTrue((usernames.size() == 1 ? 1 : 0) != 0);
        KraAuthorizationServiceImplTest.assertTrue((boolean)usernames.contains("chew"));
        this.kraAuthService.removeRole(userChew.getPrincipalId(), "Narrative Writer", (Permissionable)currentDoc);
        List names = this.kraAuthService.getUserNames((Permissionable)currentDoc, "Narrative Writer");
        KraAuthorizationServiceImplTest.assertTrue((names.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHasPermission() throws Exception {
        Principal userChew = this.identityManagementService.getPrincipalByPrincipalName("chew");
        ProposalDevelopmentDocument doc = this.createProposal("Proposal-4", "000001");
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Narrative Writer", (Permissionable)doc);
        KraAuthorizationServiceImplTest.assertTrue((boolean)this.kraAuthService.hasPermission(userChew.getPrincipalId(), (Permissionable)doc, "Modify Narrative"));
        KraAuthorizationServiceImplTest.assertFalse((boolean)this.kraAuthService.hasPermission(userChew.getPrincipalId(), (Permissionable)doc, "Modify Budget"));
    }

    @Test
    public void testHasRole() throws Exception {
        ProposalDevelopmentDocument doc = this.createProposal("Proposal-5", "000001");
        Principal userChew = this.identityManagementService.getPrincipalByPrincipalName("chew");
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Budget Creator", (Permissionable)doc);
        KraAuthorizationServiceImplTest.assertTrue((boolean)this.kraAuthService.hasRole(userChew.getPrincipalId(), (Permissionable)doc, "Budget Creator"));
    }

    @Test
    public void testGetRoles() throws Exception {
        ProposalDevelopmentDocument doc = this.createProposal("Proposal-6", "000001");
        Principal userChew = this.identityManagementService.getPrincipalByPrincipalName("chew");
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Narrative Writer", (Permissionable)doc);
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Budget Creator", (Permissionable)doc);
        List roles = this.kraAuthService.getRoles(userChew.getPrincipalId(), (Permissionable)doc);
        KraAuthorizationServiceImplTest.assertTrue((roles.size() == 2 ? 1 : 0) != 0);
        KraAuthorizationServiceImplTest.assertTrue((boolean)roles.contains("Narrative Writer"));
        KraAuthorizationServiceImplTest.assertTrue((boolean)roles.contains("Budget Creator"));
    }

    @Test
    public void testGetPersonsInRole() throws Exception {
        ProposalDevelopmentDocument doc = this.createProposal("Proposal-7", "000001");
        Principal userChew = this.identityManagementService.getPrincipalByPrincipalName("chew");
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Aggregator", (Permissionable)doc);
        List persons = this.kraAuthService.getPersonsInRole((Permissionable)doc, "Aggregator");
        KraAuthorizationServiceImplTest.assertEquals((long)2L, (long)persons.size());
    }

    @Test
    public void testGetAllRolePersons() throws Exception {
        ProposalDevelopmentDocument doc = this.createProposal("Proposal-8", "000001");
        Principal userChew = this.identityManagementService.getPrincipalByPrincipalName("chew");
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Narrative Writer", (Permissionable)doc);
        this.kraAuthService.addRole(userChew.getPrincipalId(), "Budget Creator", (Permissionable)doc);
        Principal userMajors = this.identityManagementService.getPrincipalByPrincipalName("majors");
        this.kraAuthService.addRole(userMajors.getPrincipalId(), "Viewer", (Permissionable)doc);
        Principal userWoods = this.identityManagementService.getPrincipalByPrincipalName("woods");
        this.kraAuthService.addRole(userWoods.getPrincipalId(), "Aggregator", (Permissionable)doc);
        List rolePersonsList = this.kraAuthService.getAllRolePersons((Permissionable)doc);
        KraAuthorizationServiceImplTest.assertEquals((long)5L, (long)rolePersonsList.size());
        for (RolePersons rolePersons : rolePersonsList) {
            if (rolePersons.getAggregator() != null) {
                List aggregators = rolePersons.getAggregator();
                KraAuthorizationServiceImplTest.assertEquals((long)2L, (long)aggregators.size());
                KraAuthorizationServiceImplTest.assertTrue((boolean)aggregators.contains("woods"));
                KraAuthorizationServiceImplTest.assertTrue((boolean)aggregators.contains("quickstart"));
                continue;
            }
            if (rolePersons.getViewer() != null) {
                List viewer = rolePersons.getViewer();
                KraAuthorizationServiceImplTest.assertEquals((long)1L, (long)viewer.size());
                KraAuthorizationServiceImplTest.assertTrue((boolean)viewer.contains("majors"));
                continue;
            }
            if (rolePersons.getBudgetcreator() != null) {
                List budgetCreator = rolePersons.getBudgetcreator();
                KraAuthorizationServiceImplTest.assertEquals((long)1L, (long)budgetCreator.size());
                KraAuthorizationServiceImplTest.assertTrue((boolean)budgetCreator.contains("chew"));
                continue;
            }
            if (rolePersons.getNarrativewriter() == null) continue;
            List narrativeWriter = rolePersons.getNarrativewriter();
            KraAuthorizationServiceImplTest.assertEquals((long)1L, (long)narrativeWriter.size());
            KraAuthorizationServiceImplTest.assertTrue((boolean)narrativeWriter.contains("chew"));
        }
    }

    private void initializeProposalUsers(ProposalDevelopmentDocument doc) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        this.kraAuthService.addRole(userId, "Aggregator", (Permissionable)doc);
    }

    private ProposalDevelopmentDocument createProposalWithSecondRole(String documentDescription, String leadUnit, String secondRole, String roleRecipientId) throws Exception {
        ProposalDevelopmentDocument doc = this.createProposal(documentDescription, leadUnit);
        this.kraAuthService.addRole(roleRecipientId, secondRole, (Permissionable)doc);
        return doc;
    }

    private ProposalDevelopmentDocument createProposal(String documentDescription, String leadUnitNumber) throws Exception {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.getDocumentService().getNewDocument("ProposalDevelopmentDocument");
        Date requestedStartDateInitial = new Date(System.currentTimeMillis());
        Date requestedEndDateInitial = new Date(System.currentTimeMillis());
        document.getDocumentHeader().setDocumentDescription(documentDescription);
        document.getDevelopmentProposal().setSponsorCode("000162");
        document.getDevelopmentProposal().setTitle("project title");
        document.getDevelopmentProposal().setRequestedStartDateInitial(requestedStartDateInitial);
        document.getDevelopmentProposal().setRequestedEndDateInitial(requestedEndDateInitial);
        document.getDevelopmentProposal().setActivityTypeCode("1");
        document.getDevelopmentProposal().setProposalTypeCode("1");
        document.getDevelopmentProposal().setOwnedByUnitNumber(leadUnitNumber);
        document.getDevelopmentProposal().setPrimeSponsorCode("000120");
        this.proposalDevelopmentService.initializeUnitOrganizationLocation(document);
        this.proposalDevelopmentService.initializeProposalSiteNumbers(document);
        this.getDocumentService().saveDocument((Document)document);
        this.initializeProposalUsers(document);
        this.getDocumentService().saveDocument((Document)document);
        ProposalDevelopmentDocument savedDocument = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(document.getDocumentNumber());
        KraAuthorizationServiceImplTest.assertNotNull((Object)savedDocument);
        return savedDocument;
    }
}

