/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeMembershipExpertise;
import org.kuali.kra.committee.bo.CommitteeResearchArea;
import org.kuali.kra.dao.ResearchAreaReferencesDao;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.service.impl.ResearchAreasServiceImpl;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.service.ResearchAreaCurrentReferencerHolderBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class ResearchAreasServiceTest {
    private Mockery context = new JUnit4Mockery();
    private static String RESEARCH_AREAS_04_CHILDREN = "<h3>04.02 %3A Architecture %4A true</h3><h3>04.03 %3A CityUrban %4A true</h3><h3>04.04 %3A Environmental Design %4A true</h3><h3>04.05 %3A Interior Architecture %4A true</h3><h3>04.06 %3A Landscape Architecture %4A true</h3><h3>04.08 %3A Architectural History and Criticism %4A true</h3><h3>04.09 %3A Architectural TechnologyTechnician %4A true</h3><h3>04.99 %3A Architecture and Related Services %4A true</h3>";

    @Test
    public void testIsResearchAreaExistFalse() throws Exception {
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("researchAreaCode", "03.99");
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(ResearchArea.class, fieldValues);
                this.will(1.returnValue((Object)new ResearchArea("03.99", "03.", "", true)));
                fieldValues = new HashMap();
                fieldValues.put("parentResearchAreaCode", "03.");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(ResearchArea.class, fieldValues, "researchAreaCode", true);
                this.will(1.returnValue((Object)ResearchAreasServiceTest.this.getSubResearchAreasFor03()));
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        Assert.assertFalse((boolean)researchAreasService.isResearchAreaExist("03.99", "03."));
    }

    @Test
    public void testIsResearchAreaExistTrue() throws Exception {
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("researchAreaCode", "04.99");
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(ResearchArea.class, fieldValues);
                this.will(2.returnValue((Object)new ResearchArea("04.99", "04.", "", true)));
                fieldValues = new HashMap();
                fieldValues.put("parentResearchAreaCode", "03.");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(ResearchArea.class, fieldValues, "researchAreaCode", true);
                this.will(2.returnValue((Object)ResearchAreasServiceTest.this.getSubResearchAreasFor03()));
                fieldValues = new HashMap();
                fieldValues.put("parentResearchAreaCode", "03.99");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(ResearchArea.class, fieldValues, "researchAreaCode", true);
                this.will(2.returnValue(new ArrayList()));
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        Assert.assertTrue((boolean)researchAreasService.isResearchAreaExist("04.99", "03."));
    }

    @Test
    public void testGetSubResearchAreasForTreeView() throws Exception {
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("parentResearchAreaCode", "04.");
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(ResearchArea.class, fieldValues, "researchAreaCode", true);
                this.will(3.returnValue((Object)ResearchAreasServiceTest.this.getSubResearchAreasFor04()));
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        Assert.assertEquals((Object)researchAreasService.getSubResearchAreasForTreeView("04.", false), (Object)RESEARCH_AREAS_04_CHILDREN);
    }

    private List<ResearchArea> getSubResearchAreasFor04() {
        ArrayList<ResearchArea> researchAreasList = new ArrayList<ResearchArea>();
        researchAreasList.add(new ResearchArea("04.02", "04.", "Architecture", true));
        researchAreasList.add(new ResearchArea("04.03", "04.", "CityUrban", true));
        researchAreasList.add(new ResearchArea("04.04", "04.", "Environmental Design", true));
        researchAreasList.add(new ResearchArea("04.05", "04.", "Interior Architecture", true));
        researchAreasList.add(new ResearchArea("04.06", "04.", "Landscape Architecture", true));
        researchAreasList.add(new ResearchArea("04.08", "04.", "Architectural History and Criticism", true));
        researchAreasList.add(new ResearchArea("04.09", "04.", "Architectural TechnologyTechnician", true));
        researchAreasList.add(new ResearchArea("04.99", "04.", "Architecture and Related Services", true));
        return researchAreasList;
    }

    private List<ResearchArea> getSubResearchAreasFor03() {
        ArrayList<ResearchArea> researchAreasList = new ArrayList<ResearchArea>();
        researchAreasList.add(new ResearchArea("03.99", "03.", "Architecture and Related Services", true));
        return researchAreasList;
    }

    @Test
    public void testRaCreate() throws Exception {
        String raChangeXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RaChanges><RaChangesElement><RaCreate><Code>04.123</Code><ParentCode>04.</ParentCode><Description>Sample research area</Description><Active>true</Active></RaCreate></RaChangesElement></RaChanges>";
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ResearchArea createResearchArea = new ResearchArea("04.123", "04.", "Sample research area", true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)createResearchArea);
                ResearchArea parentResearchArea = new ResearchArea("04.", "", "Parent", true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"04.");
                this.will(4.returnValue((Object)parentResearchArea));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)parentResearchArea);
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        researchAreasService.saveResearchAreas(raChangeXML);
    }

    @Test
    public void testRaUpdateDescription() throws Exception {
        String raChangeXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RaChanges><RaChangesElement><RaUpdateDescription><Code>05.12</Code><Description>new description</Description></RaUpdateDescription></RaChangesElement></RaChanges>";
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ResearchArea updateDescriptionResearchArea = new ResearchArea("05.12", "05.", "Sample research area", true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"05.12");
                this.will(5.returnValue((Object)updateDescriptionResearchArea));
                updateDescriptionResearchArea.setDescription("new description");
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)updateDescriptionResearchArea);
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        researchAreasService.saveResearchAreas(raChangeXML);
    }

    @Test
    public void testRaUpdateActiveIndicator() throws Exception {
        String raChangeXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RaChanges><RaChangesElement><RaUpdateActiveIndicator><Code>05.12</Code><Active>true</Active></RaUpdateActiveIndicator></RaChangesElement></RaChanges>";
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ResearchArea updateActiveResearchArea = new ResearchArea("05.12", "05.", "Sample research area", false);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"05.12");
                this.will(6.returnValue((Object)updateActiveResearchArea));
                updateActiveResearchArea.setActive(true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)updateActiveResearchArea);
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        researchAreasService.saveResearchAreas(raChangeXML);
    }

    @Test
    public void testRaUpdateParent() throws Exception {
        String raChangeXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RaChanges><RaChangesElement><RaUpdateParent><Code>03.24</Code><OldParent>03.</OldParent><NewParent>07.</NewParent></RaUpdateParent></RaChangesElement></RaChanges>";
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ResearchArea updateParentResearchArea = new ResearchArea("03.24", "03.", "Sample research area", true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"03.24");
                this.will(7.returnValue((Object)updateParentResearchArea));
                updateParentResearchArea.setParentResearchAreaCode("07.");
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)updateParentResearchArea);
                ResearchArea newParentResearchArea = new ResearchArea("07.", "", "Parent", true);
                newParentResearchArea.setHasChildrenFlag(false);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"07.");
                this.will(7.returnValue((Object)newParentResearchArea));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)newParentResearchArea);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("parentResearchAreaCode", "03.");
                ((BusinessObjectService)this.oneOf(businessObjectService)).countMatching(ResearchArea.class, fieldValues);
                this.will(7.returnValue((Object)0));
                ResearchArea oldParentResearchArea = new ResearchArea("03.", "", "Parent", true);
                oldParentResearchArea.setHasChildrenFlag(true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"03.");
                this.will(7.returnValue((Object)oldParentResearchArea));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)oldParentResearchArea);
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        researchAreasService.saveResearchAreas(raChangeXML);
    }

    @Test
    public void testCheckResearchAreaAndDescendantsNotReferenced() throws Exception {
        final ResearchArea researchArea_0 = new ResearchArea("0", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_0 = new ResearchArea("0.0", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0_0 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_1 = new ResearchArea("0.1", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0_1 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_2 = new ResearchArea("0.2", "", "", true);
        final ArrayList childrenOf_0_2 = new ArrayList();
        final ResearchArea researchArea_0_0_0 = new ResearchArea("0.0.0", "", "", true);
        final ArrayList childrenOf_0_0_0 = new ArrayList();
        final ResearchArea researchArea_0_1_0 = new ResearchArea("0.1.0", "", "", true);
        final ArrayList childrenOf_0_1_0 = new ArrayList();
        final ResearchArea researchArea_0_1_1 = new ResearchArea("0.1.1", "", "", true);
        final ArrayList childrenOf_0_1_1 = new ArrayList();
        childrenOf_0.add(researchArea_0_0);
        childrenOf_0.add(researchArea_0_1);
        childrenOf_0.add(researchArea_0_2);
        childrenOf_0_0.add(researchArea_0_0_0);
        childrenOf_0_1.add(researchArea_0_1_0);
        childrenOf_0_1.add(researchArea_0_1_1);
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues_0 = new HashMap<String, String>();
                fieldValues_0.put("parentResearchAreaCode", researchArea_0.getResearchAreaCode());
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0);
                this.will(8.returnValue((Object)childrenOf_0));
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)researchArea_0.getResearchAreaCode());
                this.will(8.returnValue((Object)researchArea_0));
                HashMap<String, String> fieldValues_0_0 = new HashMap<String, String>();
                fieldValues_0_0.put("parentResearchAreaCode", researchArea_0_0.getResearchAreaCode());
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_0);
                this.will(8.returnValue((Object)childrenOf_0_0));
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)researchArea_0_0.getResearchAreaCode());
                this.will(8.returnValue((Object)researchArea_0_0));
                HashMap<String, String> fieldValues_0_0_0 = new HashMap<String, String>();
                fieldValues_0_0_0.put("parentResearchAreaCode", researchArea_0_0_0.getResearchAreaCode());
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_0_0);
                this.will(8.returnValue((Object)childrenOf_0_0_0));
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)researchArea_0_0_0.getResearchAreaCode());
                this.will(8.returnValue((Object)researchArea_0_0_0));
                HashMap<String, String> fieldValues_0_1 = new HashMap<String, String>();
                fieldValues_0_1.put("parentResearchAreaCode", researchArea_0_1.getResearchAreaCode());
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1);
                this.will(8.returnValue((Object)childrenOf_0_1));
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)researchArea_0_1.getResearchAreaCode());
                this.will(8.returnValue((Object)researchArea_0_1));
                HashMap<String, String> fieldValues_0_1_0 = new HashMap<String, String>();
                fieldValues_0_1_0.put("parentResearchAreaCode", researchArea_0_1_0.getResearchAreaCode());
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1_0);
                this.will(8.returnValue((Object)childrenOf_0_1_0));
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)researchArea_0_1_0.getResearchAreaCode());
                this.will(8.returnValue((Object)researchArea_0_1_0));
                HashMap<String, String> fieldValues_0_1_1 = new HashMap<String, String>();
                fieldValues_0_1_1.put("parentResearchAreaCode", researchArea_0_1_1.getResearchAreaCode());
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1_1);
                this.will(8.returnValue((Object)childrenOf_0_1_1));
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)researchArea_0_1_1.getResearchAreaCode());
                this.will(8.returnValue((Object)researchArea_0_1_1));
                HashMap<String, String> fieldValues_0_2 = new HashMap<String, String>();
                fieldValues_0_2.put("parentResearchAreaCode", researchArea_0_2.getResearchAreaCode());
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_2);
                this.will(8.returnValue((Object)childrenOf_0_2));
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)researchArea_0_2.getResearchAreaCode());
                this.will(8.returnValue((Object)researchArea_0_2));
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        final ResearchAreaReferencesDao no_references_Dao = (ResearchAreaReferencesDao)this.context.mock(ResearchAreaReferencesDao.class, "name1");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResearchAreaReferencesDao)this.allowing(no_references_Dao)).isResearchAreaReferencedByAnyCommittee((String)this.with(9.any(String.class)));
                ((ResearchAreaReferencesDao)this.allowing(no_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember((String)this.with(9.any(String.class)));
                ((ResearchAreaReferencesDao)this.allowing(no_references_Dao)).isResearchAreaReferencedByAnyProtocol((String)this.with(9.any(String.class)));
            }
        });
        researchAreasService.setResearchAreaReferencesDao(no_references_Dao);
        final ResearchAreaReferencesDao only_0_1_1_references_Dao = (ResearchAreaReferencesDao)this.context.mock(ResearchAreaReferencesDao.class, "name2");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResearchAreaReferencesDao)this.allowing(only_0_1_1_references_Dao)).isResearchAreaReferencedByAnyCommittee((String)this.with(10.any(String.class)));
                this.will(10.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.allowing(only_0_1_1_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember((String)this.with(10.any(String.class)));
                this.will(10.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.allowing(only_0_1_1_references_Dao)).isResearchAreaReferencedByAnyProtocol((String)this.with(Matchers.not((Object)"0.1.1")));
                this.will(10.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.allowing(only_0_1_1_references_Dao)).isResearchAreaReferencedByAnyProtocol("0.1.1");
                this.will(10.returnValue((Object)true));
            }
        });
        researchAreasService.setResearchAreaReferencesDao(only_0_1_1_references_Dao);
        Assert.assertFalse((boolean)researchAreasService.checkResearchAreaAndDescendantsNotReferenced(researchArea_0.getResearchAreaCode()));
        Assert.assertFalse((boolean)researchAreasService.checkResearchAreaAndDescendantsNotReferenced(researchArea_0_1.getResearchAreaCode()));
        Assert.assertFalse((boolean)researchAreasService.checkResearchAreaAndDescendantsNotReferenced(researchArea_0_1_1.getResearchAreaCode()));
        Assert.assertTrue((boolean)researchAreasService.checkResearchAreaAndDescendantsNotReferenced(researchArea_0_0.getResearchAreaCode()));
        Assert.assertTrue((boolean)researchAreasService.checkResearchAreaAndDescendantsNotReferenced(researchArea_0_2.getResearchAreaCode()));
        Assert.assertTrue((boolean)researchAreasService.checkResearchAreaAndDescendantsNotReferenced(researchArea_0_0_0.getResearchAreaCode()));
        Assert.assertTrue((boolean)researchAreasService.checkResearchAreaAndDescendantsNotReferenced(researchArea_0_1_0.getResearchAreaCode()));
        final ResearchAreaReferencesDao only_0_0_0_references_Dao = (ResearchAreaReferencesDao)this.context.mock(ResearchAreaReferencesDao.class, "name3");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ResearchAreaReferencesDao)this.oneOf(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommittee("0");
                this.will(11.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.oneOf(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember("0");
                this.will(11.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.oneOf(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyProtocol("0");
                this.will(11.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.oneOf(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommittee("0.0");
                this.will(11.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.oneOf(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember("0.0");
                this.will(11.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.oneOf(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyProtocol("0.0");
                this.will(11.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.oneOf(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommittee("0.0.0");
                this.will(11.returnValue((Object)false));
                ((ResearchAreaReferencesDao)this.oneOf(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember("0.0.0");
                this.will(11.returnValue((Object)true));
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommittee("0.1");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember("0.1");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyProtocol("0.1");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommittee("0.1.0");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember("0.1.0");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyProtocol("0.1.0");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommittee("0.1.1");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember("0.1.1");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyProtocol("0.1.1");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommittee("0.2");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyCommitteeMember("0.2");
                ((ResearchAreaReferencesDao)this.never(only_0_0_0_references_Dao)).isResearchAreaReferencedByAnyProtocol("0.2");
            }
        });
        researchAreasService.setResearchAreaReferencesDao(only_0_0_0_references_Dao);
        Assert.assertFalse((boolean)researchAreasService.checkResearchAreaAndDescendantsNotReferenced(researchArea_0.getResearchAreaCode()));
    }

    @Test
    public void testGetCurrentProtocolReferencingResearchArea() throws Exception {
        Protocol p1 = new Protocol(){
            private static final long serialVersionUID = -1273061983131550371L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        p1.setProtocolNumber("--p1--");
        p1.setActive(false);
        ProtocolResearchArea pra1 = new ProtocolResearchArea();
        pra1.setProtocol((ProtocolBase)p1);
        Protocol p2 = new Protocol(){
            private static final long serialVersionUID = -1273061983131550372L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        p2.setProtocolNumber("--p2--");
        p2.setActive(false);
        ProtocolResearchArea pra2 = new ProtocolResearchArea();
        pra2.setProtocol((ProtocolBase)p2);
        Protocol p3 = new Protocol(){
            private static final long serialVersionUID = -1273061983131550373L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        p3.setProtocolNumber("--p3--");
        p3.setActive(true);
        ProtocolResearchArea pra3 = new ProtocolResearchArea();
        pra3.setProtocol((ProtocolBase)p3);
        Protocol p4 = new Protocol(){
            private static final long serialVersionUID = -1273061983131550374L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        p4.setProtocolNumber("--p4--");
        p4.setActive(true);
        ProtocolResearchArea pra4 = new ProtocolResearchArea();
        pra4.setProtocol((ProtocolBase)p4);
        final List<ProtocolResearchArea> protocolResearchAreaList = Arrays.asList(pra1, pra2, pra3, pra4);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("researchAreaCode", "TEST");
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolResearchArea.class, fieldValues);
                this.will(16.returnValue((Object)protocolResearchAreaList));
            }
        });
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        researchAreasService.setBusinessObjectService(businessObjectService);
        Assert.assertTrue((researchAreasService.getCurrentProtocolReferencingResearchArea("TEST") == p3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetCurrentCommitteeReferencingResearchArea() {
        CommitteeResearchArea cra1 = new CommitteeResearchArea();
        cra1.setCommitteeIdFk(Long.valueOf(1L));
        CommitteeResearchArea cra2 = new CommitteeResearchArea();
        cra2.setCommitteeIdFk(Long.valueOf(2L));
        CommitteeResearchArea cra3 = new CommitteeResearchArea();
        cra3.setCommitteeIdFk(Long.valueOf(3L));
        CommitteeResearchArea cra4 = new CommitteeResearchArea();
        cra4.setCommitteeIdFk(Long.valueOf(4L));
        final Committee c1 = new Committee();
        c1.setSequenceNumber(Integer.valueOf(1));
        c1.setCommitteeId("c1");
        final Committee c2 = new Committee();
        c2.setSequenceNumber(Integer.valueOf(2));
        c2.setCommitteeId("c2");
        final Committee c3 = new Committee();
        c3.setSequenceNumber(Integer.valueOf(3));
        c3.setCommitteeId("c3");
        Committee c4 = new Committee();
        c4.setSequenceNumber(Integer.valueOf(4));
        c4.setCommitteeId("c4");
        final List<CommitteeResearchArea> committeeResearchAreaList = Arrays.asList(cra1, cra2, cra3, cra4);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("researchAreaCode", "TEST");
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(CommitteeResearchArea.class, fieldValues);
                this.will(17.returnValue((Object)committeeResearchAreaList));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findBySinglePrimaryKey(Committee.class, (Object)1L);
                this.will(18.returnValue((Object)c1));
                ((BusinessObjectService)this.one(businessObjectService)).findBySinglePrimaryKey(Committee.class, (Object)2L);
                this.will(18.returnValue((Object)c2));
                ((BusinessObjectService)this.one(businessObjectService)).findBySinglePrimaryKey(Committee.class, (Object)3L);
                this.will(18.returnValue((Object)c3));
                ((BusinessObjectService)this.never(businessObjectService)).findBySinglePrimaryKey(Committee.class, (Object)4L);
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues1 = new HashMap<String, String>();
                fieldValues1.put("committeeId", "c1");
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, fieldValues1, "sequenceNumber", false);
                this.will(19.returnValue(Arrays.asList(c2, c1)));
                HashMap<String, String> fieldValues2 = new HashMap<String, String>();
                fieldValues2.put("committeeId", "c2");
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, fieldValues2, "sequenceNumber", false);
                this.will(19.returnValue(Arrays.asList(new Object[0])));
                HashMap<String, String> fieldValues3 = new HashMap<String, String>();
                fieldValues3.put("committeeId", "c3");
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, fieldValues3, "sequenceNumber", false);
                this.will(19.returnValue(Arrays.asList(c3, c2, c1)));
                HashMap<String, String> fieldValues4 = new HashMap<String, String>();
                fieldValues4.put("committeeId", "c4");
                ((BusinessObjectService)this.never(businessObjectService)).findMatchingOrderBy(Committee.class, fieldValues4, "sequenceNumber", false);
            }
        });
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        researchAreasService.setBusinessObjectService(businessObjectService);
        Assert.assertTrue((researchAreasService.getCurrentCommitteeReferencingResearchArea("TEST") == c3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetCurrentCommitteeMembershipReferencingResearchArea() {
        CommitteeMembershipExpertise cme1 = new CommitteeMembershipExpertise();
        cme1.setCommitteeMembershipIdFk(Long.valueOf(1L));
        CommitteeMembershipExpertise cme2 = new CommitteeMembershipExpertise();
        cme2.setCommitteeMembershipIdFk(Long.valueOf(2L));
        CommitteeMembershipExpertise cme3 = new CommitteeMembershipExpertise();
        cme3.setCommitteeMembershipIdFk(Long.valueOf(3L));
        CommitteeMembershipExpertise cme4 = new CommitteeMembershipExpertise();
        cme4.setCommitteeMembershipIdFk(Long.valueOf(4L));
        final List<CommitteeMembershipExpertise> committeeMembershipExpertiseList = Arrays.asList(cme1, cme2, cme3, cme4);
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, 1);
        Date dateTomorrow = new Date(cal.getTime().getTime());
        cal.add(5, -2);
        Date dateYesterday = new Date(cal.getTime().getTime());
        final CommitteeMembership cm1 = new CommitteeMembership();
        cm1.setTermEndDate(dateTomorrow);
        cm1.setCommitteeIdFk(Long.valueOf(11L));
        final CommitteeMembership cm2 = new CommitteeMembership();
        cm2.setTermEndDate(dateYesterday);
        cm2.setCommitteeIdFk(Long.valueOf(22L));
        final CommitteeMembership cm3 = new CommitteeMembership();
        cm3.setTermEndDate(dateTomorrow);
        cm3.setCommitteeIdFk(Long.valueOf(33L));
        CommitteeMembership cm4 = new CommitteeMembership();
        cm4.setTermEndDate(dateTomorrow);
        cm4.setCommitteeIdFk(Long.valueOf(44L));
        final Committee c1 = new Committee();
        c1.setSequenceNumber(Integer.valueOf(1));
        c1.setCommitteeId("c1");
        final Committee c2 = new Committee();
        c2.setSequenceNumber(Integer.valueOf(2));
        c2.setCommitteeId("c2");
        final Committee c3 = new Committee();
        c3.setSequenceNumber(Integer.valueOf(3));
        c3.setCommitteeId("c3");
        Committee c4 = new Committee();
        c4.setSequenceNumber(Integer.valueOf(4));
        c4.setCommitteeId("c4");
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("researchAreaCode", "TEST");
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(CommitteeMembershipExpertise.class, fieldValues);
                this.will(20.returnValue((Object)committeeMembershipExpertiseList));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findBySinglePrimaryKey(CommitteeMembership.class, (Object)1L);
                this.will(21.returnValue((Object)cm1));
                ((BusinessObjectService)this.one(businessObjectService)).findBySinglePrimaryKey(CommitteeMembership.class, (Object)2L);
                this.will(21.returnValue((Object)cm2));
                ((BusinessObjectService)this.one(businessObjectService)).findBySinglePrimaryKey(CommitteeMembership.class, (Object)3L);
                this.will(21.returnValue((Object)cm3));
                ((BusinessObjectService)this.never(businessObjectService)).findBySinglePrimaryKey(CommitteeMembership.class, (Object)4L);
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findBySinglePrimaryKey(Committee.class, (Object)11L);
                this.will(22.returnValue((Object)c1));
                ((BusinessObjectService)this.never(businessObjectService)).findBySinglePrimaryKey(Committee.class, (Object)22L);
                ((BusinessObjectService)this.one(businessObjectService)).findBySinglePrimaryKey(Committee.class, (Object)33L);
                this.will(22.returnValue((Object)c3));
                ((BusinessObjectService)this.never(businessObjectService)).findBySinglePrimaryKey(Committee.class, (Object)44L);
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues1 = new HashMap<String, String>();
                fieldValues1.put("committeeId", "c1");
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, fieldValues1, "sequenceNumber", false);
                this.will(23.returnValue(Arrays.asList(c2, c1)));
                HashMap<String, String> fieldValues2 = new HashMap<String, String>();
                fieldValues2.put("committeeId", "c2");
                ((BusinessObjectService)this.never(businessObjectService)).findMatchingOrderBy(Committee.class, fieldValues2, "sequenceNumber", false);
                HashMap<String, String> fieldValues3 = new HashMap<String, String>();
                fieldValues3.put("committeeId", "c3");
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatchingOrderBy(Committee.class, fieldValues3, "sequenceNumber", false);
                this.will(23.returnValue(Arrays.asList(c3, c2, c1)));
                HashMap<String, String> fieldValues4 = new HashMap<String, String>();
                fieldValues4.put("committeeId", "c4");
                ((BusinessObjectService)this.never(businessObjectService)).findMatchingOrderBy(Committee.class, fieldValues4, "sequenceNumber", false);
            }
        });
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        researchAreasService.setBusinessObjectService(businessObjectService);
        Assert.assertTrue((researchAreasService.getCurrentCommitteeMembershipReferencingResearchArea("TEST") == cm3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAnyCurrentReferencerForResearchAreaOrDescendant() throws Exception {
        final ResearchArea researchArea_0 = new ResearchArea("0", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_0 = new ResearchArea("0.0", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0_0 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_1 = new ResearchArea("0.1", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0_1 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_2 = new ResearchArea("0.2", "", "", true);
        final ArrayList childrenOf_0_2 = new ArrayList();
        final ResearchArea researchArea_0_0_0 = new ResearchArea("0.0.0", "", "", true);
        final ArrayList childrenOf_0_0_0 = new ArrayList();
        final ResearchArea researchArea_0_1_0 = new ResearchArea("0.1.0", "", "", true);
        final ArrayList childrenOf_0_1_0 = new ArrayList();
        final ResearchArea researchArea_0_1_1 = new ResearchArea("0.1.1", "", "", true);
        final ArrayList childrenOf_0_1_1 = new ArrayList();
        childrenOf_0.add(researchArea_0_0);
        childrenOf_0.add(researchArea_0_1);
        childrenOf_0.add(researchArea_0_2);
        childrenOf_0_0.add(researchArea_0_0_0);
        childrenOf_0_1.add(researchArea_0_1_0);
        childrenOf_0_1.add(researchArea_0_1_1);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> fieldValues_0 = new HashMap<String, Object>();
                fieldValues_0.put("parentResearchAreaCode", researchArea_0.getResearchAreaCode());
                fieldValues_0.put("active", true);
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0);
                this.will(24.returnValue((Object)childrenOf_0));
                HashMap<String, Object> fieldValues_0_0 = new HashMap<String, Object>();
                fieldValues_0_0.put("parentResearchAreaCode", researchArea_0_0.getResearchAreaCode());
                fieldValues_0_0.put("active", true);
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_0);
                this.will(24.returnValue((Object)childrenOf_0_0));
                HashMap<String, Object> fieldValues_0_0_0 = new HashMap<String, Object>();
                fieldValues_0_0_0.put("parentResearchAreaCode", researchArea_0_0_0.getResearchAreaCode());
                fieldValues_0_0_0.put("active", true);
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_0_0);
                this.will(24.returnValue((Object)childrenOf_0_0_0));
                HashMap<String, Object> fieldValues_0_1 = new HashMap<String, Object>();
                fieldValues_0_1.put("parentResearchAreaCode", researchArea_0_1.getResearchAreaCode());
                fieldValues_0_1.put("active", true);
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1);
                this.will(24.returnValue((Object)childrenOf_0_1));
                HashMap<String, Object> fieldValues_0_1_0 = new HashMap<String, Object>();
                fieldValues_0_1_0.put("parentResearchAreaCode", researchArea_0_1_0.getResearchAreaCode());
                fieldValues_0_1_0.put("active", true);
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1_0);
                this.will(24.returnValue((Object)childrenOf_0_1_0));
                HashMap<String, Object> fieldValues_0_1_1 = new HashMap<String, Object>();
                fieldValues_0_1_1.put("parentResearchAreaCode", researchArea_0_1_1.getResearchAreaCode());
                fieldValues_0_1_1.put("active", true);
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1_1);
                this.will(24.returnValue((Object)childrenOf_0_1_1));
                HashMap<String, Object> fieldValues_0_2 = new HashMap<String, Object>();
                fieldValues_0_2.put("parentResearchAreaCode", researchArea_0_2.getResearchAreaCode());
                fieldValues_0_2.put("active", true);
                ((BusinessObjectService)this.allowing(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_2);
                this.will(24.returnValue((Object)childrenOf_0_2));
            }
        });
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl(){

            public Protocol getCurrentProtocolReferencingResearchArea(String researchAreaCode) {
                return null;
            }

            public Committee getCurrentCommitteeReferencingResearchArea(String researchAreaCode) {
                return null;
            }

            public CommitteeMembership getCurrentCommitteeMembershipReferencingResearchArea(String researchAreaCode) {
                return null;
            }
        };
        researchAreasService.setBusinessObjectService(businessObjectService);
        Assert.assertTrue((researchAreasService.getAnyCurrentReferencerForResearchAreaOrDescendant(researchArea_0.getResearchAreaCode()) == ResearchAreaCurrentReferencerHolderBase.NO_REFERENCER ? 1 : 0) != 0);
        final Protocol p1 = new Protocol(){
            private static final long serialVersionUID = -1273061983131550371L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        p1.setProtocolNumber("abcdef");
        researchAreasService = new ResearchAreasServiceImpl(){

            public Protocol getCurrentProtocolReferencingResearchArea(String researchAreaCode) {
                if (researchAreaCode.equals(researchArea_0_1_1.getResearchAreaCode())) {
                    return p1;
                }
                return null;
            }

            public Committee getCurrentCommitteeReferencingResearchArea(String researchAreaCode) {
                return null;
            }

            public CommitteeMembership getCurrentCommitteeMembershipReferencingResearchArea(String researchAreaCode) {
                return null;
            }
        };
        researchAreasService.setBusinessObjectService(businessObjectService);
        ResearchAreaCurrentReferencerHolderBase referencer = researchAreasService.getAnyCurrentReferencerForResearchAreaOrDescendant(researchArea_0.getResearchAreaCode());
        Assert.assertTrue((boolean)referencer.getResearchAreaCode().equals(researchArea_0_1_1.getResearchAreaCode()));
        Assert.assertTrue((referencer.getCurrentReferencingProtocol() == p1 ? 1 : 0) != 0);
        Assert.assertTrue((referencer.getCurrentReferencingCommittee() == null ? 1 : 0) != 0);
        Assert.assertTrue((referencer.getCurrentReferencingCommitteeMembership() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)referencer.getMessage().equals("Research area " + researchArea_0_1_1.getResearchAreaCode() + " is referenced by current version of protocol with number " + p1.getProtocolNumber()));
        Assert.assertTrue((researchAreasService.getAnyCurrentReferencerForResearchAreaOrDescendant(researchArea_0_0.getResearchAreaCode()) == ResearchAreaCurrentReferencerHolderBase.NO_REFERENCER ? 1 : 0) != 0);
        Assert.assertTrue((researchAreasService.getAnyCurrentReferencerForResearchAreaOrDescendant(researchArea_0_2.getResearchAreaCode()) == ResearchAreaCurrentReferencerHolderBase.NO_REFERENCER ? 1 : 0) != 0);
        final Committee c1 = new Committee();
        c1.setCommitteeId("444");
        researchAreasService = new ResearchAreasServiceImpl(){

            public Protocol getCurrentProtocolReferencingResearchArea(String researchAreaCode) {
                if (researchAreaCode.equals(researchArea_0_1_1.getResearchAreaCode())) {
                    return p1;
                }
                return null;
            }

            public Committee getCurrentCommitteeReferencingResearchArea(String researchAreaCode) {
                if (researchAreaCode.equals(researchArea_0_0_0.getResearchAreaCode())) {
                    return c1;
                }
                return null;
            }

            public CommitteeMembership getCurrentCommitteeMembershipReferencingResearchArea(String researchAreaCode) {
                return null;
            }
        };
        final BusinessObjectService businessObjectServiceNew = (BusinessObjectService)this.context.mock(BusinessObjectService.class, "new");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Object> fieldValues_0 = new HashMap<String, Object>();
                fieldValues_0.put("parentResearchAreaCode", researchArea_0.getResearchAreaCode());
                fieldValues_0.put("active", true);
                ((BusinessObjectService)this.oneOf(businessObjectServiceNew)).findMatching(ResearchArea.class, fieldValues_0);
                this.will(29.returnValue((Object)childrenOf_0));
                HashMap<String, Object> fieldValues_0_0 = new HashMap<String, Object>();
                fieldValues_0_0.put("parentResearchAreaCode", researchArea_0_0.getResearchAreaCode());
                fieldValues_0_0.put("active", true);
                ((BusinessObjectService)this.oneOf(businessObjectServiceNew)).findMatching(ResearchArea.class, fieldValues_0_0);
                this.will(29.returnValue((Object)childrenOf_0_0));
                HashMap<String, Object> fieldValues_0_0_0 = new HashMap<String, Object>();
                fieldValues_0_0_0.put("parentResearchAreaCode", researchArea_0_0_0.getResearchAreaCode());
                fieldValues_0_0_0.put("active", true);
                ((BusinessObjectService)this.never(businessObjectServiceNew)).findMatching(ResearchArea.class, fieldValues_0_0_0);
                HashMap<String, Object> fieldValues_0_1 = new HashMap<String, Object>();
                fieldValues_0_1.put("parentResearchAreaCode", researchArea_0_1.getResearchAreaCode());
                fieldValues_0_1.put("active", true);
                ((BusinessObjectService)this.never(businessObjectServiceNew)).findMatching(ResearchArea.class, fieldValues_0_1);
                HashMap<String, Object> fieldValues_0_1_0 = new HashMap<String, Object>();
                fieldValues_0_1_0.put("parentResearchAreaCode", researchArea_0_1_0.getResearchAreaCode());
                fieldValues_0_1_0.put("active", true);
                ((BusinessObjectService)this.never(businessObjectServiceNew)).findMatching(ResearchArea.class, fieldValues_0_1_0);
                HashMap<String, Object> fieldValues_0_1_1 = new HashMap<String, Object>();
                fieldValues_0_1_1.put("parentResearchAreaCode", researchArea_0_1_1.getResearchAreaCode());
                fieldValues_0_1_1.put("active", true);
                ((BusinessObjectService)this.never(businessObjectServiceNew)).findMatching(ResearchArea.class, fieldValues_0_1_1);
                HashMap<String, Object> fieldValues_0_2 = new HashMap<String, Object>();
                fieldValues_0_2.put("parentResearchAreaCode", researchArea_0_2.getResearchAreaCode());
                fieldValues_0_2.put("active", true);
                ((BusinessObjectService)this.never(businessObjectServiceNew)).findMatching(ResearchArea.class, fieldValues_0_2);
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectServiceNew);
        referencer = researchAreasService.getAnyCurrentReferencerForResearchAreaOrDescendant(researchArea_0.getResearchAreaCode());
        Assert.assertTrue((boolean)referencer.getResearchAreaCode().equals(researchArea_0_0_0.getResearchAreaCode()));
        Assert.assertTrue((referencer.getCurrentReferencingProtocol() == null ? 1 : 0) != 0);
        Assert.assertTrue((referencer.getCurrentReferencingCommittee() == c1 ? 1 : 0) != 0);
        Assert.assertTrue((referencer.getCurrentReferencingCommitteeMembership() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)referencer.getMessage().equals("Research area " + researchArea_0_0_0.getResearchAreaCode() + " is referenced by current version of committee with ID " + c1.getCommitteeId()));
    }

    @Test
    public void testDeactivateResearchAreaAndDescendants() throws Exception {
        final ResearchArea researchArea_0 = new ResearchArea("0", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_0 = new ResearchArea("0.0", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0_0 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_1 = new ResearchArea("0.1", "", "", true);
        final ArrayList<ResearchArea> childrenOf_0_1 = new ArrayList<ResearchArea>();
        final ResearchArea researchArea_0_2 = new ResearchArea("0.2", "", "", true);
        final ArrayList childrenOf_0_2 = new ArrayList();
        final ResearchArea researchArea_0_0_0 = new ResearchArea("0.0.0", "", "", true);
        final ArrayList childrenOf_0_0_0 = new ArrayList();
        final ResearchArea researchArea_0_1_0 = new ResearchArea("0.1.0", "", "", true);
        final ArrayList childrenOf_0_1_0 = new ArrayList();
        final ResearchArea researchArea_0_1_1 = new ResearchArea("0.1.1", "", "", true);
        final ArrayList childrenOf_0_1_1 = new ArrayList();
        childrenOf_0.add(researchArea_0_0);
        childrenOf_0.add(researchArea_0_1);
        childrenOf_0.add(researchArea_0_2);
        childrenOf_0_0.add(researchArea_0_0_0);
        childrenOf_0_1.add(researchArea_0_1_0);
        childrenOf_0_1.add(researchArea_0_1_1);
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues_0 = new HashMap<String, String>();
                fieldValues_0.put("parentResearchAreaCode", researchArea_0.getResearchAreaCode());
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0);
                this.will(30.returnValue((Object)childrenOf_0));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)researchArea_0);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)researchArea_0.getResearchAreaCode());
                this.will(30.returnValue((Object)researchArea_0));
                HashMap<String, String> fieldValues_0_0 = new HashMap<String, String>();
                fieldValues_0_0.put("parentResearchAreaCode", researchArea_0_0.getResearchAreaCode());
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_0);
                this.will(30.returnValue((Object)childrenOf_0_0));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)researchArea_0_0);
                HashMap<String, String> fieldValues_0_0_0 = new HashMap<String, String>();
                fieldValues_0_0_0.put("parentResearchAreaCode", researchArea_0_0_0.getResearchAreaCode());
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_0_0);
                this.will(30.returnValue((Object)childrenOf_0_0_0));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)researchArea_0_0_0);
                HashMap<String, String> fieldValues_0_1 = new HashMap<String, String>();
                fieldValues_0_1.put("parentResearchAreaCode", researchArea_0_1.getResearchAreaCode());
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1);
                this.will(30.returnValue((Object)childrenOf_0_1));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)researchArea_0_1);
                HashMap<String, String> fieldValues_0_1_0 = new HashMap<String, String>();
                fieldValues_0_1_0.put("parentResearchAreaCode", researchArea_0_1_0.getResearchAreaCode());
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1_0);
                this.will(30.returnValue((Object)childrenOf_0_1_0));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)researchArea_0_1_0);
                HashMap<String, String> fieldValues_0_1_1 = new HashMap<String, String>();
                fieldValues_0_1_1.put("parentResearchAreaCode", researchArea_0_1_1.getResearchAreaCode());
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_1_1);
                this.will(30.returnValue((Object)childrenOf_0_1_1));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)researchArea_0_1_1);
                HashMap<String, String> fieldValues_0_2 = new HashMap<String, String>();
                fieldValues_0_2.put("parentResearchAreaCode", researchArea_0_2.getResearchAreaCode());
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatching(ResearchArea.class, fieldValues_0_2);
                this.will(30.returnValue((Object)childrenOf_0_2));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)researchArea_0_2);
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        Assert.assertTrue((boolean)researchArea_0.isActive());
        Assert.assertTrue((boolean)researchArea_0_0.isActive());
        Assert.assertTrue((boolean)researchArea_0_0_0.isActive());
        Assert.assertTrue((boolean)researchArea_0_1.isActive());
        Assert.assertTrue((boolean)researchArea_0_1_0.isActive());
        Assert.assertTrue((boolean)researchArea_0_1_1.isActive());
        Assert.assertTrue((boolean)researchArea_0_2.isActive());
        researchAreasService.deactivateResearchAreaAndDescendants(researchArea_0.getResearchAreaCode());
        Assert.assertFalse((boolean)researchArea_0.isActive());
        Assert.assertFalse((boolean)researchArea_0_0.isActive());
        Assert.assertFalse((boolean)researchArea_0_0_0.isActive());
        Assert.assertFalse((boolean)researchArea_0_1.isActive());
        Assert.assertFalse((boolean)researchArea_0_1_0.isActive());
        Assert.assertFalse((boolean)researchArea_0_1_1.isActive());
        Assert.assertFalse((boolean)researchArea_0_2.isActive());
    }

    @Test
    public void testDeleteResearchAreaAndDescendants() throws Exception {
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final ResearchArea deleteResearchArea = new ResearchArea("07.88", "07.", "Sample research area", true);
        final ResearchArea parentResearchArea = new ResearchArea("07.", "", "Parent", true);
        parentResearchArea.setHasChildrenFlag(true);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"07.88");
                this.will(31.returnValue((Object)deleteResearchArea));
                ((BusinessObjectService)this.oneOf(businessObjectService)).delete((PersistableBusinessObject)deleteResearchArea);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("parentResearchAreaCode", "07.88");
                ((BusinessObjectService)this.oneOf(businessObjectService)).findMatching(ResearchArea.class, fieldValues);
                this.will(31.returnValue(new ArrayList()));
                HashMap<String, String> fieldValues2 = new HashMap<String, String>();
                fieldValues2.put("parentResearchAreaCode", "07.");
                ((BusinessObjectService)this.oneOf(businessObjectService)).countMatching(ResearchArea.class, fieldValues2);
                this.will(31.returnValue((Object)0));
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"07.");
                this.will(31.returnValue((Object)parentResearchArea));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)parentResearchArea);
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        researchAreasService.deleteResearchAreaAndDescendants("07.88");
        Assert.assertFalse((boolean)parentResearchArea.getHasChildrenFlag());
    }

    @Test
    public void testMultipleRaChanges() throws Exception {
        String raChangeXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><RaChanges><RaChangesElement><RaCreate><Code>04.123</Code><ParentCode>04.</ParentCode><Description>Sample research area</Description><Active>true</Active></RaCreate></RaChangesElement><RaChangesElement><RaUpdateDescription><Code>05.12</Code><Description>new description</Description></RaUpdateDescription><RaUpdateActiveIndicator><Code>05.12</Code><Active>true</Active></RaUpdateActiveIndicator></RaChangesElement><RaChangesElement><RaUpdateParent><Code>03.24</Code><OldParent>03.</OldParent><NewParent>07.</NewParent></RaUpdateParent></RaChangesElement></RaChanges>";
        ResearchAreasServiceImpl researchAreasService = new ResearchAreasServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ResearchArea createResearchArea = new ResearchArea("04.123", "04.", "Sample research area", true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)createResearchArea);
                ResearchArea parentResearchArea2 = new ResearchArea("04.", "", "Parent", true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"04.");
                this.will(32.returnValue((Object)parentResearchArea2));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)parentResearchArea2);
                ResearchArea updateResearchArea = new ResearchArea("05.12", "05.", "Sample research area", false);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"05.12");
                this.will(32.returnValue((Object)updateResearchArea));
                updateResearchArea.setDescription("new description");
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)updateResearchArea);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"05.12");
                this.will(32.returnValue((Object)updateResearchArea));
                updateResearchArea.setActive(true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)updateResearchArea);
                ResearchArea updateParentResearchArea = new ResearchArea("03.24", "03.", "Sample research area", true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"03.24");
                this.will(32.returnValue((Object)updateParentResearchArea));
                updateParentResearchArea.setParentResearchAreaCode("07.");
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)updateParentResearchArea);
                ResearchArea newParentResearchArea = new ResearchArea("07.", "", "Parent", true);
                newParentResearchArea.setHasChildrenFlag(false);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"07.");
                this.will(32.returnValue((Object)newParentResearchArea));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)newParentResearchArea);
                HashMap<String, String> fieldValues2 = new HashMap<String, String>();
                fieldValues2.put("parentResearchAreaCode", "03.");
                ((BusinessObjectService)this.oneOf(businessObjectService)).countMatching(ResearchArea.class, fieldValues2);
                this.will(32.returnValue((Object)0));
                ResearchArea oldParentResearchArea = new ResearchArea("03.", "", "Parent", true);
                oldParentResearchArea.setHasChildrenFlag(true);
                ((BusinessObjectService)this.oneOf(businessObjectService)).findBySinglePrimaryKey(ResearchArea.class, (Object)"03.");
                this.will(32.returnValue((Object)oldParentResearchArea));
                ((BusinessObjectService)this.oneOf(businessObjectService)).save((PersistableBusinessObject)oldParentResearchArea);
            }
        });
        researchAreasService.setBusinessObjectService(businessObjectService);
        researchAreasService.saveResearchAreas(raChangeXML);
    }
}

