/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.impl.SponsorServiceImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class SponsorServiceImplTest
extends KcUnitTestBase {
    private static final String TEST_SPONSOR_CODE = "005891";
    private static final String TEST_SPONSOR_NAME = "Baystate Medical Center";
    private static final String INVALID_SPONSOR_CODE = "XXXX";
    private static final String TOP_SPONSOR_HIERARCHY = "Administering Activity;1;COI Disclosures;1;NIH Multiple PI;1;NIH Other Significant Contributor;1;Printing;1;Routing;1;Sponsor Groups";
    private SponsorService sponsorService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.sponsorService = this.getRegularSponsorService();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.sponsorService = null;
    }

    @Test
    public void testGetSponsorName() throws Exception {
        this.sponsorService = this.getRegularSponsorService();
        SponsorServiceImplTest.assertEquals((Object)TEST_SPONSOR_NAME, (Object)this.sponsorService.getSponsorName(TEST_SPONSOR_CODE));
    }

    @Test
    public void testGetSponsorNameInvalidCode() throws Exception {
        this.sponsorService = this.getRegularSponsorService();
        SponsorServiceImplTest.assertNull((Object)this.sponsorService.getSponsorName(INVALID_SPONSOR_CODE));
    }

    @Test
    public void testNotEmptyGetTopSponsorHierarch() {
        this.sponsorService = this.getRegularSponsorService();
        SponsorServiceImplTest.assertEquals((Object)TOP_SPONSOR_HIERARCHY, (Object)this.sponsorService.getTopSponsorHierarchy());
    }

    @Test
    public void testEmptyGetTopSponsorHierarch() {
        this.sponsorService = this.getEmptySponsorService();
        SponsorServiceImplTest.assertEquals((Object)"", (Object)this.sponsorService.getTopSponsorHierarchy());
    }

    private SponsorService getEmptySponsorService() {
        return new SponsorServiceImpl(){

            public Collection getTopSponsorHierarchyList() {
                return new ArrayList();
            }
        };
    }

    private SponsorService getRegularSponsorService() {
        return (SponsorService)KraServiceLocator.getService(SponsorService.class);
    }
}

