/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.UnitService;
import org.kuali.kra.service.impl.UnitServiceImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class UnitServiceImplTest
extends KcUnitTestBase {
    private UnitService unitService;
    private UnitServiceImpl unitServiceImpl;
    private static final String UNIVERSITY_UNIT_NUMBER = "000001";
    private static final String CARDIOLOGY_UNIT_NUMBER = "IN-CARD";
    private static final String BLOOMINGTON_UNIT_NUMBER_PROPER_CASE = "BL-BL";
    private static final String BLOOMINGTON_UNIT_NUMBER_CASE_CHANGED = "bL-Bl";

    @Override
    @Before
    public void setUp() throws Exception {
        this.unitService = (UnitService)KraServiceLocator.getService(UnitService.class);
        this.unitServiceImpl = (UnitServiceImpl)KraServiceLocator.getService(UnitService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.unitService = null;
        this.unitServiceImpl = null;
    }

    @Test
    public void testGetUnitName() {
        String retrievedName = this.unitService.getUnitName(UNIVERSITY_UNIT_NUMBER);
        UnitServiceImplTest.assertEquals((Object)"University", (Object)retrievedName);
    }

    @Test
    public void testGetUnits() {
        Collection units = this.unitService.getUnits();
        UnitServiceImplTest.assertEquals((long)13L, (long)units.size());
    }

    @Test
    public void testGetUnitCaseInsensitive() {
        Unit unit1 = this.unitService.getUnitCaseInsensitive(BLOOMINGTON_UNIT_NUMBER_CASE_CHANGED);
        Unit unit2 = this.unitService.getUnitCaseInsensitive(BLOOMINGTON_UNIT_NUMBER_PROPER_CASE);
        UnitServiceImplTest.assertNotNull((Object)unit1);
        UnitServiceImplTest.assertNotNull((Object)unit2);
        UnitServiceImplTest.assertEquals((Object)unit1, (Object)unit2);
    }

    @Test
    public void testGetUnit() {
        Unit unit = this.unitService.getUnit(CARDIOLOGY_UNIT_NUMBER);
        UnitServiceImplTest.assertEquals((Object)"CARDIOLOGY", (Object)unit.getUnitName());
    }

    @Test
    public void testGetAllSubUnits() {
        List units = this.unitService.getAllSubUnits(CARDIOLOGY_UNIT_NUMBER);
        UnitServiceImplTest.assertEquals((long)1L, (long)units.size());
    }

    @Test
    public void testGetBusinessObjectService() {
        UnitServiceImplTest.assertNotNull((Object)this.unitServiceImpl.getBusinessObjectService());
    }

    @Test
    public void testGetTopUnit() {
        Unit unit = this.unitServiceImpl.getTopUnit();
        UnitServiceImplTest.assertEquals((Object)UNIVERSITY_UNIT_NUMBER, (Object)unit.getUnitNumber());
    }

    @Test
    public void testGetInitialUnitsForUnitHierarchy() {
        String tree = this.unitService.getInitialUnitsForUnitHierarchy();
        UnitServiceImplTest.assertTrue((boolean)tree.contains(UNIVERSITY_UNIT_NUMBER));
    }

    @Test
    public void testGetInitialUnitsForUnitHierarchyInt() {
        String tree = this.unitService.getInitialUnitsForUnitHierarchy(3);
        UnitServiceImplTest.assertTrue((boolean)tree.contains(UNIVERSITY_UNIT_NUMBER));
    }

    @Test
    public void testRetrieveUnitAdministratorsByUnitNumber() {
        List admins = this.unitService.retrieveUnitAdministratorsByUnitNumber(UNIVERSITY_UNIT_NUMBER);
        for (UnitAdministrator admin : admins) {
            if (!"10000000001".equals(admin.getPersonId())) continue;
            UnitServiceImplTest.assertTrue((boolean)true);
            return;
        }
        UnitServiceImplTest.assertTrue((boolean)false);
    }

    @Test
    public void testGetMaxUnitTreeDepth() {
        int retVal = this.unitService.getMaxUnitTreeDepth();
        UnitServiceImplTest.assertTrue((retVal > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetUnitHierarchyForUnit() {
        List units = this.unitService.getUnitHierarchyForUnit("IN-PERS");
        UnitServiceImplTest.assertEquals((long)6L, (long)units.size());
    }

    @Test
    public void testGetUnitHierarchyForUnit2() {
        List units = this.unitService.getUnitHierarchyForUnit(UNIVERSITY_UNIT_NUMBER);
        UnitServiceImplTest.assertEquals((long)1L, (long)units.size());
    }

    @Test
    public void testGetUnitHierarchyForUnit3() {
        List units = this.unitService.getUnitHierarchyForUnit("xyz");
        UnitServiceImplTest.assertEquals((long)0L, (long)units.size());
    }
}

