/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class VersionHistoryServiceImplTest
extends KcUnitTestBase {
    private static final String PROTOCOL_VERSION_NAME = "2001";
    private static final String AWARD_VERSION_NAME = "1001-001";
    private VersionHistoryService versioningHistoryService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.versioningHistoryService = (VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testSavingAVersionHistory() {
        Award award = this.createAward(AWARD_VERSION_NAME, 1);
        VersionHistory vh = this.versioningHistoryService.updateVersionHistory((SequenceOwner)award, VersionStatus.ACTIVE, "jtester");
        Assert.assertNotNull((String)"VersionHistory was null", (Object)vh);
    }

    @Test
    public void testSavingVersionHistories() {
        this.versioningHistoryService.updateVersionHistory((SequenceOwner)this.createAward(AWARD_VERSION_NAME, 1), VersionStatus.ACTIVE, "u1");
        this.versioningHistoryService.updateVersionHistory((SequenceOwner)this.createProtocol(PROTOCOL_VERSION_NAME, 1), VersionStatus.ACTIVE, "u2");
        List list = this.versioningHistoryService.loadVersionHistory(Award.class, AWARD_VERSION_NAME);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)VersionStatus.ACTIVE, (Object)((VersionHistory)list.get(0)).getStatus());
        list = this.versioningHistoryService.loadVersionHistory(Protocol.class, PROTOCOL_VERSION_NAME);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)VersionStatus.ACTIVE, (Object)((VersionHistory)list.get(0)).getStatus());
        VersionHistory activeVersion = this.versioningHistoryService.findActiveVersion(Award.class, AWARD_VERSION_NAME);
        Assert.assertEquals((Object)"u1", (Object)activeVersion.getUserId());
        activeVersion = this.versioningHistoryService.findActiveVersion(Protocol.class, PROTOCOL_VERSION_NAME);
        Assert.assertEquals((Object)"u2", (Object)activeVersion.getUserId());
    }

    private Award createAward(String versionName, Integer versionNumber) {
        Award award = new Award();
        award.setAwardNumber(versionName);
        award.setSequenceNumber(versionNumber);
        return award;
    }

    private Protocol createProtocol(String versionName, Integer versionNumber) {
        Protocol protocol = new Protocol();
        protocol.setProtocolNumber(versionName);
        protocol.setSequenceNumber(versionNumber);
        return protocol;
    }
}

