/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.SeparatelySequenceableAssociate;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.service.impl.VersioningServiceImpl;
import org.kuali.kra.service.impl.versioningartifacts.OwnerAssociate;
import org.kuali.kra.service.impl.versioningartifacts.SelfReferenceAssociate;
import org.kuali.kra.service.impl.versioningartifacts.SelfReferenceOwner;
import org.kuali.kra.service.impl.versioningartifacts.SepSequenceComplexArtifacts;
import org.kuali.kra.service.impl.versioningartifacts.SequenceAssociateAttachmentBO;
import org.kuali.kra.service.impl.versioningartifacts.SequenceAssociateAttachmentBO2;
import org.kuali.kra.service.impl.versioningartifacts.SequenceAssociateChild;
import org.kuali.kra.service.impl.versioningartifacts.SequenceAssociateChild2;
import org.kuali.kra.service.impl.versioningartifacts.SequenceAssociateGrandChild;
import org.kuali.kra.service.impl.versioningartifacts.SequenceAssociateGrandChild2;
import org.kuali.kra.service.impl.versioningartifacts.SequenceOwnerImpl;
import org.kuali.kra.service.impl.versioningartifacts.SimpleAssociate;
import org.kuali.kra.service.impl.versioningartifacts.SimpleAssociate2;

public class VersioningServiceImplTest {
    private static final int NUMBER_OF_GRANDCHILD_ASSOCIATES = 5;
    private static final int NUMBER_OF_CHILD_ASSOCIATES = 3;
    private static final int NUMBER_OF_CHILD_ATTACHMENT_ASSOCIATES = 4;
    private VersioningService service;
    private SequenceOwnerImpl originalVersion;
    private OwnerAssociate originalOwnerAssociate;

    @Before
    public void setUp() {
        this.service = new VersioningServiceImpl();
        this.populateSequenceableArtifacts();
    }

    @After
    public void tearDown() {
        this.service = null;
        this.originalVersion = null;
    }

    @Test
    public void testSkipVersioning_1to1_Association_TopLevelOwner() throws Exception {
        SequenceOwnerImpl newVersion;
        SimpleAssociate newAssociate;
        SimpleAssociate originalAssociate = this.originalVersion.getSkipAssociate();
        Assert.assertTrue((originalAssociate != (newAssociate = (newVersion = (SequenceOwnerImpl)this.service.createNewVersion((SequenceOwner)this.originalVersion)).getSkipAssociate()) ? 1 : 0) != 0);
        Assert.assertNotNull((Object)newVersion.getSkipAssociate().getSimpleAssociateId());
        Assert.assertEquals((Object)this.originalVersion.getSkipAssociate().getSimpleAssociateId(), (Object)newVersion.getSkipAssociate().getSimpleAssociateId());
    }

    @Test
    public void testVersioning_1to1_Association_OwnerAssociate_CheckDownTheGraph() throws Exception {
        OwnerAssociate originalOwnerAssociate = this.originalVersion.getOwnerAssociate();
        OwnerAssociate newVersion = (OwnerAssociate)this.service.createNewVersion((SequenceOwner)originalOwnerAssociate);
        Assert.assertEquals((Object)originalOwnerAssociate.getOwnerSequenceNumber(), (Object)newVersion.getOwnerSequenceNumber());
        Assert.assertEquals((long)(originalOwnerAssociate.getSequenceNumber() + 1), (long)newVersion.getSequenceNumber().intValue());
        Assert.assertEquals((Object)originalOwnerAssociate.getSequenceOwner(), (Object)newVersion.getSequenceOwner());
        Assert.assertEquals((Object)this.originalVersion.getSequenceNumber(), (Object)newVersion.getSequenceOwner().getSequenceNumber());
        Assert.assertEquals((Object)this.originalVersion.getAssociate().getSequenceNumber(), (Object)this.originalVersion.getSequenceNumber());
        SimpleAssociate2 associate = newVersion.getAssociate();
        Assert.assertEquals((Object)newVersion, (Object)associate.getSequenceOwner());
        Assert.assertEquals((Object)newVersion.getSequenceNumber(), (Object)associate.getSequenceNumber());
        Assert.assertNull((Object)newVersion.getAssociate().getSimpleAssociateId());
    }

    @Test
    public void testVersioning_1to1_Association_OwnerAssociate_CheckUpTheGraph() throws Exception {
        OwnerAssociate newVersion = (OwnerAssociate)this.service.createNewVersion((SequenceOwner)this.originalVersion.getOwnerAssociate());
        Assert.assertEquals((Object)this.originalVersion, (Object)newVersion.getOwner());
        Assert.assertEquals((Object)this.originalVersion.getSequenceNumber(), (Object)newVersion.getOwnerSequenceNumber());
        SimpleAssociate associate = newVersion.getOwner().getAssociate();
        Assert.assertEquals((Object)this.originalVersion, (Object)associate.getSequenceOwner());
        Assert.assertEquals((Object)this.originalVersion.getSequenceNumber(), (Object)associate.getSequenceNumber());
        Assert.assertEquals((Object)this.originalVersion.getSequenceNumber(), (Object)associate.getSequenceNumber());
        Assert.assertNotNull((Object)this.originalVersion.getAssociate().getSimpleAssociateId());
    }

    @Test
    public void testVersioning_1to1_Association_TopLevelOwner() throws Exception {
        SequenceOwnerImpl newVersion = (SequenceOwnerImpl)this.service.createNewVersion((SequenceOwner)this.originalVersion);
        SimpleAssociate associate = newVersion.getAssociate();
        Assert.assertEquals((Object)newVersion, (Object)associate.getSequenceOwner());
        Assert.assertEquals((Object)newVersion.getSequenceNumber(), (Object)associate.getSequenceNumber());
        Assert.assertNull((Object)newVersion.getAssociate().getSimpleAssociateId());
    }

    @Test
    public void testVersioning_1toM_Association_OwnerAssociate() throws Exception {
        OwnerAssociate newOwnerAssociateVersion = (OwnerAssociate)this.service.createNewVersion((SequenceOwner)this.originalVersion.getOwnerAssociate());
        this.originalVersion.setOwnerAssociate(newOwnerAssociateVersion);
        this.verifyTopLevelAssociationsNotSequenced(newOwnerAssociateVersion);
        this.verifyOwnerAssociateSequencing(newOwnerAssociateVersion);
    }

    @Test
    public void testVersioning_1toM_Association_TopLevelOwner() throws Exception {
        SequenceOwnerImpl newVersion = (SequenceOwnerImpl)this.service.createNewVersion((SequenceOwner)this.originalVersion);
        this.verifyTopLevelAssociationSequencing(newVersion);
        this.verifyEffectOnOwnerAssociationAssociationsWhenSequencingTopLevel(newVersion);
    }

    @Test
    public void testVersioning_IndependentlySequencedOwnerAssociate_versioningOfTopSequenceOwner() throws Exception {
        SequenceOwnerImpl newVersion = (SequenceOwnerImpl)this.service.createNewVersion((SequenceOwner)this.originalVersion);
        OwnerAssociate newVersionOwnerAssociate = newVersion.getOwnerAssociate();
        this.verifyOwnerAssociateWasSequencedWithOwner(newVersion, newVersionOwnerAssociate);
        this.verifyNewVersionOwnerAssociateSequenceNumberNotChanged(newVersionOwnerAssociate);
        this.verifyNewVersionOwnerAssociateAssociateSeqNoNotChanged(newVersionOwnerAssociate);
    }

    @Test
    public void testVersioning_MtoN_Association_MultipleAssociatesUpdated_TopLevelOwner() throws Exception {
        SequenceOwnerImpl newVersion = (SequenceOwnerImpl)this.service.createNewVersion((SequenceOwner)this.originalVersion);
        List newAssociates = this.service.versionAssociates(this.originalVersion.getAttachments());
        for (SequenceAssociateAttachmentBO newAssociate : newAssociates) {
            newVersion.add(newAssociate);
        }
        int numberOfAttachgmentsVersioned = this.originalVersion.getAttachments().size();
        this.checkAttachmentCollectionSizeAfterVersioning(newVersion, numberOfAttachgmentsVersioned);
        this.checkNewAttachmentsSequenced(newVersion.getAttachments(), numberOfAttachgmentsVersioned);
        this.checkOldAttachmentsNotSequenced(this.originalVersion.getAttachments(), numberOfAttachgmentsVersioned);
        this.checkIdentifierResetOnNewAttachments(newVersion, numberOfAttachgmentsVersioned);
        this.checkIdentifierNotResetOnOldAttachmentVersions(newVersion, numberOfAttachgmentsVersioned);
        this.verifyEffectOnOwnerAssociationAssociationsWhenSequencingTopLevel(newVersion);
    }

    @Test
    public void testVersioning_MtoN_Association_MultipleAssociatesUpdated_OwnerAssociate() throws Exception {
        OwnerAssociate newOwnerAssociate = (OwnerAssociate)this.service.createNewVersion((SequenceOwner)this.originalOwnerAssociate);
        List newAssociates = this.service.versionAssociates(this.originalOwnerAssociate.getAttachments());
        for (SeparatelySequenceableAssociate newAssociate : newAssociates) {
            newOwnerAssociate.add((SequenceAssociateAttachmentBO2)newAssociate);
        }
        int numberOfAttachgmentsVersioned = this.originalOwnerAssociate.getAttachments().size();
        this.checkAttachmentCollectionSizeAfterVersioning(newOwnerAssociate, numberOfAttachgmentsVersioned);
        this.checkNewAttachmentsSequenced(newOwnerAssociate.getAttachments(), numberOfAttachgmentsVersioned);
        this.checkOldAttachmentsNotSequenced(this.originalOwnerAssociate.getAttachments(), numberOfAttachgmentsVersioned);
        this.checkIdentifierResetOnNewAttachments(newOwnerAssociate, numberOfAttachgmentsVersioned);
        this.checkIdentifierNotResetOnOldAttachmentVersions(newOwnerAssociate, numberOfAttachgmentsVersioned);
        this.verifyTopLevelAssociationsNotSequenced(newOwnerAssociate);
    }

    @Test
    public void testVersioning_MtoN_Association_SingleAssociateUpdated() throws Exception {
        SequenceAssociateAttachmentBO attachment = this.originalVersion.getAttachments().get(0);
        SequenceOwnerImpl newVersion = (SequenceOwnerImpl)this.service.createNewVersion((SequenceOwner)this.originalVersion);
        SeparatelySequenceableAssociate newAttachmentVersion = this.service.versionAssociate((SeparatelySequenceableAssociate)attachment);
        newVersion.add((SequenceAssociateAttachmentBO)newAttachmentVersion);
        this.checkAttachmentCollectionSizeAfterVersioning(newVersion, 1);
        this.checkIdentifierResetOnNewAttachments(newVersion, 1);
        this.checkIdentifierNotResetOnOldAttachmentVersions(newVersion, 1);
    }

    @Test
    public void testVersioning_Owner() throws Exception {
        SequenceOwnerImpl newVersion = (SequenceOwnerImpl)this.service.createNewVersion((SequenceOwner)this.originalVersion);
        Assert.assertEquals((long)(this.originalVersion.getSequenceNumber() + 1), (long)newVersion.getSequenceNumber().intValue());
        Assert.assertNull((Object)newVersion.getSequenceOwnerId());
    }

    @Test
    public void testVersioning_already_versioned_collection() throws Exception {
        SelfReferenceOwner owner = new SelfReferenceOwner();
        SelfReferenceAssociate associate = new SelfReferenceAssociate();
        associate.selfs.add(associate);
        owner.associates.add(associate);
    }

    @Test
    public void testVersioning_separately_sequenceable_multiple_owners() throws Exception {
        SepSequenceComplexArtifacts.AttachmentOwner owner1 = this.createAnOwnerWithAttachments();
        SepSequenceComplexArtifacts.AttachmentOwner newOwner1 = (SepSequenceComplexArtifacts.AttachmentOwner)this.service.createNewVersion((SequenceOwner)owner1);
        for (SepSequenceComplexArtifacts.AttachmentMetaData attachment : newOwner1.getAttachments()) {
            attachment.setData((SepSequenceComplexArtifacts.AttachmentLargeData)this.service.versionAssociate((SeparatelySequenceableAssociate)attachment.getData()));
        }
        Assert.assertThat((Object)newOwner1.getAttachments().size(), (Matcher)IsEqual.equalTo((Object)owner1.getAttachments().size()));
        for (SepSequenceComplexArtifacts.AttachmentMetaData attachment : newOwner1.getAttachments()) {
            Assert.assertThat((Object)attachment.getData().getId(), (Matcher)IsNull.nullValue());
            Assert.assertThat((Object)attachment.getData().getSequenceNumber(), (Matcher)Is.is((Object)1));
        }
    }

    private SepSequenceComplexArtifacts.AttachmentOwner createAnOwnerWithAttachments() {
        SepSequenceComplexArtifacts.AttachmentOwner owner1 = new SepSequenceComplexArtifacts.AttachmentOwner();
        this.createAttachmentAndAddToOwner(owner1);
        this.createAttachmentAndAddToOwner(owner1);
        return owner1;
    }

    private void createAttachmentAndAddToOwner(SepSequenceComplexArtifacts.AttachmentOwner owner1) {
        SepSequenceComplexArtifacts.AttachmentLargeData data1 = new SepSequenceComplexArtifacts.AttachmentLargeData();
        SepSequenceComplexArtifacts.AttachmentMetaDataAssoc assoc1 = new SepSequenceComplexArtifacts.AttachmentMetaDataAssoc(owner1);
        SepSequenceComplexArtifacts.AttachmentMetaData attachment1 = new SepSequenceComplexArtifacts.AttachmentMetaData(owner1, assoc1, data1);
        owner1.addAttachments(attachment1);
    }

    private void checkNewAttachmentsSequenced(List<? extends SeparatelySequenceableAssociate> attachments, int numberOfAttachmentsVersioned) {
        int startIndex;
        int i = startIndex = attachments.size() - numberOfAttachmentsVersioned;
        while (startIndex < attachments.size()) {
            Assert.assertThat((Object)attachments.get(i).getSequenceNumber(), (Matcher)Is.is((Object)1));
            ++startIndex;
        }
    }

    private void checkOldAttachmentsNotSequenced(List<? extends SeparatelySequenceableAssociate> attachments, int numberOfAttachmentsVersioned) {
        int lastIndex = numberOfAttachmentsVersioned;
        for (int i = 0; i < lastIndex; ++i) {
            Assert.assertThat((Object)attachments.get(i).getSequenceNumber(), (Matcher)Is.is((Object)0));
        }
    }

    private void addAssociate(OwnerAssociate ownerAssociate) {
        SimpleAssociate2 associateToOwnerAssociate = new SimpleAssociate2("OwnerAssociate's Associate");
        ownerAssociate.setAssociate(associateToOwnerAssociate);
        associateToOwnerAssociate.setOwner(ownerAssociate);
    }

    private void addAssociate(SequenceOwnerImpl owner) {
        SimpleAssociate associate = new SimpleAssociate("Associate1");
        owner.setAssociate(associate);
        associate.setOwner(owner);
    }

    private void addSkipAssociate(SequenceOwnerImpl owner) {
        SimpleAssociate associate = new SimpleAssociate("SkipAssociate");
        owner.setSkipAssociate(associate);
        associate.setOwner(owner);
    }

    private void addCollectionOfManyToManyAssociates(OwnerAssociate owner) {
        for (int i = 1; i <= 4; ++i) {
            SequenceAssociateAttachmentBO2 attch = new SequenceAssociateAttachmentBO2(String.format("Attachment2 %d", i));
            owner.add(attch);
        }
    }

    private void addCollectionOfManyToManyAssociates(SequenceOwnerImpl owner) {
        for (int i = 1; i <= 4; ++i) {
            SequenceAssociateAttachmentBO attch = new SequenceAssociateAttachmentBO(String.format("Attachment %d", i));
            owner.add(attch);
        }
    }

    private void addCollectionOfOneToManyAssociates(OwnerAssociate owner) {
        for (int i = 1; i <= 3; ++i) {
            SequenceAssociateChild2 child = new SequenceAssociateChild2(String.format("Child2 %d", i));
            owner.add(child);
            for (int j = 1; j <= 5; ++j) {
                String name = String.format("GrandChild2 %d.%d", i, j);
                SequenceAssociateGrandChild2 grandChild = new SequenceAssociateGrandChild2(name);
                grandChild.setOwner(owner);
                child.add(grandChild);
            }
        }
    }

    private void addCollectionOfOneToManyAssociates(SequenceOwnerImpl owner) {
        for (int i = 1; i <= 3; ++i) {
            SequenceAssociateChild child = new SequenceAssociateChild(String.format("Child %d", i));
            owner.add(child);
            for (int j = 1; j <= 5; ++j) {
                String name = String.format("GrandChild %d.%d", i, j);
                SequenceAssociateGrandChild grandChild = new SequenceAssociateGrandChild(name);
                grandChild.setOwner(owner);
                child.add(grandChild);
            }
        }
    }

    private void addCollectionOfOneToManySkipAssociates(SequenceOwnerImpl owner) {
        for (int i = 1; i <= 3; ++i) {
            SequenceAssociateChild child = new SequenceAssociateChild(String.format("Child %d", i));
            owner.addSkipChild(child);
        }
    }

    private void checkAttachmentCollectionSizeAfterVersioning(SequenceOwnerImpl newVersion, int numberOfAttachmentsVersioned) {
        int actualSize = newVersion.getAttachments().size();
        int expectedNewSize = this.originalVersion.getAttachments().size() + numberOfAttachmentsVersioned;
        Assert.assertEquals((long)expectedNewSize, (long)actualSize);
    }

    private void checkAttachmentCollectionSizeAfterVersioning(OwnerAssociate newVersion, int numberOfAttachmentsVersioned) {
        int actualSize = newVersion.getAttachments().size();
        int expectedNewSize = this.originalOwnerAssociate.getAttachments().size() + numberOfAttachmentsVersioned;
        Assert.assertEquals((long)expectedNewSize, (long)actualSize);
    }

    private void checkIdentifierNotResetOnOldAttachmentVersions(SequenceOwnerImpl newVersion, int numberOfAttachmentsVersioned) {
        List<SequenceAssociateAttachmentBO> attachments = newVersion.getAttachments();
        int lastIndex = attachments.size() - numberOfAttachmentsVersioned;
        for (int i = 0; i < lastIndex; ++i) {
            Assert.assertNotNull((Object)attachments.get(i).getAttachmentId());
        }
    }

    private void checkIdentifierNotResetOnOldAttachmentVersions(OwnerAssociate newVersion, int numberOfAttachmentsVersioned) {
        List<SequenceAssociateAttachmentBO2> attachments = newVersion.getAttachments();
        int lastIndex = attachments.size() - numberOfAttachmentsVersioned;
        for (int i = 0; i < lastIndex; ++i) {
            Assert.assertNotNull((Object)attachments.get(i).getAttachmentId());
        }
    }

    private void checkIdentifierResetOnNewAttachments(SequenceOwnerImpl newVersion, int numberOfAttachmentsVersioned) {
        int lastIndex = newVersion.getAttachments().size() - numberOfAttachmentsVersioned;
        for (int i = 0; i < numberOfAttachmentsVersioned; ++i) {
            Assert.assertNull((Object)newVersion.getAttachments().get(lastIndex + i).getAttachmentId());
        }
    }

    private void checkIdentifierResetOnNewAttachments(OwnerAssociate newVersion, int numberOfAttachmentsVersioned) {
        int lastIndex = newVersion.getAttachments().size() - numberOfAttachmentsVersioned;
        for (int i = 0; i < numberOfAttachmentsVersioned; ++i) {
            Assert.assertNull((Object)newVersion.getAttachments().get(lastIndex + i).getAttachmentId());
        }
    }

    private OwnerAssociate populateOwnerAssociate() {
        OwnerAssociate ownerAssociate = new OwnerAssociate("OwnerAssociate");
        this.originalVersion.setOwnerAssociate(ownerAssociate);
        ownerAssociate.setOwner(this.originalVersion);
        this.addAssociate(ownerAssociate);
        this.addCollectionOfOneToManyAssociates(ownerAssociate);
        this.addCollectionOfManyToManyAssociates(ownerAssociate);
        return ownerAssociate;
    }

    private void populateSequenceableArtifacts() {
        this.originalVersion = this.populateTopLevelOwner();
        this.originalOwnerAssociate = this.populateOwnerAssociate();
    }

    private SequenceOwnerImpl populateTopLevelOwner() {
        SequenceOwnerImpl owner = new SequenceOwnerImpl();
        this.addAssociate(owner);
        this.addSkipAssociate(owner);
        this.addCollectionOfOneToManyAssociates(owner);
        this.addCollectionOfOneToManySkipAssociates(owner);
        this.addCollectionOfManyToManyAssociates(owner);
        return owner;
    }

    private void verifyEffectOnOwnerAssociationAssociationsWhenSequencingTopLevel(SequenceOwnerImpl topOwner) {
        OwnerAssociate originalOwnerAssociate = this.originalVersion.getOwnerAssociate();
        OwnerAssociate newOwnerAssociate = topOwner.getOwnerAssociate();
        Assert.assertEquals((Object)topOwner.getSequenceNumber(), (Object)newOwnerAssociate.getOwnerSequenceNumber());
        Assert.assertEquals((Object)originalOwnerAssociate.getSequenceNumber(), (Object)newOwnerAssociate.getSequenceNumber());
        for (SequenceAssociateChild2 child : newOwnerAssociate.getChildren()) {
            Assert.assertEquals((Object)newOwnerAssociate, (Object)child.getOwner());
            Assert.assertEquals((Object)newOwnerAssociate.getSequenceNumber(), (Object)child.getSequenceNumber());
            Assert.assertNotNull((Object)child.getChildId());
            for (SequenceAssociateGrandChild2 grandChild : child.getChildren()) {
                Assert.assertEquals((Object)newOwnerAssociate, (Object)grandChild.getOwner());
                Assert.assertEquals((Object)newOwnerAssociate.getSequenceNumber(), (Object)grandChild.getSequenceNumber());
                Assert.assertNotNull((Object)grandChild.getGrandChildId());
            }
        }
    }

    private void verifyNewVersionOwnerAssociateAssociateSeqNoNotChanged(OwnerAssociate newVersionOwnerAssociate) {
        OwnerAssociate oldVersionOwnerAssociate = this.originalVersion.getOwnerAssociate();
        SimpleAssociate2 newVersionOwnerAssociateAssociate = newVersionOwnerAssociate.getAssociate();
        SimpleAssociate2 oldVersionOwnerAssociateAssociate = oldVersionOwnerAssociate.getAssociate();
        Assert.assertEquals((Object)oldVersionOwnerAssociateAssociate.getSequenceNumber(), (Object)newVersionOwnerAssociateAssociate.getSequenceNumber());
    }

    private OwnerAssociate verifyNewVersionOwnerAssociateSequenceNumberNotChanged(OwnerAssociate newVersionOwnerAssociate) {
        OwnerAssociate oldVersionOwnerAssociate = this.originalVersion.getOwnerAssociate();
        Assert.assertEquals((Object)oldVersionOwnerAssociate, (Object)oldVersionOwnerAssociate.getAssociate().getOwner());
        Assert.assertEquals((Object)oldVersionOwnerAssociate.getSequenceNumber(), (Object)newVersionOwnerAssociate.getSequenceNumber());
        return oldVersionOwnerAssociate;
    }

    private void verifyOwnerAssociateSequencing(OwnerAssociate ownerAssociate) {
        Assert.assertEquals((Object)this.originalVersion.getSequenceNumber(), (Object)ownerAssociate.getOwnerSequenceNumber());
        for (SequenceAssociateChild2 child : ownerAssociate.getChildren()) {
            Assert.assertEquals((Object)ownerAssociate, (Object)child.getOwner());
            Assert.assertEquals((Object)ownerAssociate.getSequenceNumber(), (Object)child.getSequenceNumber());
            Assert.assertNull((Object)child.getChildId());
            for (SequenceAssociateGrandChild2 grandChild : child.getChildren()) {
                Assert.assertEquals((Object)ownerAssociate, (Object)grandChild.getOwner());
                Assert.assertEquals((Object)ownerAssociate.getSequenceNumber(), (Object)grandChild.getSequenceNumber());
                Assert.assertNull((Object)grandChild.getGrandChildId());
            }
        }
    }

    private void verifyOwnerAssociateWasSequencedWithOwner(SequenceOwnerImpl newVersion, OwnerAssociate newVersionOwnerAssociate) {
        Assert.assertEquals((Object)newVersion, (Object)newVersionOwnerAssociate.getOwner());
        Assert.assertEquals((Object)newVersion.getSequenceNumber(), (Object)newVersionOwnerAssociate.getOwnerSequenceNumber());
    }

    private void verifyTopLevelAssociationSequencing(SequenceOwnerImpl owner) {
        this.checkAssociatesThatShouldBeVersioned(owner);
        this.checkAssociatesThatShouldNotBeVersioned(owner);
    }

    private void checkAssociatesThatShouldNotBeVersioned(SequenceOwnerImpl owner) {
        for (SequenceAssociateChild child : owner.getSkipChildren()) {
            Assert.assertNotNull((Object)child.getChildId());
        }
    }

    private void checkAssociatesThatShouldBeVersioned(SequenceOwnerImpl owner) {
        for (SequenceAssociateChild child : owner.getChildren()) {
            Assert.assertEquals((Object)owner, (Object)child.getOwner());
            Assert.assertEquals((Object)owner.getSequenceNumber(), (Object)child.getSequenceNumber());
            Assert.assertNull((Object)child.getChildId());
            for (SequenceAssociateGrandChild grandChild : child.getChildren()) {
                Assert.assertEquals((Object)owner, (Object)grandChild.getOwner());
                Assert.assertEquals((Object)owner.getSequenceNumber(), (Object)grandChild.getSequenceNumber());
                Assert.assertNull((Object)grandChild.getGrandChildId());
            }
        }
    }

    private void verifyTopLevelAssociationsNotSequenced(OwnerAssociate ownerAssociate) {
        SequenceOwnerImpl owner = ownerAssociate.getSequenceOwner();
        for (SequenceAssociateChild child : owner.getChildren()) {
            Assert.assertEquals((Object)owner, (Object)child.getOwner());
            Assert.assertEquals((Object)owner.getSequenceNumber(), (Object)child.getSequenceNumber());
            Assert.assertNotNull((Object)child.getChildId());
            for (SequenceAssociateGrandChild grandChild : child.getChildren()) {
                Assert.assertEquals((Object)owner, (Object)grandChild.getOwner());
                Assert.assertEquals((Object)owner.getSequenceNumber(), (Object)grandChild.getSequenceNumber());
                Assert.assertNotNull((Object)grandChild.getGrandChildId());
            }
        }
    }
}

