/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl.mocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.bo.UnitCorrespondent;
import org.kuali.kra.service.UnitService;

public class MockUnitService
implements UnitService {
    private List<Unit> units = new ArrayList<Unit>();

    public void addUnit(String unitNumber, String parentUnitNumber) {
        Unit unit = new Unit();
        unit.setUnitNumber(unitNumber);
        unit.setUnitName("Name_" + unitNumber);
        unit.setParentUnitNumber(parentUnitNumber);
        if (parentUnitNumber == null) {
            unit.setParentUnit(null);
        } else {
            unit.setParentUnit(this.getUnit(parentUnitNumber));
        }
        this.units.add(unit);
    }

    public List<Unit> getAllSubUnits(String unitNumber) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        List<Unit> subUnits = this.getSubUnits(unitNumber);
        units.addAll(subUnits);
        for (Unit subUnit : subUnits) {
            units.addAll(this.getAllSubUnits(subUnit.getUnitNumber()));
        }
        return units;
    }

    public List<Unit> getUnitHierarchyForUnit(String unitNumber) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        Unit thisUnit = this.getUnit(unitNumber);
        if (thisUnit != null) {
            units.addAll(this.getUnitParentsAndSelf(thisUnit));
        }
        return units;
    }

    private List<Unit> getUnitParentsAndSelf(Unit unit) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        if (!StringUtils.isEmpty((String)unit.getParentUnitNumber())) {
            units.addAll(this.getUnitHierarchyForUnit(unit.getParentUnitNumber()));
        }
        units.add(unit);
        return units;
    }

    public List<Unit> getSubUnits(String unitNumber) {
        ArrayList<Unit> subUnits = new ArrayList<Unit>();
        for (Unit unit : this.units) {
            if (!StringUtils.equals((String)unitNumber, (String)unit.getParentUnitNumber())) continue;
            subUnits.add(unit);
        }
        return subUnits;
    }

    public Unit getUnitCaseInsensitive(String unitNumber) {
        for (Unit unit : this.units) {
            if (!StringUtils.equals((String)unitNumber.toUpperCase(), (String)unit.getUnitNumber().toUpperCase())) continue;
            return unit;
        }
        return null;
    }

    public Unit getUnit(String unitNumber) {
        for (Unit unit : this.units) {
            if (!StringUtils.equals((String)unitNumber, (String)unit.getUnitNumber())) continue;
            return unit;
        }
        return null;
    }

    public String getUnitName(String unitNumber) {
        String name = null;
        Unit unit = this.getUnit(unitNumber);
        if (unit != null) {
            name = unit.getUnitName();
        }
        return name;
    }

    public Collection<Unit> getUnits() {
        return this.units;
    }

    public String getSubUnitsForTreeView(String unitNumber) {
        return null;
    }

    public String getInitialUnitsForUnitHierarchy() {
        return null;
    }

    public String getInitialUnitsForUnitHierarchy(int depth) {
        return null;
    }

    public List<UnitAdministrator> retrieveUnitAdministratorsByUnitNumber(String unitNumber) {
        return null;
    }

    public List<UnitCorrespondent> retrieveUnitCorrespondentsByUnitNumber(String unitNumber) {
        return null;
    }

    public int getMaxUnitTreeDepth() {
        return 10;
    }

    public Unit getTopUnit() {
        return null;
    }
}

