/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl.versioningartifacts;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.kuali.kra.SequenceAssociate;
import org.kuali.kra.service.impl.versioningartifacts.SequenceAssociateGrandChild;
import org.kuali.kra.service.impl.versioningartifacts.SequenceOwnerImpl;

public class SequenceAssociateChild
implements SequenceAssociate<SequenceOwnerImpl> {
    private static final long serialVersionUID = 3354366183120742932L;
    private Long childId;
    private String name;
    private SequenceOwnerImpl owner;
    private Integer sequenceNumber;
    private List<SequenceAssociateGrandChild> children;

    public SequenceAssociateChild() {
        this.setChildId(new Random().nextLong());
        this.children = new ArrayList<SequenceAssociateGrandChild>();
    }

    public SequenceAssociateChild(String name) {
        this();
        this.name = name;
    }

    public void add(SequenceAssociateGrandChild grandChild) {
        this.children.add(grandChild);
        grandChild.setParent(this);
    }

    public List<SequenceAssociateGrandChild> getChildren() {
        return this.children;
    }

    public void setChildren(List<SequenceAssociateGrandChild> children) {
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SequenceOwnerImpl getOwner() {
        return this.owner;
    }

    public void setOwner(SequenceOwnerImpl owner) {
        this.owner = owner;
        this.sequenceNumber = owner != null ? owner.getSequenceNumber() : null;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public SequenceOwnerImpl getSequenceOwner() {
        return this.owner;
    }

    public void resetPersistenceState() {
        this.setChildId(null);
    }

    public void setSequenceOwner(SequenceOwnerImpl newOwner) {
        this.setOwner(newOwner);
    }

    public Long getChildId() {
        return this.childId;
    }

    public void setChildId(Long childId) {
        this.childId = childId;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceAssociateChild)) {
            return false;
        }
        SequenceAssociateChild other = (SequenceAssociateChild)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.sequenceNumber == null ? other.sequenceNumber != null : !this.sequenceNumber.equals(other.sequenceNumber));
    }

    public String toString() {
        return this.name;
    }
}

