/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.document;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardDocumentTest
extends KcUnitTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testSave() throws Exception {
        SubAwardDocument document = (SubAwardDocument)this.getDocumentService().getNewDocument("SubAwardDocument");
        this.setBaseDocumentFields(document, "SubcontractDocumentTest test doc");
        this.getDocumentService().saveDocument((Document)document);
        SubAwardDocument savedDocument = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(document.getDocumentNumber());
        SubAwardDocumentTest.assertNotNull((Object)savedDocument);
        this.checkDocumentFields(savedDocument, document, "SubcontractDocumentTest test doc");
    }

    private void setBaseDocumentFields(SubAwardDocument document, String description) {
        document.getDocumentHeader().setDocumentDescription(description);
        SubAward subAward = new SubAward();
        subAward.setOrganizationId("000001");
        subAward.setSubAwardTypeCode(Integer.valueOf(229));
        subAward.setSubAwardCode("7687");
        subAward.setStatusCode(Integer.valueOf(123));
        subAward.setPurchaseOrderNum("111");
        subAward.setRequisitionerId("1");
        document.setSubAward(subAward);
    }

    private void checkDocumentFields(SubAwardDocument saveddoc, SubAwardDocument document, String description) {
        SubAwardDocumentTest.assertEquals((Object)saveddoc.getDocumentNumber(), (Object)document.getDocumentNumber());
        SubAwardDocumentTest.assertEquals((Object)description, (Object)document.getDocumentHeader().getDocumentDescription());
        SubAwardDocumentTest.assertEquals((Object)saveddoc.getSubAward().getOrganizationId(), (Object)document.getSubAward().getOrganizationId());
        SubAwardDocumentTest.assertEquals((Object)saveddoc.getSubAward().getSubAwardTypeCode(), (Object)document.getSubAward().getSubAwardTypeCode());
        SubAwardDocumentTest.assertEquals((Object)saveddoc.getSubAward().getSubAwardCode(), (Object)document.getSubAward().getSubAwardCode());
        SubAwardDocumentTest.assertEquals((Object)saveddoc.getSubAward().getStatusCode(), (Object)document.getSubAward().getStatusCode());
    }
}

