/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.document.authorization;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.document.authorization.SubAwardTask;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class TestSubAwardAuthorizers
extends KcUnitTestBase {
    TaskAuthorizationService taskAuthorizationService;
    BusinessObjectService businessObjectService;
    DocumentService documentService;
    Person quickstart;
    Person jtester;
    Person woods;
    Person ospAdmin;

    @Override
    @Before
    public void setUp() throws Exception {
        this.taskAuthorizationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.quickstart = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("quickstart");
        this.jtester = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("jtester");
        this.woods = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("woods");
        this.ospAdmin = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("borst");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.taskAuthorizationService = null;
        this.businessObjectService = null;
        this.documentService = null;
        this.quickstart = null;
        this.jtester = null;
        this.woods = null;
        this.ospAdmin = null;
    }

    @Test
    public void testModifySubAuthorizer() throws WorkflowException {
        SubAwardDocument subAwardDoc = this.getSubAwardDocument();
        SubAwardTask task = new SubAwardTask("modifySubaward", subAwardDoc);
        boolean retVal = this.taskAuthorizationService.isAuthorized(this.quickstart.getPrincipalId(), (Task)task);
        TestSubAwardAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.jtester.getPrincipalId(), (Task)task);
        TestSubAwardAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.woods.getPrincipalId(), (Task)task);
        TestSubAwardAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.ospAdmin.getPrincipalId(), (Task)task);
        TestSubAwardAuthorizers.assertFalse((boolean)retVal);
    }

    @Test
    public void testViewSubAuthorizer() throws WorkflowException {
        SubAwardDocument subAwardDoc = this.getSubAwardDocument();
        SubAwardTask task = new SubAwardTask("viewSubaward", subAwardDoc);
        boolean retVal = this.taskAuthorizationService.isAuthorized(this.quickstart.getPrincipalId(), (Task)task);
        TestSubAwardAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.jtester.getPrincipalId(), (Task)task);
        TestSubAwardAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.woods.getPrincipalId(), (Task)task);
        TestSubAwardAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.ospAdmin.getPrincipalId(), (Task)task);
        TestSubAwardAuthorizers.assertFalse((boolean)retVal);
    }

    private SubAwardDocument getSubAwardDocument() throws WorkflowException {
        SubAwardDocument document = (SubAwardDocument)this.getDocumentService().getNewDocument(SubAwardDocument.class);
        document.getDocumentHeader().setDocumentDescription("SubcontractDocumentTest test doc");
        SubAward subAward = new SubAward();
        subAward.setOrganizationId("000001");
        subAward.setSubAwardTypeCode(Integer.valueOf(229));
        subAward.setSubAwardCode("7687");
        subAward.setStatusCode(Integer.valueOf(123));
        subAward.setPurchaseOrderNum("111");
        subAward.setRequisitionerId("1");
        document.setSubAward(subAward);
        this.getDocumentService().saveDocument((Document)document);
        return document;
    }
}

