/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import java.sql.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.bo.SubAwardCloseout;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class SubAwardDocumentRuleTest
extends KcUnitTestBase {
    SubAward subAward;
    SubAwardDocumentRule subAwardDocumentRule;
    SubAwardAmountInfo subAwardAmountInfo;
    SubAwardAmountReleased subAwardAmountReleased;
    SubAwardContact subAwardContact;
    SubAwardCloseout subAwardCloseout;
    SubAwardFundingSource subAwardFundingSource;

    @Override
    @Before
    public void setUp() throws Exception {
        this.subAward = new SubAward();
        this.subAwardDocumentRule = new SubAwardDocumentRule();
        this.subAward.setOrganizationId("000140");
        this.subAward.setStatusCode(Integer.valueOf(1));
        this.subAward.setSubAwardTypeCode(Integer.valueOf(1));
        this.subAward.setRequisitionerId("1");
        this.subAward.setPurchaseOrderNum("1");
        this.subAward.setTotalAmountReleased(KualiDecimal.ZERO);
        this.subAward.setTotalAnticipatedAmount(KualiDecimal.ZERO);
        this.subAward.setTotalAvailableAmount(KualiDecimal.ZERO);
        this.subAward.setTotalObligatedAmount(KualiDecimal.ZERO);
        this.subAwardAmountInfo = new SubAwardAmountInfo();
        this.subAwardAmountInfo.setEffectiveDate(new Date(System.currentTimeMillis()));
        this.subAwardAmountInfo.setObligatedChange(new KualiDecimal(150));
        this.subAwardAmountInfo.setAnticipatedChange(new KualiDecimal(200));
        this.subAwardAmountReleased = new SubAwardAmountReleased();
        this.subAwardAmountReleased.setInvoiceNumber("1");
        this.subAwardAmountReleased.setStartDate(new Date(System.currentTimeMillis()));
        this.subAwardAmountReleased.setEndDate(new Date(System.currentTimeMillis()));
        this.subAwardAmountReleased.setEffectiveDate(new Date(System.currentTimeMillis()));
        this.subAwardAmountReleased.setAmountReleased(new KualiDecimal(100));
        this.subAwardContact = new SubAwardContact();
        this.subAwardContact.setRolodexId(Integer.valueOf(1));
        this.subAwardContact.setContactTypeCode("1");
        this.subAwardCloseout = new SubAwardCloseout();
        this.subAwardCloseout.setCloseoutTypeCode(Integer.valueOf(1));
        this.subAwardCloseout.setDateRequested(new Date(2012, 1, 1));
        this.subAwardCloseout.setDateFollowup(new Date(2012, 2, 15));
        this.subAwardFundingSource = new SubAwardFundingSource();
        this.subAwardFundingSource.setAwardId(new Long("1183316613046"));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.subAward = null;
        this.subAwardDocumentRule = null;
        this.subAwardAmountInfo = null;
        this.subAwardAmountReleased = null;
        this.subAwardContact = null;
        this.subAwardCloseout = null;
        this.subAwardFundingSource = null;
    }

    @Test
    public void testprocessAddSubAwardBusinessRules() throws Exception {
        Assert.assertTrue((boolean)this.subAwardDocumentRule.processAddSubAwardBusinessRules(this.subAward));
    }

    @Test
    public void testProcessAddSubAwardAmountInfoBusinessRules() throws Exception {
        Assert.assertTrue((boolean)this.subAwardDocumentRule.processAddSubAwardAmountInfoBusinessRules(this.subAwardAmountInfo, this.subAward));
    }

    @Test
    public void testProcessAddSubAwardContactBusinessRules() {
        Assert.assertTrue((boolean)this.subAwardDocumentRule.processAddSubAwardContactBusinessRules(this.subAwardContact, this.subAward));
    }

    @Test
    public void testProcessAddSubAwardCloseoutBusinessRules() {
        Assert.assertTrue((boolean)this.subAwardDocumentRule.processAddSubAwardCloseoutBusinessRules(this.subAwardCloseout));
    }

    @Test
    public void testProcessAddSubAwardFundingSourceBusinessRules() {
        Assert.assertTrue((boolean)this.subAwardDocumentRule.processAddSubAwardFundingSourceBusinessRules(this.subAwardFundingSource, this.subAward));
    }
}

