/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OjbRepositoryMappingTest {
    private static final Log LOG = LogFactory.getLog(OjbRepositoryMappingTest.class);
    private static final String INTERNAL_TEST_CONFIG_FILE_PATH = "classpath:META-INF/kc-test-config.xml";
    private static final String CLASS_DESCRIPTOR_NAME = "class-descriptor";
    private static final String FIELD_DESCRIPTOR_NAME = "field-descriptor";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String TABLE_ATTRIBUTE_NAME = "table";
    private static final String DEFAULT_ATTRIBUTE_NAME = "name";
    private static final String COLUMN_ATTRIBUTE_NAME = "column";
    private static final String COLLECTION_DESCRIPTOR_NAME = "collection-descriptor";
    private static final String REFERENCE_DESCRIPTOR_NAME = "reference-descriptor";
    private static final String CLASS_REF_ATTRIBUTE_NAME = "class-ref";
    private static final String EL_CLASS_REF_ATTRIBUTE_NAME = "element-class-ref";
    private static final String FIELD_REF_ATTRIBUTE_NAME = "field-ref";
    private static final String FIELD_ID_REF_ATTRIBUTE_NAME = "field-id-ref";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String FOREIGN_KEY_NAME = "foreignkey";
    private static final String INVERSE_FOREIGN_KEY_NAME = "inverse-foreignkey";
    private static final String COLLECTION_CLASS_NAME = "collection-class";
    private static final String DATASOURCE_URL_NAME = "datasource.url";
    private static final String DATASOURCE_USERNAME_NAME = "datasource.username";
    private static final String DATASOURCE_PASSWORD_NAME = "datasource.password";
    private static final String DATASOURCE_DRIVER_NAME = "datasource.driver.name";
    private static final String[] repositoryFiles = new String[]{"repository.xml", "org/kuali/kra/award/repository-award.xml", "org/kuali/kra/coi/repository-coi.xml", "org/kuali/kra/committee/repository-committee.xml", "org/kuali/kra/institutionalproposal/repository-institutionalproposal.xml", "org/kuali/kra/irb/repository-irb.xml", "org/kuali/kra/negotiation/repository-negotiation.xml", "org/kuali/kra/personmasschange/repository-personmasschange.xml", "org/kuali/kra/proposaldevelopment/repository-proposaldevelopment.xml", "org/kuali/kra/questionnaire/repository-questionnaire.xml", "org/kuali/kra/timeandmoney/repository-timeandmoney.xml"};
    private static Map<String, String> configFileParms;
    private String dsUrl;
    private String dsUser;
    private String dsPass;
    private String dsSchema;
    private String dsDriver;

    @BeforeClass
    public static void loadParms() throws Exception {
        JAXBConfigImpl config = new JAXBConfigImpl(INTERNAL_TEST_CONFIG_FILE_PATH);
        config.parseConfig();
        configFileParms = new HashMap<Object, Object>(config.getProperties());
    }

    @AfterClass
    public static void unloadParms() throws Exception {
        if (configFileParms != null) {
            configFileParms.clear();
            configFileParms = null;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.dsUrl = configFileParms.get(DATASOURCE_URL_NAME);
        this.dsUser = configFileParms.get(DATASOURCE_USERNAME_NAME);
        this.dsPass = configFileParms.get(DATASOURCE_PASSWORD_NAME);
        this.dsDriver = configFileParms.get(DATASOURCE_DRIVER_NAME);
        this.dsSchema = StringUtils.upperCase((String)this.dsUser);
        LOG.debug((Object)String.format("dsUrl = %s\n", this.dsUrl));
        LOG.debug((Object)String.format("dsUser = %s\n", this.dsUser));
        LOG.debug((Object)String.format("dsDriver = %s\n", this.dsDriver));
        LOG.debug((Object)String.format("dsSchema = %s\n", this.dsSchema));
    }

    @After
    public void tearDown() {
        this.dsUrl = null;
        this.dsUser = null;
        this.dsPass = null;
        this.dsSchema = null;
        this.dsDriver = null;
    }

    @Test
    public void xmlValidation() throws Exception {
        for (String repositoryFilePath : repositoryFiles) {
            this.validateXml(repositoryFilePath);
        }
    }

    @Test
    public void verifyTables() throws Exception {
        for (String repositoryFilePath : repositoryFiles) {
            this.verifyTableForRepository(repositoryFilePath);
        }
    }

    @Test
    public void verifyClasses() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyTableForRepository(String repositoryFilePath) throws SQLException, ParserConfigurationException, SAXException, IOException, ClassNotFoundException {
        Class.forName(this.dsDriver);
        Connection conn = DriverManager.getConnection(this.dsUrl, this.dsUser, this.dsPass);
        TableValidationHandler handler = new TableValidationHandler(conn);
        LOG.debug((Object)String.format("Starting XML validation", new Object[0]));
        URL repositoryUrl = this.getClass().getClassLoader().getResource(repositoryFilePath);
        LOG.debug((Object)String.format("Found repository url %s\n", repositoryUrl));
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(false);
        SAXParser parser = saxParserFactory.newSAXParser();
        try {
            parser.parse(repositoryUrl.getFile(), (DefaultHandler)handler);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    private void verifyClassesInRepository(String repositoryFilePath) throws ParserConfigurationException, SAXException, IOException {
        ClassValidationHandler handler = new ClassValidationHandler();
        URL repositoryUrl = this.getClass().getClassLoader().getResource(repositoryFilePath);
        LOG.debug((Object)String.format("Found repository url %s\n", repositoryUrl));
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(false);
        SAXParser parser = saxParserFactory.newSAXParser();
        parser.parse(repositoryUrl.getFile(), (DefaultHandler)handler);
    }

    private void validateXml(String repositoryFilePath) throws ParserConfigurationException, SAXException {
        LOG.debug((Object)String.format("Starting XML validation", new Object[0]));
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(false);
        SAXParser parser = saxParserFactory.newSAXParser();
        try {
            parser.parse(this.findRepositoryFilePath(repositoryFilePath), new DefaultHandler());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test should not encounter exceptions during parsing.");
        }
    }

    private String findRepositoryFilePath(String repositoryFilePath) {
        return this.getClass().getClassLoader().getResource(repositoryFilePath).getFile();
    }

    class TableValidationHandler
    extends DefaultHandler {
        private static final String COLUMN_NOT_FOUND_MESSAGE = "There is no column named %s in table or view %s\n";
        private static final String TABLE_NOT_FOUND_MESSAGE = "There is no table or view named %s\n";
        private Connection connection;
        private Locator locator;
        private String currentTableName;

        public TableValidationHandler(Connection conn) {
            this.connection = conn;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXParseException {
            if (OjbRepositoryMappingTest.CLASS_DESCRIPTOR_NAME.equals(qName)) {
                this.setCurrentTableName(attributes.getValue(OjbRepositoryMappingTest.TABLE_ATTRIBUTE_NAME));
                ResultSet results = null;
                try {
                    results = this.getConnection().getMetaData().getTables(null, OjbRepositoryMappingTest.this.dsSchema, this.getCurrentTableName(), new String[]{"TABLE", "VIEW"});
                    boolean found = false;
                    while (results.next() && !found) {
                        String tableNameResult = results.getString("TABLE_NAME");
                        if (!this.getCurrentTableName().equalsIgnoreCase(tableNameResult)) continue;
                        found = true;
                    }
                    if (!found) {
                        LOG.debug((Object)String.format(TABLE_NOT_FOUND_MESSAGE, attributes.getValue(OjbRepositoryMappingTest.TABLE_ATTRIBUTE_NAME)));
                        throw this.createSaxParseException(TABLE_NOT_FOUND_MESSAGE, attributes.getValue(OjbRepositoryMappingTest.TABLE_ATTRIBUTE_NAME));
                    }
                    LOG.debug((Object)String.format("Found table or view %s\n", this.getCurrentTableName()));
                }
                catch (Exception e) {
                    throw this.createSaxParseException(e, TABLE_NOT_FOUND_MESSAGE, attributes.getValue(OjbRepositoryMappingTest.TABLE_ATTRIBUTE_NAME));
                }
                finally {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            this.handleFieldDescriptor(qName, attributes);
        }

        private void handleFieldDescriptor(String qName, Attributes attributes) throws SAXParseException {
            if (OjbRepositoryMappingTest.FIELD_DESCRIPTOR_NAME.equals(qName)) {
                String columnName = attributes.getValue(OjbRepositoryMappingTest.COLUMN_ATTRIBUTE_NAME).toUpperCase();
                ResultSet results = null;
                try {
                    results = this.getConnection().getMetaData().getColumns(null, OjbRepositoryMappingTest.this.dsSchema, this.getCurrentTableName(), columnName);
                    boolean found = false;
                    String columnNameResult = null;
                    while (results.next() && !found) {
                        columnNameResult = results.getString("COLUMN_NAME");
                        LOG.debug((Object)String.format("Comparing %s to %s in table %s\n", columnName, columnNameResult, this.getCurrentTableName()));
                        if (!columnName.equalsIgnoreCase(columnNameResult)) continue;
                        found = true;
                    }
                    if (!found) {
                        throw this.createSaxParseException(COLUMN_NOT_FOUND_MESSAGE, attributes.getValue(OjbRepositoryMappingTest.COLUMN_ATTRIBUTE_NAME), this.getCurrentTableName());
                    }
                }
                catch (Exception e) {
                    throw this.createSaxParseException(e, COLUMN_NOT_FOUND_MESSAGE, attributes.getValue(OjbRepositoryMappingTest.COLUMN_ATTRIBUTE_NAME), this.getCurrentTableName());
                }
                finally {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }

        private SAXParseException createSaxParseException(Exception e, String pattern, String ... params) {
            StringWriter writer = new StringWriter();
            new PrintWriter(writer).printf(pattern, params);
            return new SAXParseException(writer.toString() + "\n" + e.getMessage(), this.locator.getPublicId(), this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
        }

        private SAXParseException createSaxParseException(String pattern, String ... params) {
            StringWriter writer = new StringWriter();
            new PrintWriter(writer).printf(pattern, params);
            return new SAXParseException(writer.toString(), this.locator);
        }

        public String getCurrentTableName() {
            return this.currentTableName;
        }

        public void setCurrentTableName(String currentTableName) {
            this.currentTableName = currentTableName;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }
    }

    class ClassValidationHandler
    extends DefaultHandler {
        private Locator locator;
        private Class currentMappedClass;
        private Class currentClassRef;
        private Map<String, Map<Class, String>> fieldIdMap;

        ClassValidationHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXParseException {
            if (OjbRepositoryMappingTest.CLASS_DESCRIPTOR_NAME.equals(qName)) {
                if (this.fieldIdMap == null) {
                    this.fieldIdMap = new HashMap<String, Map<Class, String>>();
                } else {
                    this.fieldIdMap.clear();
                }
                try {
                    this.setCurrentMappedClass(Class.forName(attributes.getValue(OjbRepositoryMappingTest.CLASS_ATTRIBUTE_NAME)));
                    LOG.debug((Object)String.format("Parsing %s for %s\n", OjbRepositoryMappingTest.CLASS_DESCRIPTOR_NAME, this.getCurrentMappedClass().getSimpleName()));
                }
                catch (Exception e) {
                    throw this.createSaxParseException("There is no class named " + attributes.getValue(OjbRepositoryMappingTest.CLASS_ATTRIBUTE_NAME), e);
                }
            } else {
                this.handleFieldDescriptor(qName, attributes);
                this.handleReferenceDescriptor(qName, attributes);
                this.handleCollectionDescriptor(qName, attributes);
                this.handleForeignKeyDescriptor(qName, attributes);
            }
        }

        private void handleReferenceDescriptor(String qName, Attributes attributes) throws SAXParseException {
            if (OjbRepositoryMappingTest.REFERENCE_DESCRIPTOR_NAME.equals(qName)) {
                try {
                    this.setCurrentClassRef(Class.forName(attributes.getValue(OjbRepositoryMappingTest.CLASS_REF_ATTRIBUTE_NAME)));
                }
                catch (ClassNotFoundException cnfe) {
                    throw this.createSaxParseException("Could not find class-ref " + attributes.getValue(OjbRepositoryMappingTest.CLASS_REF_ATTRIBUTE_NAME), cnfe);
                }
            }
        }

        private void findFieldInClass(Class clazz, String property) throws SAXParseException {
            try {
                boolean exists = this.isFieldInClass(clazz, property);
                if (!exists) {
                    exists = this.isFieldIdMapped(clazz, property);
                }
                if (!exists) {
                    throw new NoSuchFieldException("Property with name " + property + " does not exist in class " + clazz.getName());
                }
            }
            catch (NoSuchFieldException e) {
                throw this.createSaxParseException("Property with name " + property + " does not exist in class " + clazz.getName(), e);
            }
        }

        private boolean isFieldIdMapped(Class clazz, String id) {
            return this.getFieldIdMap().containsKey(id) && this.getFieldIdMap().get(id).containsKey(clazz);
        }

        private boolean isFieldInClass(Class clazz, String fieldName) {
            boolean retval = false;
            for (int i = 0; i < PropertyUtils.getPropertyDescriptors((Class)clazz).length && !retval; ++i) {
                PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptors((Class)clazz)[i];
                retval = descriptor.getName().equals(fieldName);
            }
            return retval;
        }

        private void handleForeignKeyDescriptor(String qName, Attributes attributes) throws SAXParseException {
            if (OjbRepositoryMappingTest.FOREIGN_KEY_NAME.equals(qName)) {
                String referenceName = attributes.getValue(OjbRepositoryMappingTest.FIELD_REF_ATTRIBUTE_NAME);
                if (referenceName == null) {
                    referenceName = attributes.getValue(OjbRepositoryMappingTest.FIELD_ID_REF_ATTRIBUTE_NAME);
                }
                this.findFieldInClass(this.getCurrentMappedClass(), referenceName);
            } else if (OjbRepositoryMappingTest.INVERSE_FOREIGN_KEY_NAME.equals(qName)) {
                this.findFieldInClass(this.getCurrentClassRef(), attributes.getValue(OjbRepositoryMappingTest.FIELD_REF_ATTRIBUTE_NAME));
            }
        }

        private void handleFieldDescriptor(String qName, Attributes attributes) throws SAXParseException {
            if (OjbRepositoryMappingTest.FIELD_DESCRIPTOR_NAME.equals(qName) || OjbRepositoryMappingTest.COLLECTION_DESCRIPTOR_NAME.equals(qName)) {
                if (attributes.getValue(OjbRepositoryMappingTest.ID_ATTRIBUTE_NAME) != null) {
                    HashMap<Class, String> classFieldMap = new HashMap<Class, String>();
                    classFieldMap.put(this.getCurrentMappedClass(), attributes.getValue(OjbRepositoryMappingTest.DEFAULT_ATTRIBUTE_NAME));
                    this.getFieldIdMap().put(attributes.getValue(OjbRepositoryMappingTest.ID_ATTRIBUTE_NAME), classFieldMap);
                }
                this.findFieldInClass(this.getCurrentMappedClass(), attributes.getValue(OjbRepositoryMappingTest.DEFAULT_ATTRIBUTE_NAME));
            }
        }

        private void handleCollectionDescriptor(String qName, Attributes attributes) throws SAXParseException {
            this.handleFieldDescriptor(qName, attributes);
            if (OjbRepositoryMappingTest.COLLECTION_DESCRIPTOR_NAME.equals(qName)) {
                try {
                    String collectionClassName = attributes.getValue(OjbRepositoryMappingTest.COLLECTION_CLASS_NAME);
                    if (collectionClassName != null) {
                        Class.forName(collectionClassName);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw this.createSaxParseException("Could not find collection-class " + attributes.getValue(OjbRepositoryMappingTest.COLLECTION_CLASS_NAME), cnfe);
                }
                try {
                    this.setCurrentClassRef(Class.forName(attributes.getValue(OjbRepositoryMappingTest.EL_CLASS_REF_ATTRIBUTE_NAME)));
                }
                catch (ClassNotFoundException cnfe) {
                    throw this.createSaxParseException("Could not find element-class-ref " + attributes.getValue(OjbRepositoryMappingTest.EL_CLASS_REF_ATTRIBUTE_NAME), cnfe);
                }
            }
        }

        private SAXParseException createSaxParseException(String msg, Exception e) {
            return new SAXParseException(msg + "\n" + e.getMessage(), this.locator.getPublicId(), this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
        }

        public Class getCurrentMappedClass() {
            return this.currentMappedClass;
        }

        public void setCurrentMappedClass(Class currentMappedClass) {
            this.currentMappedClass = currentMappedClass;
        }

        public Class getCurrentClassRef() {
            return this.currentClassRef;
        }

        public void setCurrentClassRef(Class currentClassRef) {
            this.currentClassRef = currentClassRef;
        }

        public Map<String, Map<Class, String>> getFieldIdMap() {
            return this.fieldIdMap;
        }

        public void setFieldIdMap(Map<String, Map<Class, String>> fieldIdMap) {
            this.fieldIdMap = fieldIdMap;
        }
    }
}

