/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public class StateServiceTest
extends KcUnitTestBase {
    private StateService stateService;
    private static final String POSTAL_CNTRY_CD_UNITED_STATES = "US";
    private static final String ALT_POSTAL_CNTRY_CD_UNITED_STATES = "USA";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.stateService = (StateService)KraServiceLocator.getService(StateService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.stateService = null;
        super.tearDown();
    }

    @Test
    public void testFindAllStatesByAltCountryCode() throws Exception {
        List states = this.stateService.findAllStatesInCountryByAltCode(ALT_POSTAL_CNTRY_CD_UNITED_STATES);
        List statesForComparison = this.stateService.findAllStatesInCountry(POSTAL_CNTRY_CD_UNITED_STATES);
        StateServiceTest.assertNotNull((Object)states);
        StateServiceTest.assertNotNull((Object)statesForComparison);
        StateServiceTest.assertEquals((long)states.size(), (long)statesForComparison.size());
        int i = 0;
        for (State state : states) {
            StateServiceTest.assertEquals((Object)state.getName(), (Object)((State)statesForComparison.get(i)).getName());
            ++i;
        }
    }
}

