/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.fixtures;

import java.sql.Date;
import java.text.SimpleDateFormat;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.krad.service.DocumentService;

public enum ProposalDevelopmentDocumentFixture {
    NORMAL_DOCUMENT;

    private String description;
    private String sponsorCode;
    private String title;
    private String startDateInitial;
    private String endDateInitial;
    private String activityTypeCode;
    private String proposalTypeCode;
    private String ownedByUnit;

    private ProposalDevelopmentDocumentFixture() {
        this("KeyPersonnelAuditRuleTest test", "005889", "Project title", "08/14/2007", "08/21/2007", "1", "1", "000001");
    }

    private ProposalDevelopmentDocumentFixture(String description, String sponsorCode, String title, String startDateInitial, String endDateInitial, String activityTypeCode, String proposalTypeCode, String ownedByUnit) {
        this.description = description;
        this.sponsorCode = sponsorCode;
        this.title = title;
        this.startDateInitial = startDateInitial;
        this.endDateInitial = endDateInitial;
        this.activityTypeCode = activityTypeCode;
        this.proposalTypeCode = proposalTypeCode;
        this.ownedByUnit = ownedByUnit;
    }

    public ProposalDevelopmentDocument getDocument() {
        ProposalDevelopmentDocument retval = null;
        try {
            Date requestedStartDateInitial = new Date(new SimpleDateFormat("MM/dd/yyyy").parse(this.startDateInitial).getTime());
            Date requestedEndDateInitial = new Date(new SimpleDateFormat("MM/dd/yyyy").parse(this.endDateInitial).getTime());
            retval = (ProposalDevelopmentDocument)this.getDocumentService().getNewDocument(ProposalDevelopmentDocument.class);
            this.setRequiredDocumentFields(retval, this.description, this.sponsorCode, this.title, requestedStartDateInitial, requestedEndDateInitial, this.activityTypeCode, this.proposalTypeCode, this.ownedByUnit);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retval;
    }

    private void setRequiredDocumentFields(ProposalDevelopmentDocument document, String description, String sponsorCode, String title, Date requestedStartDateInitial, Date requestedEndDateInitial, String activityTypeCode, String proposalTypeCode, String ownedByUnit) {
        document.getDocumentHeader().setDocumentDescription(description);
        document.getDevelopmentProposal().setSponsorCode(sponsorCode);
        document.getDevelopmentProposal().setTitle(title);
        document.getDevelopmentProposal().setRequestedStartDateInitial(requestedStartDateInitial);
        document.getDevelopmentProposal().setRequestedEndDateInitial(requestedEndDateInitial);
        document.getDevelopmentProposal().setActivityTypeCode(activityTypeCode);
        document.getDevelopmentProposal().setProposalTypeCode(proposalTypeCode);
        document.getDevelopmentProposal().setOwnedByUnitNumber(ownedByUnit);
        for (ProposalSite site : document.getDevelopmentProposal().getProposalSites()) {
            site.setSiteNumber(document.getDocumentNextValue("proposalDevelopment.proposalLocation.locationSequenceNumber"));
        }
    }

    private DocumentService getDocumentService() {
        return (DocumentService)KraServiceLocator.getService(DocumentService.class);
    }
}

