/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.fixtures;

import org.kuali.kra.bo.PersonEditableInterface;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonCreditSplit;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonYnq;
import org.kuali.kra.proposaldevelopment.bo.ProposalUnitCreditSplit;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.service.PersonEditableService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum ProposalPersonFixture {
    PRINCIPAL_INVESTIGATOR("10000000003", "PI"),
    INCOMPLETE_CERTIFICATIONS("10000000003", "PI"){

        @Override
        public void populatePerson(ProposalDevelopmentDocument document, ProposalPerson person) {
            super.populatePerson(document, person);
            person.getProposalPersonYnq(0).setAnswer(null);
        }
    }
    ,
    INVESTIGATOR_SPLIT_ADDS_TO_ONE_HUNDRED("10000000003", "PI"){

        @Override
        public void populatePerson(ProposalDevelopmentDocument document, ProposalPerson person) {
            super.populatePerson(document, person);
        }
    }
    ,
    INVESTIGATOR_UNIT_NOT_TO_ONE_HUNDRED("admin", "PI"){

        @Override
        public void populatePerson(ProposalDevelopmentDocument document, ProposalPerson person) {
            super.populatePerson(document, person);
            for (ProposalUnitCreditSplit creditSplit : person.getUnit(0).getCreditSplits()) {
                if (!creditSplit.getInvestigatorCreditType().addsToHundred().booleanValue()) continue;
                creditSplit.setCredit(new KualiDecimal(50.0));
            }
        }
    }
    ,
    INVESTIGATOR_OVER_ONE_HUNDRED("10000000003", "PI"){

        @Override
        public void populatePerson(ProposalDevelopmentDocument document, ProposalPerson person) {
            super.populatePerson(document, person);
            person.getCreditSplit(0).setCredit(new KualiDecimal(200.0));
        }
    }
    ,
    INVESTIGATOR_UNDER_ZERO("10000000003", "PI"){

        @Override
        public void populatePerson(ProposalDevelopmentDocument document, ProposalPerson person) {
            super.populatePerson(document, person);
            person.getCreditSplit(0).setCredit(new KualiDecimal(-10.0));
        }
    }
    ,
    INVESTIGATOR_UNIT_OVER_ONE_HUNDRED("10000000003", "PI"){

        @Override
        public void populatePerson(ProposalDevelopmentDocument document, ProposalPerson person) {
            super.populatePerson(document, person);
            person.getUnit(0).getCreditSplit(0).setCredit(new KualiDecimal(200.0));
        }
    }
    ,
    INVESTIGATOR_UNIT_UNDER_ZERO("10000000003", "PI"){

        @Override
        public void populatePerson(ProposalDevelopmentDocument document, ProposalPerson person) {
            super.populatePerson(document, person);
            person.getUnit(0).getCreditSplit(0).setCredit(new KualiDecimal(-10.0));
        }
    }
    ,
    JTESTER_CO_INVESTIGATOR("10000000001", "COI"),
    WOODS_CO_INVESTIGATOR("10000000005", "COI"),
    OBLOOD_KEY_PERSON("10000000006", "KP");

    private String personId;
    private String roleId;

    private ProposalPersonFixture() {
    }

    private ProposalPersonFixture(String personId, String roleId) {
        this.roleId = roleId;
        this.personId = personId;
    }

    public ProposalPerson getPerson() {
        ProposalPerson retval = new ProposalPerson();
        retval.setPersonId(this.personId);
        ((PersonEditableService)KraServiceLocator.getService(PersonEditableService.class)).populateContactFieldsFromPersonId((PersonEditableInterface)retval);
        retval.setProposalPersonRoleId(this.roleId);
        retval.setPercentageEffort(new KualiDecimal(100.0));
        return retval;
    }

    public void populatePerson(ProposalDevelopmentDocument document, ProposalPerson person) {
        ((KeyPersonnelService)KraServiceLocator.getService(KeyPersonnelService.class)).populateProposalPerson(person, document);
        if (((KeyPersonnelService)KraServiceLocator.getService(KeyPersonnelService.class)).isPrincipalInvestigator(person)) {
            ((KeyPersonnelService)KraServiceLocator.getService(KeyPersonnelService.class)).assignLeadUnit(person, document.getDevelopmentProposal().getOwnedByUnitNumber());
        } else {
            ProposalPersonUnit unit = person.getUnit(document.getDevelopmentProposal().getOwnedByUnitNumber());
            if (unit != null) {
                unit.setLeadUnit(false);
            }
        }
        for (ProposalPersonCreditSplit creditSplit : person.getCreditSplits()) {
            creditSplit.refreshReferenceObject("investigatorCreditType");
            if (!creditSplit.getInvestigatorCreditType().addsToHundred().booleanValue()) continue;
            creditSplit.setCredit(new KualiDecimal(100.0));
        }
        for (ProposalPersonUnit unit : person.getUnits()) {
            for (ProposalUnitCreditSplit creditSplit : unit.getCreditSplits()) {
                creditSplit.refreshReferenceObject("investigatorCreditType");
                if (!creditSplit.getInvestigatorCreditType().addsToHundred().booleanValue()) continue;
                creditSplit.setCredit(new KualiDecimal(100.0));
            }
        }
        if (((KeyPersonnelService)KraServiceLocator.getService(KeyPersonnelService.class)).isPrincipalInvestigator(person)) {
            for (ProposalPersonYnq ynq : person.getProposalPersonYnqs()) {
                ynq.setAnswer("Y");
            }
        }
    }
}

