/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.kuali.rice.core.api.lifecycle.Lifecycle;

public class JettyServer
implements Lifecycle {
    private static final Log LOG = LogFactory.getLog(JettyServer.class);
    public static final String JETTYSERVER_TESTMODE_ATTRIB = "JETTYSERVER_TESTMODE";
    private int port;
    private String contextName;
    private String relativeWebappRoot;
    private Class servletClass;
    private Server server;
    private ServletContextHandler context;
    private boolean failOnContextFailure;
    private boolean testMode = false;

    public JettyServer() {
        this(8080);
    }

    public JettyServer(int port) {
        this(port, null, null, null);
    }

    public JettyServer(int port, String contextName) {
        this(port, contextName, null, null);
    }

    public JettyServer(int port, String contextName, String relativeWebappRoot) {
        this(port, contextName, relativeWebappRoot, null);
    }

    public JettyServer(int port, String contextName, Class servletClass) {
        this(port, contextName, null, servletClass);
    }

    public JettyServer(int port, String contextName, String relativeWebappRoot, Class servletClass) {
        this.port = port;
        this.contextName = contextName;
        this.relativeWebappRoot = relativeWebappRoot;
        this.servletClass = servletClass;
    }

    public void setTestMode(boolean t) {
        this.testMode = t;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public Server getServer() {
        return this.server;
    }

    public ServletContextHandler getContext() {
        return this.context;
    }

    public void start() throws Exception {
        this.server = this.createServer();
        this.server.start();
        if (this.isFailOnContextFailure() && this.contextStartupFailed()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to stop server after web application startup failure.");
            }
            throw new Exception("Failed to startup web application context!  Check logs for specific error.");
        }
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    protected Server createServer() {
        Server server = new Server(this.getPort());
        this.setBaseDirSystemProperty();
        if (this.useWebAppContext()) {
            File tmpDir = new File(System.getProperty("basedir") + "/target/jetty-tmp");
            tmpDir.mkdirs();
            WebAppContext webAppContext = new WebAppContext(System.getProperty("basedir") + this.getRelativeWebappRoot(), this.getContextName());
            webAppContext.setTempDirectory(tmpDir);
            webAppContext.setAttribute(JETTYSERVER_TESTMODE_ATTRIB, (Object)String.valueOf(this.isTestMode()));
            this.context = webAppContext;
            server.setHandler((Handler)this.context);
        } else {
            ServletContextHandler root = new ServletContextHandler((HandlerContainer)server, "/", 1);
            root.addServlet(new ServletHolder(this.servletClass), this.getContextName());
            root.setAttribute(JETTYSERVER_TESTMODE_ATTRIB, (Object)String.valueOf(this.isTestMode()));
            this.context = root;
        }
        return server;
    }

    protected void setBaseDirSystemProperty() {
        if (System.getProperty("basedir") == null) {
            System.setProperty("basedir", System.getProperty("user.dir"));
        }
    }

    private boolean useWebAppContext() {
        return StringUtils.isNotBlank((String)this.relativeWebappRoot);
    }

    protected boolean contextStartupFailed() throws Exception {
        return !this.context.isAvailable();
    }

    public String getRelativeWebappRoot() {
        if (this.relativeWebappRoot == null) {
            return "/sampleapp/web-root";
        }
        return this.relativeWebappRoot;
    }

    public void setRelativeWebappRoot(String relativeWebappRoot) {
        this.relativeWebappRoot = relativeWebappRoot;
    }

    public String getContextName() {
        if (this.contextName == null) {
            return "/SampleRiceClient";
        }
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isFailOnContextFailure() {
        return this.failOnContextFailure;
    }

    public void setFailOnContextFailure(boolean failOnContextFailure) {
        this.failOnContextFailure = failOnContextFailure;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("port", this.port).append("contextName", (Object)this.contextName).append("relativeWebappRoot", (Object)this.relativeWebappRoot).append("servletClass", (Object)this.servletClass).toString();
    }

    public static void main(String[] args) {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        String contextName = args.length > 1 ? args[1] : null;
        String relativeWebappRoot = args.length > 2 ? args[2] : null;
        try {
            new JettyServer(port, contextName, relativeWebappRoot).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

