/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure;

import java.net.BindException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.test.infrastructure.JettyServer;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.api.util.RiceUtilities;

public class JettyServerLifecycle
implements Lifecycle {
    private static final Log LOG = LogFactory.getLog(JettyServerLifecycle.class);
    private static final HashMap<Integer, Config> WEBAPP_CONFIGS = new HashMap();
    private boolean testMode = true;
    private boolean started;
    private ConfigMode configMode = ConfigMode.OVERRIDE;
    private boolean addWebappResourceLoaders = true;
    protected JettyServer jettyServer;

    public static Config getWebappConfig(int port) {
        return WEBAPP_CONFIGS.get(port);
    }

    public JettyServerLifecycle() {
        this(8080, null);
    }

    public JettyServerLifecycle(int port) {
        this(port, null, null);
    }

    public JettyServerLifecycle(int port, String contextName) {
        this(port, contextName, null);
    }

    public JettyServerLifecycle(int port, String contextName, String relativeWebappRoot) {
        this.jettyServer = new JettyServer(port, contextName, relativeWebappRoot);
        this.jettyServer.setFailOnContextFailure(true);
        this.jettyServer.setTestMode(this.testMode);
    }

    public void setTestMode(boolean t) {
        this.testMode = t;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public ConfigMode getConfigMode() {
        return this.configMode;
    }

    public void setConfigMode(ConfigMode configMode) {
        this.configMode = configMode;
    }

    public boolean isAddWebappResourceLoaders() {
        return this.addWebappResourceLoaders;
    }

    public void setAddWebappResourceLoaders(boolean addWebappResourceLoaders) {
        this.addWebappResourceLoaders = addWebappResourceLoaders;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws Exception {
        try {
            this.jettyServer.start();
        }
        catch (RuntimeException re) {
            if (RiceUtilities.findExceptionInStack((Throwable)re, BindException.class) != null) {
                LOG.error((Object)("JettyServerLifecycle encountered BindException on port: " + this.jettyServer.getPort() + "; check logs for test failures or and the config for duplicate port specifications."));
            }
            throw re;
        }
        ClassLoader webappClassLoader = this.jettyServer.getContext().getClassLoader();
        if (this.addWebappResourceLoaders) {
            ResourceLoader rl = GlobalResourceLoader.getResourceLoader((ClassLoader)webappClassLoader);
            if (rl == null) {
                throw new RuntimeException("Could not find resource loader for workflow test harness web app for: " + webappClassLoader);
            }
            GlobalResourceLoader.addResourceLoader((ResourceLoader)rl);
        }
        Config webappConfig = ConfigContext.getConfig((ClassLoader)webappClassLoader);
        WEBAPP_CONFIGS.put(this.jettyServer.getPort(), webappConfig);
        if (ConfigMode.OVERRIDE == this.configMode) {
            ConfigContext.overrideConfig((ClassLoader)Thread.currentThread().getContextClassLoader(), (Config)webappConfig);
        } else if (ConfigMode.MERGE == this.configMode) {
            Config curCtxConfig = ConfigContext.getCurrentContextConfig();
            if (webappConfig != null) {
                curCtxConfig.putProperties(webappConfig.getProperties());
                curCtxConfig.putObjects(webappConfig.getObjects());
            }
        }
        this.started = true;
    }

    public void stop() throws Exception {
        LOG.info((Object)("Shutting down jetty: " + this.jettyServer));
        try {
            if (this.jettyServer != null && this.jettyServer.isStarted()) {
                this.jettyServer.stop();
                WEBAPP_CONFIGS.remove(this.jettyServer.getPort());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error shutting down Jetty " + this.jettyServer.getContextName() + " " + this.jettyServer.getRelativeWebappRoot()), (Throwable)e);
        }
        this.started = false;
    }

    public static enum ConfigMode {
        NONE,
        OVERRIDE,
        MERGE;

    }
}

