/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure;

import com.google.common.base.Function;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.kuali.rice.krad.bo.BusinessObject;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KcSeleniumHelper {
    protected static final String DEFAULT_USER = "quickstart";
    private static final String RESEARCHER_TAB_TITLE = "Researcher";
    private static final String UNIT_TAB_TITLE = "Unit";
    private static final String CENTRAL_ADMIN_TAB_TITLE = "Central Admin";
    private static final String MAINTENANCE_TAB_TITLE = "Maintenance";
    private static final String SYSTEM_ADMIN_TAB_TITLE = "System Admin";
    private static final String HELP_PAGE_TITLE = "KC";
    private static final String CREATE_MAINTENANCE_DOCUMENT_LINK = "maintenance.do?businessObjectClassName=%s&methodToCall=start";
    private static final String METHOD_TO_CALL_PREFIX = "methodToCall.";
    private static final String SHOW_ALL_TABS_BUTTON = "methodToCall.showAllTabs";
    private static final String HIDE_ALL_TABS_BUTTON = "methodToCall.hideAllTabs";
    private static final String TOGGLE_TAB_BUTTON = "methodToCall.toggleTab";
    private static final String YES_BUTTON = "methodToCall.processAnswer.button0";
    private static final String NO_BUTTON = "methodToCall.processAnswer.button1";
    private static final String SAVE_BUTTON = "methodToCall.save";
    private static final String RELOAD_BUTTON = "methodToCall.reload";
    private static final String CLOSE_BUTTON = "methodToCall.close";
    private static final String ROUTE_BUTTON = "methodToCall.route";
    private static final String APPROVE_BUTTON = "methodToCall.approve";
    private static final String BLANKET_APPROVE_BUTTON = "methodToCall.blanketApprove";
    private static final String ERRORS_FOUND_ON_PAGE = "error(s) found on page";
    private static final String SAVE_SUCCESS_MESSAGE = "Document was successfully saved";
    private static final String RELOAD_SUCCESS_MESSAGE = "Document was successfully reloaded";
    private static final String ROUTE_SUCCESS_MESSAGE = "Document was successfully submitted";
    private static final String SUBMIT_SUCCESS_MESSAGE = "Document was successfully approved";
    private static final Logger logger = LoggerFactory.getLogger(KcSeleniumHelper.class);
    private WebDriver driver;

    protected KcSeleniumHelper(WebDriver driver) {
        this.driver = driver;
    }

    public final void login() {
        if (StringUtils.equals((String)this.driver.getTitle(), (String)"Login")) {
            logger.debug("Logging in as {}", (Object)DEFAULT_USER);
            this.set("__login_user", DEFAULT_USER);
            this.click("//input[@value='Login']");
            logger.debug("Logged in as {}", (Object)DEFAULT_USER);
        }
    }

    public final void loginBackdoor() {
        this.loginBackdoor(DEFAULT_USER);
    }

    public final void loginBackdoor(String loginUser) {
        logger.debug("Logging in as {}", (Object)loginUser);
        this.clickResearcherTab();
        this.set("backdoorId", loginUser);
        this.click("imageField");
        logger.debug("Logged in as {}", (Object)loginUser);
    }

    public final void clickResearcherTab() {
        this.click(RESEARCHER_TAB_TITLE);
    }

    public final void clickUnitTab() {
        this.click(UNIT_TAB_TITLE);
    }

    public final void clickCentralAdminTab() {
        this.click(CENTRAL_ADMIN_TAB_TITLE);
    }

    public final void clickMaintenanceTab() {
        this.click(MAINTENANCE_TAB_TITLE);
    }

    public final void clickSystemAdminTab() {
        this.click(SYSTEM_ADMIN_TAB_TITLE);
    }

    public final void clickExpandAll() {
        if (this.findElement(SHOW_ALL_TABS_BUTTON, true)) {
            this.click(SHOW_ALL_TABS_BUTTON);
        }
    }

    public final void clickCollapseAll() {
        if (this.findElement(HIDE_ALL_TABS_BUTTON, true)) {
            this.click(HIDE_ALL_TABS_BUTTON);
        }
    }

    public final String get(String locator) {
        return this.get(locator, false);
    }

    public final String get(String locator, boolean exact) {
        String value = "";
        WebElement element = this.getElement(locator, exact);
        String tagName = element.getTagName();
        String elementType = element.getAttribute("type");
        logger.debug("Getting the value of {} from the element which has a tag of {} and a type of {}", (Object[])new String[]{value, tagName, elementType});
        value = StringUtils.equals((String)tagName, (String)"input") && StringUtils.equals((String)elementType, (String)"checkbox") ? this.getCheckbox(element) : (StringUtils.equals((String)tagName, (String)"input") && StringUtils.equals((String)elementType, (String)"radio") ? this.getRadio(element) : (StringUtils.equals((String)tagName, (String)"select") ? this.getSelect(element) : element.getAttribute("value")));
        logger.debug("Got the value of {} from the element which has a tag of {} and a type of {}", (Object[])new String[]{value, tagName, elementType});
        return value;
    }

    private final String getCheckbox(WebElement element) {
        return BooleanUtils.toString((boolean)element.isSelected(), (String)"on", (String)"off");
    }

    private final String getRadio(WebElement element) {
        return BooleanUtils.toString((boolean)element.isSelected(), (String)"on", (String)"off");
    }

    private String getSelect(WebElement element) {
        Select select = new Select(element);
        return select.getFirstSelectedOption().getText();
    }

    public final void set(String locator, String value) {
        this.set(locator, false, value);
    }

    public final void set(String locator, boolean exact, String value) {
        WebElement element = this.getElement(locator, exact);
        String tagName = element.getTagName();
        String elementType = element.getAttribute("type");
        logger.debug("Setting the value to {} of the element which has a tag of {} and a type of {}", (Object[])new String[]{value, tagName, elementType});
        if (StringUtils.equals((String)tagName, (String)"input") && StringUtils.equals((String)elementType, (String)"checkbox")) {
            this.setCheckbox(element, value);
        } else if (StringUtils.equals((String)tagName, (String)"input") && StringUtils.equals((String)elementType, (String)"file")) {
            this.setFile(element, value);
        } else if (StringUtils.equals((String)tagName, (String)"input") && StringUtils.equals((String)elementType, (String)"radio")) {
            this.setRadio(locator, exact, value);
        } else if (StringUtils.equals((String)tagName, (String)"select")) {
            this.setSelect(element, value);
        } else {
            element.clear();
            element.sendKeys(new CharSequence[]{value});
        }
        logger.debug("Set the value to {} of the element which has a tag of {} and a type of {}", (Object[])new String[]{value, tagName, elementType});
    }

    private final void setCheckbox(WebElement element, String value) {
        boolean booleanValue = BooleanUtils.toBoolean((String)value);
        if (booleanValue && !element.isSelected() || !booleanValue && element.isSelected()) {
            element.click();
        }
    }

    private final void setFile(WebElement element, String value) {
        element.sendKeys(new CharSequence[]{value});
    }

    private final void setRadio(final String locator, final boolean exact, final String value) {
        WebElement radio = new ElementExistsWaiter(locator + " with value " + value + " not found").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement inputElement = null;
                for (WebElement radio : KcSeleniumHelper.this.getElementsByName(locator, exact)) {
                    String radioValue = radio.getAttribute("value");
                    if (!StringUtils.equals((String)radioValue, (String)value)) continue;
                    inputElement = radio;
                    break;
                }
                return inputElement;
            }
        });
        radio.click();
    }

    private void setSelect(WebElement element, String value) {
        Select select = new Select(element);
        for (WebElement option : select.getOptions()) {
            String optionText = option.getText();
            if (!StringUtils.contains((String)optionText, (String)value)) continue;
            option.click();
            break;
        }
    }

    public final void click(String locator) {
        this.click(locator, false, null);
    }

    public final void click(String locator, boolean exact) {
        this.click(locator, exact, null);
    }

    public final void click(String locator, boolean exact, String nextPageTitle) {
        logger.debug("Clicking the element at {}", (Object)locator);
        this.getElement(locator, exact).click();
        this.login();
        if (nextPageTitle != null) {
            this.assertPageContains(nextPageTitle);
        }
        logger.debug("Clicked the element at {}", (Object)locator);
    }

    public final void toggle(String locator) {
        this.toggle(locator, false);
    }

    public final void toggle(String locator, boolean exact) {
        if (this.findElement(locator, exact)) {
            this.click(locator, exact);
        }
    }

    public final void clickYesAnswer() {
        if (this.findElement(YES_BUTTON, true)) {
            this.click(YES_BUTTON);
        }
    }

    public final void clickNoAnswer() {
        if (this.findElement(NO_BUTTON, true)) {
            this.click(NO_BUTTON);
        }
    }

    public final void openTab(final String tabTitle) {
        WebElement tab = new ElementExistsWaiter("Tab with title " + tabTitle + " not found on page").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementById(KcSeleniumHelper.this.getTabId(tabTitle));
            }
        });
        this.clickTab(tab, TabCommand.OPEN);
    }

    public final void openTab(final int index) {
        WebElement tab = new ElementExistsWaiter("Tab with index " + index + " not found on page").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement tab = null;
                List tabs = KcSeleniumHelper.this.getElementsByName(KcSeleniumHelper.TOGGLE_TAB_BUTTON, false);
                if (0 <= index && index < tabs.size()) {
                    tab = (WebElement)tabs.get(index);
                }
                return tab;
            }
        });
        this.clickTab(tab, TabCommand.OPEN);
    }

    public final void closeTab(final String tabTitle) {
        WebElement tab = new ElementExistsWaiter("Tab with title " + tabTitle + " not found on page").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementById(KcSeleniumHelper.this.getTabId(tabTitle));
            }
        });
        this.clickTab(tab, TabCommand.CLOSE);
    }

    public final void closeTab(final int index) {
        WebElement tab = new ElementExistsWaiter("Tab with index " + index + " not found on page").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement tab = null;
                List tabs = KcSeleniumHelper.this.getElementsByName(KcSeleniumHelper.TOGGLE_TAB_BUTTON, false);
                if (0 <= index && index < tabs.size()) {
                    tab = (WebElement)tabs.get(index);
                }
                return tab;
            }
        });
        this.clickTab(tab, TabCommand.CLOSE);
    }

    private String getTabId(String tabTitle) {
        return "tab-" + StringUtils.deleteWhitespace((String)tabTitle) + "-imageToggle";
    }

    private void clickTab(WebElement tab, TabCommand command) {
        logger.debug("Clicking tab {} with requested command {}", (Object)tab.toString(), (Object)command.name());
        String tabCommand = StringUtils.substringBefore((String)tab.getAttribute("title"), (String)" ");
        if (command.contains(tabCommand)) {
            tab.click();
            logger.debug("Clicked the tab {} with actual command {}", (Object)tab.toString(), (Object)tabCommand);
        }
    }

    public String getDocumentNumber() {
        String locator = "//div[@id='headerarea']/div/table/tbody/tr[1]/td[1]";
        return this.getDocumentNumber("//div[@id='headerarea']/div/table/tbody/tr[1]/td[1]");
    }

    protected final String getDocumentNumber(final String locator) {
        WebElement documentNumber = new ElementExistsWaiter(locator + " not found").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementByXPath(locator);
            }
        });
        return documentNumber.getText();
    }

    public final void docSearch(String documentNumber) {
        logger.debug("Searching for and opening document number {}", (Object)documentNumber);
        this.click("Document Search");
        this.set("documentId", documentNumber);
        this.click("methodToCall.search");
        this.click(documentNumber, true);
        logger.debug("Found and opening document number {}", (Object)documentNumber);
    }

    public final void lookup(String tag) {
        this.lookup(tag, null, null);
    }

    public final void lookup(String tag, String searchFieldId, String searchFieldValue) {
        logger.debug("Looking up single result for tag {} for search field {} with search value {}", (Object[])new String[]{tag, searchFieldId, searchFieldValue});
        this.clickLookup(tag);
        if (searchFieldId != null) {
            Assert.assertNotNull((String)"searchValue is null", (Object)searchFieldValue);
            this.set(searchFieldId, searchFieldValue);
        }
        this.click("methodToCall.search");
        this.assertTableCellValueContains("row", 0, 0, "return value");
        this.click("return value", true);
        this.waitForFormLoad();
        logger.debug("Looked up single result for tag {} for search field {} with search value {}", (Object[])new String[]{tag, searchFieldId, searchFieldValue});
    }

    public final void multiLookup(String tag) {
        this.multiLookup(tag, null, null);
    }

    public final void multiLookup(String tag, String searchFieldId, String searchFieldValue) {
        logger.debug("Looking up multiple results for tag {} for search field {} with search value {}", (Object[])new String[]{tag, searchFieldId, searchFieldValue});
        this.clickLookup(tag);
        if (searchFieldId != null) {
            Assert.assertNotNull((String)"searchValue is null", (Object)searchFieldValue);
            this.set(searchFieldId, searchFieldValue);
        }
        this.click("methodToCall.search");
        this.click("methodToCall.selectAll");
        this.click("methodToCall.prepareToReturnSelectedResults");
        logger.debug("Looked up multiple result for tag {} for search field {} with search value {}", (Object[])new String[]{tag, searchFieldId, searchFieldValue});
    }

    private void clickLookup(String tag) {
        final String locator = "//input[starts-with(@name,'methodToCall.performLookup') and contains(@name,'" + tag + "')]";
        WebElement lookup = new ElementExistsWaiter(locator + " not found").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementByXPath(locator);
            }
        });
        lookup.click();
        this.login();
    }

    public final void createNewMaintenanceDocument(String className, String nextPageTitle) {
        final String locator = "//a[@href = '" + String.format(CREATE_MAINTENANCE_DOCUMENT_LINK, className) + "']";
        WebElement createNewButton = new ElementExistsWaiter(locator + " not found").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementByXPath(locator);
            }
        });
        createNewButton.click();
        if (nextPageTitle != null) {
            this.assertTitleContains(nextPageTitle);
        }
    }

    public final void editExistingMaintenanceDocument(String className, Map<String, String> searchValues, String nextPageTitle) {
        for (Map.Entry<String, String> searchValue : searchValues.entrySet()) {
            this.set(searchValue.getKey(), searchValue.getValue());
        }
        this.click("methodToCall.search");
        this.click("edit");
        if (nextPageTitle != null) {
            this.assertTitleContains(nextPageTitle);
        }
    }

    public final void copyExistingMaintenanceDocument(String className, Map<String, String> searchValues, String nextPageTitle) {
        for (Map.Entry<String, String> searchValue : searchValues.entrySet()) {
            this.set(searchValue.getKey(), searchValue.getValue());
        }
        this.click("methodToCall.search");
        this.click("copy");
        if (nextPageTitle != null) {
            this.assertTitleContains(nextPageTitle);
        }
    }

    public final void reloadDocument() {
        this.waitForFormLoad();
        this.click(RELOAD_BUTTON);
    }

    public final void saveDocument() {
        this.waitForFormLoad();
        this.click(SAVE_BUTTON);
    }

    public final void closeDocument() {
        this.waitForFormLoad();
        this.closeDocument(false);
    }

    public final void closeDocument(boolean save) {
        if (save) {
            this.saveDocument();
        }
        this.click(CLOSE_BUTTON);
        this.clickNoAnswer();
    }

    public final void closeAndSearchDocument() {
        String documentNumber = this.getDocumentNumber();
        this.closeDocument(true);
        this.docSearch(documentNumber);
    }

    public final void routeDocument() {
        this.waitForFormLoad();
        this.click(ROUTE_BUTTON);
    }

    public final void approveDocument() {
        this.waitForFormLoad();
        this.click(APPROVE_BUTTON);
    }

    public final void blanketApproveDocument() {
        this.waitForFormLoad();
        this.click(BLANKET_APPROVE_BUTTON);
    }

    public final void assertReload() {
        this.assertPageContains(RELOAD_SUCCESS_MESSAGE);
    }

    public final void assertSave() {
        this.assertPageDoesNotContain(ERRORS_FOUND_ON_PAGE);
        this.assertPageContains(SAVE_SUCCESS_MESSAGE);
    }

    public final void assertRoute() {
        this.assertPageContains(ROUTE_SUCCESS_MESSAGE);
    }

    public final void assertApprove() {
        this.assertPageContains(SUBMIT_SUCCESS_MESSAGE);
    }

    public final void assertElementExists(String locator) {
        this.assertElementExists(locator, false);
    }

    public final void assertElementExists(String locator, boolean exact) {
        this.clickExpandAll();
        Assert.assertTrue((String)("Element " + locator + " does not exist"), (boolean)this.findElement(locator, exact));
    }

    public final void assertElementDoesNotExist(String locator) {
        this.assertElementDoesNotExist(locator, false);
    }

    public final void assertElementDoesNotExist(String locator, boolean exact) {
        this.clickExpandAll();
        Assert.assertFalse((String)("Element " + locator + " exists"), (boolean)this.findElement(locator, exact));
    }

    public final void assertElementContains(String locator, String value) {
        this.assertElementContains(locator, false, value);
    }

    public final void assertElementContains(String locator, boolean exact, String value) {
        this.clickExpandAll();
        Assert.assertTrue((String)("Element " + locator + " does not contain " + value), (boolean)StringUtils.contains((String)this.get(locator, exact), (String)value));
    }

    public final void assertElementDoesNotContain(String locator, String value) {
        this.assertElementDoesNotContain(locator, false, value);
    }

    public final void assertElementDoesNotContain(String locator, boolean exact, String value) {
        this.clickExpandAll();
        Assert.assertFalse((String)("Element " + locator + " contains " + value), (boolean)StringUtils.contains((String)this.get(locator, exact), (String)value));
    }

    public final void assertSelectorContains(final String cssSelector, final String value) {
        new ElementExistsWaiter("CSS selector " + cssSelector + " does not contain " + value).until(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                boolean selectorContains = false;
                for (WebElement element : KcSeleniumHelper.this.getElementsByCssSelector(cssSelector)) {
                    logger.debug("Searching CSS selector {} with text {} for whether it contains value {}", (Object[])new String[]{cssSelector, element.getText(), value});
                    if (!StringUtils.contains((String)element.getText(), (String)value)) continue;
                    selectorContains = true;
                    break;
                }
                logger.debug(selectorContains ? "Found CSS selector {} contains value {}" : "Found CSS selector {} does not contain value {}", (Object[])new String[]{cssSelector, value});
                return selectorContains;
            }
        });
    }

    public final void assertSelectorDoesNotContain(final String cssSelector, final String value) {
        new ElementDoesNotExistWaiter("CSS selector " + cssSelector + " contains " + value).until(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                boolean selectorContains = false;
                for (WebElement element : KcSeleniumHelper.this.getElementsByCssSelector(cssSelector)) {
                    logger.debug("Searching CSS selector {} with text {} for whether it contains value {}", (Object[])new String[]{cssSelector, element.getText(), value});
                    if (!StringUtils.contains((String)element.getText(), (String)value)) continue;
                    selectorContains = true;
                    break;
                }
                logger.debug(selectorContains ? "Found CSS selector {} contains value {}" : "Found CSS selector {} does not contain value {}", (Object[])new String[]{cssSelector, value});
                return selectorContains;
            }
        });
    }

    public final void assertPageContains(final String text) {
        this.clickExpandAll();
        new ElementExistsWaiter("Page does not contain " + text).until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementByText(text);
            }
        });
    }

    public final void assertPageDoesNotContain(final String text) {
        this.clickExpandAll();
        new ElementDoesNotExistWaiter("Page contains " + text).until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementByText(text);
            }
        });
    }

    public final void assertTitleContains(String title) {
        String pageSource = this.driver.getPageSource();
        if (!StringUtils.contains((String)pageSource, (String)title) && this.switchToIFramePortlet()) {
            pageSource = this.driver.getPageSource();
        }
        Assert.assertTrue((String)("Page does not contain " + title), (boolean)StringUtils.contains((String)pageSource, (String)title));
    }

    public final void assertTitleDoesNotContain(String title) {
        String pageSource = this.driver.getPageSource();
        if (StringUtils.contains((String)pageSource, (String)title) && this.switchToIFramePortlet()) {
            pageSource = this.driver.getPageSource();
        }
        Assert.assertFalse((String)("Page contains" + title), (boolean)StringUtils.contains((String)pageSource, (String)title));
    }

    public final void assertOptionsContain(String locator, String text) {
        this.assertOptionsContain(locator, false, text);
    }

    public final void assertOptionsContain(String locator, boolean exact, String text) {
        logger.debug("Finding option values for select element {}", (Object)locator);
        Select select = new Select(this.getElement(locator, exact));
        ArrayList<String> values = new ArrayList<String>();
        for (WebElement option : select.getOptions()) {
            values.add(option.getText());
        }
        logger.debug("Found option values for select element {} are {}", (Object)locator, (Object)((Object)values).toString());
        Assert.assertTrue((String)("Options for " + locator + " do not contain " + text), (boolean)values.contains(text));
    }

    public final void assertOptionsDoNotContain(String locator, String text) {
        this.assertOptionsDoNotContain(locator, false, text);
    }

    public final void assertOptionsDoNotContain(String locator, boolean exact, String text) {
        logger.debug("Finding option values for select element {}", (Object)locator);
        Select select = new Select(this.getElement(locator, exact));
        ArrayList<String> values = new ArrayList<String>();
        for (WebElement option : select.getOptions()) {
            values.add(option.getText());
        }
        logger.debug("Found option values for select element {} are {}", (Object)locator, (Object)((Object)values).toString());
        Assert.assertFalse((String)("Options for " + locator + " contains " + text), (boolean)values.contains(text));
    }

    public final void assertSelectedOptionsContain(String locator, String text) {
        this.assertSelectedOptionsContain(locator, false, text);
    }

    public final void assertSelectedOptionsContain(String locator, boolean exact, String text) {
        logger.debug("Finding selected option values for select element {}", (Object)locator);
        Select select = new Select(this.getElement(locator, exact));
        ArrayList<String> selectedValues = new ArrayList<String>();
        for (WebElement option : select.getAllSelectedOptions()) {
            selectedValues.add(option.getText());
        }
        logger.debug("Found selected option values for select element {} are {}", (Object)locator, (Object)((Object)selectedValues).toString());
        Assert.assertTrue((String)("Selected options for " + locator + " do not contain " + text), (boolean)selectedValues.contains(text));
    }

    public final void assertSelectedOptionsDoNotContain(String locator, String text) {
        this.assertSelectedOptionsDoNotContain(locator, false, text);
    }

    public final void assertSelectedOptionsDoNotContain(String locator, boolean exact, String text) {
        logger.debug("Finding selected option values for select element {}", (Object)locator);
        Select select = new Select(this.getElement(locator, exact));
        ArrayList<String> selectedValues = new ArrayList<String>();
        for (WebElement option : select.getAllSelectedOptions()) {
            selectedValues.add(option.getText());
        }
        logger.debug("Found selected option values for select element {} are {}", (Object)locator, (Object)((Object)selectedValues).toString());
        Assert.assertFalse((String)("Selected options for " + locator + " contains " + text), (boolean)selectedValues.contains(text));
    }

    public final void assertPopupWindowContains(String popupWindowId, String expectedText) {
        String parentWindowHandle = this.driver.getWindowHandle();
        logger.debug("Switching to popup window {} out of parent window with handle {}", (Object)popupWindowId, (Object)parentWindowHandle);
        this.click(popupWindowId);
        this.switchToPopupWindow(parentWindowHandle);
        logger.debug("Switched to popup window {} out of parent window with handle {}", (Object)popupWindowId, (Object)parentWindowHandle);
        this.assertPageContains(expectedText);
        this.driver.close();
        this.driver.switchTo().window(parentWindowHandle);
        logger.debug("Switched to parent window with handle {} from popup window {}", (Object)parentWindowHandle, (Object)popupWindowId);
    }

    public final void assertExpandedTextArea(String textAreaId, String originalText, String expandedAreaText) {
        this.set(textAreaId, originalText);
        String parentWindowHandle = this.driver.getWindowHandle();
        final String textAreaButtonLocator = "//input[starts-with(@name,'methodToCall.updateTextArea') and contains(@name, '" + textAreaId + "')]";
        WebElement textAreaButton = new ElementExistsWaiter("Expand button for " + textAreaId + " not found").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementByXPath(textAreaButtonLocator);
            }
        });
        textAreaButton.click();
        this.switchToPopupWindow(parentWindowHandle);
        Assert.assertEquals((Object)originalText, (Object)this.get(textAreaId));
        this.set(textAreaId, expandedAreaText);
        String continueButtonLocator = "methodToCall.postTextAreaToParent";
        WebElement continueButton = new ElementExistsWaiter("Continue button for " + textAreaId + " not found").until(new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                WebElement element = null;
                List elements = KcSeleniumHelper.this.getActiveElementsByName("methodToCall.postTextAreaToParent", false);
                if (!elements.isEmpty()) {
                    element = (WebElement)elements.get(0);
                }
                return element;
            }
        });
        continueButton.click();
        this.driver.switchTo().window(parentWindowHandle);
        Assert.assertEquals((Object)expandedAreaText, (Object)this.get(textAreaId));
    }

    public final void assertHelpLink(Class<? extends BusinessObject> businessObjectClass) {
        String parentWindowHandle = this.driver.getWindowHandle();
        String locator = "methodToCall=getBusinessObjectHelpText&businessObjectClassName=" + businessObjectClass.getName();
        WebElement helpLink = this.getElementByXPath("//node()[@target='helpWindow' and contains(@href, '" + locator + "')]");
        helpLink.click();
        this.switchToPopupWindow(parentWindowHandle);
        this.assertTitleContains(HELP_PAGE_TITLE);
        this.driver.close();
        this.driver.switchTo().window(parentWindowHandle);
    }

    public void acceptAlert() {
        try {
            Alert alert = this.driver.switchTo().alert();
            alert.accept();
        }
        catch (NoAlertPresentException nape) {
            logger.debug("Did not locate alert, ignoring...");
        }
    }

    public void dismissAlert() {
        try {
            Alert alert = this.driver.switchTo().alert();
            alert.dismiss();
        }
        catch (NoAlertPresentException nape) {
            logger.debug("Did not locate alert, ignoring...");
        }
    }

    public final int getTableRowCount(String id) {
        final String locator = "//table[@id='" + id + "']/tbody/tr";
        return new ElementExistsWaiter("Table with id " + id + " not found").until(new Function<WebDriver, Integer>(){

            public Integer apply(WebDriver driver) {
                List rows = KcSeleniumHelper.this.getElementsByXPath(locator);
                return rows.size();
            }
        });
    }

    public final int getTableColumnCount(String id, int row) {
        String rowString = String.valueOf(row + 1);
        final String locator = "//table[@id='" + id + "']/tbody/tr[" + rowString + "]/td";
        return new ElementExistsWaiter("Table with id " + id + " not found").until(new Function<WebDriver, Integer>(){

            public Integer apply(WebDriver driver) {
                List columns = KcSeleniumHelper.this.getElementsByXPath(locator);
                return columns.size();
            }
        });
    }

    public final void assertTableRowCount(String id, int expectedRowCount) {
        int actualRowCount = this.getTableRowCount(id);
        Assert.assertEquals((String)("Actual row count of " + actualRowCount + " did not match the expected row count of " + expectedRowCount), (long)expectedRowCount, (long)actualRowCount);
    }

    public final String getTableCellValue(String id, int row, int column) {
        String rowString = String.valueOf(row + 1);
        String columnString = String.valueOf(column + 1);
        final String locator = "//table[@id='" + id + "']/tbody/tr[" + rowString + "]/td[" + columnString + "]";
        return new ElementExistsWaiter("Cell value for table with id " + id + " at row " + rowString + " and column " + columnString + " not found").until(new Function<WebDriver, String>(){

            public String apply(WebDriver driver) {
                WebElement cell = KcSeleniumHelper.this.getElementByXPath(locator);
                return cell == null ? "" : KcSeleniumHelper.this.normalize(cell.getText());
            }
        });
    }

    public final void assertTableCellValueContains(String id, int row, int column, String expectedText) {
        String actualText = this.getTableCellValue(id, row, column);
        Assert.assertTrue((String)("Actual cell text of " + actualText + " did not contain the expected cell text of " + expectedText), (boolean)StringUtils.contains((String)actualText, (String)expectedText));
    }

    public final void assertTableCellValueContains(String id, String expectedText) {
        boolean tableContains = false;
        for (int row = 0; row < this.getTableRowCount(id); ++row) {
            boolean tableRowContains = this.getTableRowContains(id, row, expectedText);
            if (!tableRowContains) continue;
            tableContains = true;
            break;
        }
        Assert.assertTrue((String)("Cell text of " + expectedText + " not found"), (boolean)tableContains);
    }

    public final void assertTableCellValueDoesNotContain(String id, int row, int column, String expectedText) {
        String actualText = this.getTableCellValue(id, row, column);
        Assert.assertFalse((String)("Actual cell text of " + actualText + " contains the expected cell text of " + expectedText), (boolean)StringUtils.contains((String)actualText, (String)expectedText));
    }

    public final void assertTableCellValueDoesNotContain(String id, String expectedText) {
        boolean tableContains = false;
        for (int row = 0; row < this.getTableRowCount(id); ++row) {
            boolean tableRowContains = this.getTableRowContains(id, row, expectedText);
            if (!tableRowContains) continue;
            tableContains = true;
            break;
        }
        Assert.assertFalse((String)("Cell text of " + expectedText + " found"), (boolean)tableContains);
    }

    private final boolean getTableRowContains(String id, int row, String expectedText) {
        boolean tableRowContains = false;
        for (int column = 0; column < this.getTableColumnCount(id, row); ++column) {
            logger.debug("Getting cell value from table {} at row {} and column {}", new Object[]{id, row, column});
            String actualText = this.getTableCellValue(id, row, column);
            logger.debug("Found cell value from table {} at row {} and column {} to be {}", new Object[]{id, row, column, actualText});
            if (!StringUtils.contains((String)actualText, (String)expectedText)) continue;
            tableRowContains = true;
            break;
        }
        logger.debug(tableRowContains ? "Found table {} at row {} contains text {}" : "Found table {} at row {} does not contain text {}", new Object[]{id, row, expectedText});
        return tableRowContains;
    }

    public final void assertPageErrors() {
        this.clickExpandAll();
        new ElementExistsWaiter("Page does not contain errors").until(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementByText(KcSeleniumHelper.ERRORS_FOUND_ON_PAGE) != null || KcSeleniumHelper.this.getElementByText("Errors Found in Document") != null || KcSeleniumHelper.this.getElementByText("Kuali :: Incident Report") != null;
            }
        });
    }

    public final void assertNoPageErrors() {
        this.clickExpandAll();
        new ElementDoesNotExistWaiter("Page contains errors").until(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementByText(KcSeleniumHelper.ERRORS_FOUND_ON_PAGE) != null || KcSeleniumHelper.this.getElementByText("Errors Found in Document") != null || KcSeleniumHelper.this.getElementByText("Kuali :: Incident Report") != null;
            }
        });
    }

    public final void assertError(String panelId, String expectedText) {
        this.clickExpandAll();
        boolean errorsContain = false;
        for (WebElement error : this.getErrors(panelId)) {
            if (!StringUtils.contains((String)error.getText(), (String)expectedText)) continue;
            errorsContain = true;
            break;
        }
        Assert.assertTrue((String)("Errors in " + panelId + " do not contain " + expectedText), (boolean)errorsContain);
    }

    public final void assertErrorCount(String panelId, int expectedErrorCount) {
        this.clickExpandAll();
        List<WebElement> errors = this.getErrors(panelId);
        Assert.assertEquals((String)("Error count of " + errors.size() + " did not match the expected error count of " + expectedErrorCount), (long)expectedErrorCount, (long)errors.size());
    }

    public final void assertWarning(String panelId, String expectedText) {
        this.clickExpandAll();
        boolean warningsContain = false;
        for (WebElement error : this.getWarnings(panelId)) {
            if (!StringUtils.contains((String)error.getText(), (String)expectedText)) continue;
            warningsContain = true;
            break;
        }
        Assert.assertTrue((String)("Warnings in " + panelId + " do not contain " + expectedText), (boolean)warningsContain);
    }

    public final void assertWarningCount(String panelId, int expectedWarningCount) {
        this.clickExpandAll();
        List<WebElement> warnings = this.getWarnings(panelId);
        Assert.assertEquals((String)("Warning count of " + warnings.size() + " did not match the expected warning count of " + expectedWarningCount), (long)expectedWarningCount, (long)warnings.size());
    }

    public final String getAbsoluteFilePath(Class<?> clazz) {
        URL fileUrl = this.getClass().getResource("/" + clazz.getCanonicalName().replaceAll("\\.", "/") + ".class");
        Assert.assertNotNull((Object)fileUrl);
        return new File(fileUrl.getFile()).getAbsolutePath();
    }

    public final String getSimpleFilePath(Class<?> clazz) {
        String fileName = clazz.getSimpleName() + ".class";
        Assert.assertNotNull((Object)fileName);
        return fileName;
    }

    private void waitForFormLoad() {
        new ElementExistsWaiter("Page did not load").until(new Function<WebDriver, Boolean>(){

            public Boolean apply(WebDriver driver) {
                boolean isFormComplete = false;
                List elements = driver.findElements(By.id((String)"formComplete"));
                if (CollectionUtils.isNotEmpty((Collection)elements)) {
                    isFormComplete = true;
                }
                return isFormComplete;
            }
        });
    }

    private boolean findElement(String locator, boolean exact) {
        return new ElementExistenceFinderWaiter().until(this.locateElementByAll(locator, exact));
    }

    private WebElement getElement(String locator, boolean exact) {
        return new ElementExistsWaiter(locator + " not found").until(this.locateElementByAll(locator, exact));
    }

    private Function<WebDriver, WebElement> locateElementByAll(final String locator, final boolean exact) {
        return new Function<WebDriver, WebElement>(){

            public WebElement apply(WebDriver driver) {
                logger.debug("Locating element {} by id", (Object)locator);
                WebElement element = KcSeleniumHelper.this.getElementById(locator);
                if (element == null) {
                    logger.debug("Locating element {} by name", (Object)locator);
                    element = KcSeleniumHelper.this.getElementByName(locator, exact);
                    if (element == null) {
                        logger.debug("Locating element {} by title", (Object)locator);
                        element = KcSeleniumHelper.this.getElementByTitle(locator, exact);
                        if (element == null) {
                            logger.debug("Locating element {} by link text", (Object)locator);
                            element = KcSeleniumHelper.this.getElementByLinkText(locator, exact);
                        }
                    }
                }
                logger.debug(element != null ? "Found element {}" : "Did not find element {}", (Object)locator);
                return element;
            }
        };
    }

    private WebElement getElementById(String id) {
        WebElement element = null;
        List<WebElement> elements = this.getElementsById(id);
        if (!elements.isEmpty()) {
            element = elements.get(0);
        }
        return element;
    }

    private WebElement getElementByName(String name, boolean exact) {
        WebElement element = null;
        List<WebElement> elements = this.getElementsByName(name, exact);
        if (!elements.isEmpty()) {
            element = elements.get(0);
        }
        return element;
    }

    private WebElement getElementByTitle(String title, boolean exact) {
        WebElement element = null;
        List<WebElement> elements = this.getElementsByTitle(title, exact);
        if (!elements.isEmpty()) {
            element = elements.get(0);
        }
        return element;
    }

    private WebElement getElementByLinkText(String linkText, boolean exact) {
        WebElement element = null;
        List<WebElement> elements = this.getElementsByLinkText(linkText, exact);
        if (!elements.isEmpty()) {
            element = elements.get(0);
        }
        return element;
    }

    private WebElement getElementByXPath(String xPath) {
        WebElement element = null;
        List<WebElement> elements = this.getElementsByXPath(xPath);
        if (!elements.isEmpty()) {
            element = elements.get(0);
        }
        return element;
    }

    private WebElement getElementByCssSelector(String cssSelector) {
        WebElement element = null;
        List<WebElement> elements = this.getElementsByCssSelector(cssSelector);
        if (!elements.isEmpty()) {
            element = elements.get(0);
        }
        return element;
    }

    private WebElement getElementByText(String text) {
        WebElement element = null;
        List<WebElement> elements = this.getElementsByText(text);
        if (!elements.isEmpty()) {
            element = elements.get(0);
        }
        return element;
    }

    private List<WebElement> getElementsById(String id) {
        this.driver.switchTo().defaultContent();
        List<WebElement> elements = this.getActiveElementsById(id);
        if (elements.isEmpty() && this.switchToIFramePortlet()) {
            elements.addAll(this.getActiveElementsById(id));
        }
        return elements;
    }

    private List<WebElement> getActiveElementsById(String id) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebElement element : this.driver.findElements(By.id((String)id))) {
            if (!element.isDisplayed()) continue;
            elements.add(element);
        }
        return elements;
    }

    private List<WebElement> getElementsByName(String name, boolean exact) {
        this.driver.switchTo().defaultContent();
        List<WebElement> elements = this.getActiveElementsByName(name, exact);
        if (elements.isEmpty() && this.switchToIFramePortlet()) {
            elements.addAll(this.getActiveElementsByName(name, exact));
        }
        return elements;
    }

    private List<WebElement> getActiveElementsByName(String name, boolean exact) {
        ArrayList<WebElement> activeElements = new ArrayList<WebElement>();
        ArrayList elements = new ArrayList();
        if (exact) {
            elements.addAll(this.driver.findElements(By.name((String)name)));
        } else {
            elements.addAll(this.driver.findElements(By.xpath((String)this.getAttributeContainsXPath("name", name))));
        }
        for (WebElement element : elements) {
            if (!element.isDisplayed()) continue;
            activeElements.add(element);
        }
        return activeElements;
    }

    private List<WebElement> getElementsByTitle(String title, boolean exact) {
        this.driver.switchTo().defaultContent();
        List<WebElement> elements = this.getActiveElementsByTitle(title, exact);
        if (elements.isEmpty() && this.switchToIFramePortlet()) {
            elements.addAll(this.getActiveElementsByTitle(title, exact));
        }
        return elements;
    }

    private List<WebElement> getActiveElementsByTitle(String title, boolean exact) {
        ArrayList<WebElement> activeElements = new ArrayList<WebElement>();
        ArrayList elements = new ArrayList();
        if (exact) {
            elements.addAll(this.driver.findElements(By.xpath((String)("//*[@title = '" + title + "']"))));
        } else {
            elements.addAll(this.driver.findElements(By.xpath((String)this.getAttributeContainsXPath("title", title))));
        }
        for (WebElement element : elements) {
            if (!element.isDisplayed()) continue;
            activeElements.add(element);
        }
        return activeElements;
    }

    private List<WebElement> getElementsByLinkText(String linkText, boolean exact) {
        this.driver.switchTo().defaultContent();
        List<WebElement> elements = this.getActiveElementsByLinkText(linkText, exact);
        if (elements.isEmpty() && this.switchToIFramePortlet()) {
            elements.addAll(this.getActiveElementsByLinkText(linkText, exact));
        }
        return elements;
    }

    private List<WebElement> getActiveElementsByLinkText(String linkText, boolean exact) {
        ArrayList<WebElement> activeElements = new ArrayList<WebElement>();
        ArrayList elements = new ArrayList();
        if (exact) {
            elements.addAll(this.driver.findElements(By.linkText((String)linkText)));
        } else {
            elements.addAll(this.driver.findElements(By.partialLinkText((String)linkText)));
        }
        for (WebElement element : elements) {
            if (!element.isDisplayed()) continue;
            activeElements.add(element);
        }
        return activeElements;
    }

    private List<WebElement> getElementsByXPath(String xPath) {
        this.driver.switchTo().defaultContent();
        List<WebElement> elements = this.getActiveElementsByXPath(xPath);
        if (elements.isEmpty() && this.switchToIFramePortlet()) {
            elements.addAll(this.getActiveElementsByXPath(xPath));
        }
        return elements;
    }

    private List<WebElement> getActiveElementsByXPath(String xPath) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebElement element : this.driver.findElements(By.xpath((String)xPath))) {
            if (!element.isDisplayed()) continue;
            elements.add(element);
        }
        return elements;
    }

    private List<WebElement> getElementsByCssSelector(String cssSelector) {
        this.driver.switchTo().defaultContent();
        List<WebElement> elements = this.getActiveElementsByCssSelector(cssSelector);
        if (elements.isEmpty() && this.switchToIFramePortlet()) {
            elements.addAll(this.getActiveElementsByCssSelector(cssSelector));
        }
        return elements;
    }

    private List<WebElement> getActiveElementsByCssSelector(String cssSelector) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebElement element : this.driver.findElements(By.cssSelector((String)cssSelector))) {
            if (!element.isDisplayed()) continue;
            elements.add(element);
        }
        return elements;
    }

    private List<WebElement> getElementsByText(String text) {
        this.driver.switchTo().defaultContent();
        List<WebElement> elements = this.getActiveElementsByText(text);
        if (elements.isEmpty() && this.switchToIFramePortlet()) {
            elements.addAll(this.getActiveElementsByText(text));
        }
        return elements;
    }

    private List<WebElement> getActiveElementsByText(String text) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (WebElement element : this.driver.findElements(By.xpath((String)("//*[contains(normalize-space(text()), '" + text + "')]")))) {
            if (!element.isDisplayed()) continue;
            elements.add(element);
        }
        return elements;
    }

    private boolean switchToIFramePortlet() {
        boolean switchToIFramePortletSuccessful = true;
        try {
            this.driver.switchTo().frame("iframeportlet");
        }
        catch (Exception e) {
            switchToIFramePortletSuccessful = false;
        }
        return switchToIFramePortletSuccessful;
    }

    private void switchToPopupWindow(String parentWindowHandle) {
        for (String handle : this.driver.getWindowHandles()) {
            if (StringUtils.equals((String)handle, (String)parentWindowHandle)) continue;
            this.driver.switchTo().window(handle);
            break;
        }
    }

    private String getAttributeContainsXPath(String attribute, String text) {
        return "//*[contains(@" + attribute + ", '" + text + "')]";
    }

    private List<WebElement> getErrors(String panelId) {
        final String locator = "div[id='" + panelId + "'] div[class='tab-container-error'] div div div";
        return new ElementCountFinderWaiter().until(new Function<WebDriver, List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementsByCssSelector(locator);
            }
        });
    }

    private List<WebElement> getWarnings(String panelId) {
        final String locator = "div[id='" + panelId + "'] div[class='tab-container'] div li";
        return new ElementCountFinderWaiter().until(new Function<WebDriver, List<WebElement>>(){

            public List<WebElement> apply(WebDriver driver) {
                return KcSeleniumHelper.this.getElementsByCssSelector(locator);
            }
        });
    }

    private String normalize(String str) {
        return str == null ? "" : str.replaceAll("\\s+", " ");
    }

    private class ElementCountFinderWaiter {
        private final Clock clock = new SystemClock();
        private final long testTimeOut = 1000L;
        private final long sleepTimeOut = 500L;

        private ElementCountFinderWaiter() {
        }

        public List<WebElement> until(Function<WebDriver, List<WebElement>> elements) {
            long end = this.clock.laterBy(1000L);
            while (this.clock.isNowBefore(end)) {
                List values = (List)elements.apply((Object)KcSeleniumHelper.this.driver);
                if (values != null && values.size() > 0) {
                    return values;
                }
                this.sleep();
            }
            return Collections.emptyList();
        }

        private void sleep() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class ElementExistenceFinderWaiter {
        private final Clock clock = new SystemClock();
        private final long testTimeOut = 1000L;
        private final long sleepTimeOut = 500L;

        private ElementExistenceFinderWaiter() {
        }

        public <T> boolean until(Function<WebDriver, T> exists) {
            long end = this.clock.laterBy(1000L);
            while (this.clock.isNowBefore(end)) {
                Object value = exists.apply((Object)KcSeleniumHelper.this.driver);
                if (value != null) {
                    return true;
                }
                this.sleep();
            }
            return false;
        }

        private void sleep() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class ElementDoesNotExistWaiter
    implements Wait<WebDriver> {
        private final Clock clock = new SystemClock();
        private final long testTimeOut = 1000L;
        private final long sleepTimeOut = 500L;
        private String message;

        protected ElementDoesNotExistWaiter(String message) {
            this.message = message;
        }

        public <T> T until(Function<? super WebDriver, T> exists) {
            long end = this.clock.laterBy(1000L);
            while (this.clock.isNowBefore(end)) {
                Object value = exists.apply((Object)KcSeleniumHelper.this.driver);
                if (value != null) {
                    if (Boolean.class.equals(value.getClass())) {
                        if (Boolean.TRUE.equals(value)) {
                            throw new AssertionError((Object)this.message);
                        }
                    } else {
                        throw new AssertionError((Object)this.message);
                    }
                }
                this.sleep();
            }
            return null;
        }

        private void sleep() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class ElementExistsWaiter
    implements Wait<WebDriver> {
        private final Clock clock = new SystemClock();
        private final long testTimeOut = 10000L;
        private final long sleepTimeOut = 500L;
        private String message;

        protected ElementExistsWaiter(String message) {
            this.message = message;
        }

        public <T> T until(Function<? super WebDriver, T> exists) {
            long end = this.clock.laterBy(10000L);
            while (this.clock.isNowBefore(end)) {
                Object value = exists.apply((Object)KcSeleniumHelper.this.driver);
                if (value != null) {
                    if (Boolean.class.equals(value.getClass())) {
                        if (Boolean.TRUE.equals(value)) {
                            return (T)value;
                        }
                    } else {
                        return (T)value;
                    }
                }
                this.sleep();
            }
            throw new AssertionError((Object)this.message);
        }

        private void sleep() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static enum TabCommand {
        OPEN,
        CLOSE;


        public boolean contains(String tabCommand) {
            boolean contains = StringUtils.equalsIgnoreCase((String)tabCommand, (String)this.name());
            for (TabCommand command : TabCommand.values()) {
                if (command == this) continue;
                contains |= !StringUtils.equalsIgnoreCase((String)tabCommand, (String)command.name());
            }
            return contains;
        }
    }
}

