/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure;

import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunListener;
import org.kuali.kra.test.infrastructure.KcSeleniumTestRunner;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.test.infrastructure.KcUnitTestRunListener;
import org.kuali.kra.test.infrastructure.lifecycle.KcUnitTestBaseLifecycle;
import org.kuali.kra.test.infrastructure.lifecycle.KcUnitTestSeleniumLifecycle;
import org.openqa.selenium.WebDriver;

@RunWith(value=KcSeleniumTestRunner.class)
public class KcSeleniumTestBase
extends KcUnitTestBase {
    protected static WebDriver driver;
    private static KcUnitTestSeleniumLifecycle LIFECYCLE;
    private static RunListener RUN_LISTENER;
    private String defaultHandle = "";

    @BeforeClass
    public static final void seleniumBeforeClass() {
        if (!LIFECYCLE.isPerSuiteStarted()) {
            LIFECYCLE.startPerSuite();
            driver = LIFECYCLE.getWebDriver();
        }
        LIFECYCLE.startPerClass();
    }

    @AfterClass
    public static final void seleniumAfterClass() {
        LIFECYCLE.stopPerClass();
    }

    @Before
    public void seleniumBeforeTest() {
        LIFECYCLE.startPerTest(this.transactional);
    }

    @After
    public void seleniumAfterTest() {
        LIFECYCLE.stopPerTest();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        driver.get("http://127.0.0.1:" + KcUnitTestBaseLifecycle.getPort() + "/" + "kc-dev");
        this.defaultHandle = driver.getWindowHandle();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        driver.switchTo().window(this.defaultHandle);
        for (String handle : driver.getWindowHandles()) {
            if (StringUtils.equals((String)handle, (String)this.defaultHandle)) continue;
            driver.switchTo().window(handle);
            driver.close();
            driver.switchTo().window(this.defaultHandle);
        }
        driver.get("http://127.0.0.1:" + KcUnitTestBaseLifecycle.getPort() + "/" + "kc-dev");
        super.tearDown();
    }

    public static RunListener getRunListener() {
        return RUN_LISTENER;
    }

    static {
        LIFECYCLE = new KcUnitTestSeleniumLifecycle();
        RUN_LISTENER = new KcUnitTestRunListener(LIFECYCLE);
    }
}

