/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunListener;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestMethodAware;
import org.kuali.kra.test.infrastructure.KcUnitTestRunListener;
import org.kuali.kra.test.infrastructure.KcUnitTestRunner;
import org.kuali.kra.test.infrastructure.lifecycle.KcUnitTestMainLifecycle;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

@RunWith(value=KcUnitTestRunner.class)
public class KcUnitTestBase
extends Assert
implements KcUnitTestMethodAware {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    private static KcUnitTestMainLifecycle LIFECYCLE = new KcUnitTestMainLifecycle();
    private static RunListener RUN_LISTENER = new KcUnitTestRunListener(LIFECYCLE);
    private static final String DEFAULT_USER = "quickstart";
    private long startTime;
    private long totalMem;
    private long freeMem;
    private final String memStatFormat = "[%1$-7s] total: %2$10d, free: %3$10d";
    private Method method;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    protected boolean transactional = true;

    @Before
    public final void baseBeforeTest() {
        this.logBeforeRun();
        LIFECYCLE.startPerTest(this.transactional);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        GlobalVariables.setUserSession((UserSession)new UserSession(DEFAULT_USER));
    }

    @After
    public final void baseAfterTest() {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        GlobalVariables.setUserSession(null);
        LIFECYCLE.stopPerTest();
        this.logAfterRun();
    }

    @BeforeClass
    public static final void baseBeforeClass() {
        if (!LIFECYCLE.isPerSuiteStarted()) {
            LIFECYCLE.startPerSuite();
        }
        LIFECYCLE.startPerClass();
    }

    @AfterClass
    public static final void baseAfterClass() {
        LIFECYCLE.stopPerClass();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Override
    public void setTestMethod(Method method) {
        this.method = method;
    }

    public static RunListener getRunListener() {
        return RUN_LISTENER;
    }

    protected void logBeforeRun() {
        if (this.LOG.isInfoEnabled()) {
            this.statsBegin();
            this.LOG.info((Object)"##############################################################");
            this.LOG.info((Object)("# Starting test " + this.getFullTestName() + "..."));
            this.LOG.info((Object)"##############################################################");
        }
    }

    protected void logAfterRun() {
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)"##############################################################");
            this.LOG.info((Object)("# ...finished test " + this.getFullTestName()));
            for (String stat : this.statsEnd()) {
                this.LOG.info((Object)("# " + stat));
            }
            this.LOG.info((Object)"##############################################################");
        }
    }

    private void statsBegin() {
        this.startTime = System.currentTimeMillis();
        this.totalMem = Runtime.getRuntime().totalMemory();
        this.freeMem = Runtime.getRuntime().freeMemory();
    }

    protected String[] statsEnd() {
        long currentTime = System.currentTimeMillis();
        long currentTotalMem = Runtime.getRuntime().totalMemory();
        long currentFreeMem = Runtime.getRuntime().freeMemory();
        return new String[]{String.format("[%1$-7s] total: %2$10d, free: %3$10d", "MemPre", this.totalMem, this.freeMem), String.format("[%1$-7s] total: %2$10d, free: %3$10d", "MemPost", currentTotalMem, currentFreeMem), String.format("[%1$-7s] total: %2$10d, free: %3$10d", "MemDiff", this.totalMem - currentTotalMem, this.freeMem - currentFreeMem), String.format("[ElapsedTime] %1$d ms", currentTime - this.startTime)};
    }

    protected String getFullTestName() {
        return this.getClass().getSimpleName() + "." + this.method.getName();
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    protected void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return this.documentService;
    }

    protected void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    protected void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected Document getDocument(String documentNumber) throws Exception {
        if (!OrmUtils.isJpaEnabled()) {
            KRADServiceLocatorWeb.getPersistenceServiceOjb().clearCache();
        }
        Document doc = this.getDocumentService().getByDocumentHeaderId(documentNumber);
        return doc;
    }

    protected final <T> T getService(Class<T> serviceClass) {
        return (T)KraServiceLocator.getService(serviceClass);
    }

    protected String getFilePath(Class<?> clazz) {
        URL fileUrl = this.getClass().getResource("/" + clazz.getCanonicalName().replaceAll("\\.", "/") + ".class");
        KcUnitTestBase.assertNotNull((Object)fileUrl);
        return fileUrl.getPath();
    }

    protected void updateParameterForTesting(Class componentClass, String parameterName, String newValue) {
        Parameter parameter = this.getParameterService().getParameter(componentClass, parameterName);
        Parameter.Builder parameterForUpdate = Parameter.Builder.create((ParameterContract)parameter);
        parameterForUpdate.setValue(newValue);
        this.getParameterService().updateParameter(parameterForUpdate.build());
    }
}

