/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.kuali.kra.test.infrastructure.lifecycle.KcUnitTestLifecycle;

public class KcUnitTestRunListener
extends RunListener {
    protected final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    KcUnitTestLifecycle lifecycle;
    List<Failure> assumptionFailures = new ArrayList<Failure>();
    List<Failure> failures = new ArrayList<Failure>();
    List<Description> ignoredTests = new ArrayList<Description>();

    public KcUnitTestRunListener(KcUnitTestLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void testRunFinished(Result result) throws Exception {
        this.lifecycle.stopPerSuite();
        this.outputReport();
    }

    public void testAssumptionFailure(Failure failure) {
        this.assumptionFailures.add(failure);
    }

    public void testFailure(Failure failure) throws Exception {
        this.failures.add(failure);
    }

    public void testIgnored(Description description) throws Exception {
        this.ignoredTests.add(description);
    }

    private void outputReport() {
        if (this.LOG.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Test Run Report:\n");
            builder.append("\nIgnored Tests:\n");
            if (this.ignoredTests.size() == 0) {
                builder.append("\tNo Ignored Tests\n");
            } else {
                for (Description description : this.ignoredTests) {
                    builder.append('\t').append(description.toString()).append('\n');
                }
            }
            builder.append("\nFailed Assumption Tests\n");
            if (this.assumptionFailures.size() == 0) {
                builder.append("\tNo Failed Assumption Tests\n");
            } else {
                builder.append("\nFailed Assumption Tests:\n");
                for (Failure failure : this.assumptionFailures) {
                    builder.append('\t').append(failure.toString()).append('\n');
                }
            }
            builder.append("\nFailed Tests:\n");
            if (this.failures.size() == 0) {
                builder.append("\tNo Failed Tests\n");
            } else {
                for (Failure failure : this.failures) {
                    builder.append('\t').append(failure.toString()).append('\n');
                }
            }
            this.LOG.info((Object)builder.toString());
        }
    }
}

