/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure.lifecycle;

import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.test.infrastructure.lifecycle.KcUnitTestLifecycle;
import org.kuali.rice.core.api.config.property.ConfigContext;

public abstract class KcUnitTestBaseLifecycle
implements KcUnitTestLifecycle {
    public static final String BROWSER_PROTOCOL = "http";
    public static final String BROWSER_ADDRESS = "127.0.0.1";
    public static final String PORTAL_ADDRESS = "kc-dev";
    protected final Log LOG = LogFactory.getLog(this.getClass());
    private boolean perTestStarted;
    private boolean perClassStarted;
    private boolean perSuiteStarted;

    protected abstract void doPerTestStart(boolean var1) throws Throwable;

    protected abstract void doPerTestStop() throws Throwable;

    protected abstract void doPerClassStart() throws Throwable;

    protected abstract void doPerClassStop() throws Throwable;

    protected abstract void doPerSuiteStart() throws Throwable;

    protected abstract void doPerSuiteStop() throws Throwable;

    @Override
    public void startPerTest(boolean transactional) {
        if (this.perTestStarted) {
            throw new IllegalStateException("per test lifecycle already started");
        }
        StopWatch watch = new StopWatch();
        if (this.LOG.isDebugEnabled()) {
            watch.start();
            this.LOG.debug((Object)"starting per test lifecycle");
        }
        try {
            this.doPerTestStart(transactional);
            this.perTestStarted = true;
        }
        catch (Throwable e) {
            this.perTestStarted = false;
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"per test lifecycle failed to start cleanly", e);
            }
            throw new KcLifecycleException(e);
        }
        if (this.LOG.isDebugEnabled()) {
            watch.stop();
            this.LOG.debug((Object)("per test lifecycle started in " + watch + " time"));
        }
    }

    @Override
    public void stopPerTest() {
        if (!this.perTestStarted) {
            throw new IllegalStateException("per test lifecycle already stopped");
        }
        StopWatch watch = new StopWatch();
        if (this.LOG.isDebugEnabled()) {
            watch.start();
            this.LOG.debug((Object)"stopping per test lifecycle");
        }
        try {
            this.doPerTestStop();
            this.perTestStarted = false;
        }
        catch (Throwable e) {
            this.perTestStarted = false;
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"per test lifecycle failed to stop cleanly", e);
            }
            throw new KcLifecycleException(e);
        }
        if (this.LOG.isDebugEnabled()) {
            watch.stop();
            this.LOG.debug((Object)("per test lifecycle stopped in " + watch + " time"));
        }
    }

    @Override
    public final boolean isPerTestStarted() {
        return this.perTestStarted;
    }

    @Override
    public void startPerClass() {
        if (this.perClassStarted) {
            throw new IllegalStateException("per class lifecycle already started");
        }
        StopWatch watch = new StopWatch();
        if (this.LOG.isDebugEnabled()) {
            watch.start();
            this.LOG.debug((Object)"starting per class lifecycle");
        }
        try {
            this.doPerClassStart();
            this.perClassStarted = true;
        }
        catch (Throwable e) {
            this.perClassStarted = false;
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"per class lifecycle failed to start cleanly", e);
            }
            throw new KcLifecycleException(e);
        }
        if (this.LOG.isDebugEnabled()) {
            watch.stop();
            this.LOG.debug((Object)("per class lifecycle started in " + watch + " time"));
        }
    }

    @Override
    public void stopPerClass() {
        if (!this.perClassStarted) {
            throw new IllegalStateException("per class lifecycle already stopped");
        }
        StopWatch watch = new StopWatch();
        if (this.LOG.isDebugEnabled()) {
            watch.start();
            this.LOG.debug((Object)"stopping per class lifecycle");
        }
        try {
            this.doPerClassStop();
            this.perClassStarted = false;
        }
        catch (Throwable e) {
            this.perClassStarted = false;
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"per class lifecycle failed to stop cleanly", e);
            }
            throw new KcLifecycleException(e);
        }
        if (this.LOG.isDebugEnabled()) {
            watch.stop();
            this.LOG.debug((Object)("per class lifecycle stopped in " + watch + " time"));
        }
    }

    @Override
    public final boolean isPerClassStarted() {
        return this.perClassStarted;
    }

    @Override
    public void startPerSuite() {
        if (this.perSuiteStarted) {
            throw new IllegalStateException("per suite lifecycle already started");
        }
        StopWatch watch = new StopWatch();
        if (this.LOG.isDebugEnabled()) {
            watch.start();
            this.LOG.debug((Object)"starting per suite lifecycle");
        }
        try {
            this.doPerSuiteStart();
            this.perSuiteStarted = true;
        }
        catch (Throwable e) {
            this.perSuiteStarted = false;
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"per suite lifecycle failed to start cleanly", e);
            }
            throw new KcLifecycleException(e);
        }
        if (this.LOG.isDebugEnabled()) {
            watch.stop();
            this.LOG.debug((Object)("per suite lifecycle started in " + watch + " time"));
        }
    }

    @Override
    public void stopPerSuite() {
        if (!this.perSuiteStarted) {
            throw new IllegalStateException("per suite lifecycle already stopped");
        }
        StopWatch watch = new StopWatch();
        if (this.LOG.isDebugEnabled()) {
            watch.start();
            this.LOG.debug((Object)"stopping per suite lifecycle");
        }
        try {
            this.doPerSuiteStop();
            this.perSuiteStarted = false;
        }
        catch (Throwable e) {
            this.perSuiteStarted = false;
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error((Object)"per suite lifecycle failed to stop cleanly", e);
            }
            throw new KcLifecycleException(e);
        }
        if (this.LOG.isDebugEnabled()) {
            watch.stop();
            this.LOG.debug((Object)("per suite lifecycle stopped in " + watch + " time"));
        }
    }

    @Override
    public final boolean isPerSuiteStarted() {
        return this.perSuiteStarted;
    }

    public static String getPort() {
        return ConfigContext.getCurrentContextConfig().getProperty("kns.test.port");
    }

    protected static class KcLifecycleException
    extends RuntimeException {
        private static final long serialVersionUID = 6680874845872733891L;

        public KcLifecycleException(Throwable t) {
            super(t);
        }
    }
}

