/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure.lifecycle;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.JettyServerLifecycle;
import org.kuali.kra.test.infrastructure.TestHarnessServiceLocator;
import org.kuali.kra.test.infrastructure.lifecycle.KcUnitTestBaseLifecycle;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.core.impl.config.property.ConfigFactoryBean;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class KcUnitTestMainLifecycle
extends KcUnitTestBaseLifecycle {
    private static final String TEST_CONFIG_XML = "classpath:META-INF/kc-test-config.xml";
    private static final String TEST_CONFIG_DEFAULTS_XML = "classpath:META-INF/test-config-defaults.xml";
    private static final String DEFAULT_TEST_HARNESS_SPRING_BEANS = "classpath:TestHarnessSpringBeans.xml";
    private static final String RELATIVE_WEB_ROOT = "/src/main/webapp";
    private static final String DEFAULT_TRANSACTION_MANAGER_NAME = "transactionManager";
    private PlatformTransactionManager transactionManager;
    private SpringResourceLoader loader;
    private JettyServerLifecycle jetty;
    private TransactionStatus perTestTransactionStatus;

    @Override
    protected void doPerClassStart() throws Throwable {
    }

    @Override
    protected void doPerClassStop() throws Throwable {
    }

    @Override
    protected void doPerSuiteStart() throws Throwable {
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)"Loading Configuration");
        }
        if (System.getProperty("module.name") == null) {
            System.setProperty("module.name", "");
        }
        if (System.getProperty("basedir") == null) {
            System.setProperty("basedir", System.getProperty("user.dir") + "/");
        }
        ConfigFactoryBean.CONFIG_OVERRIDE_LOCATION = TEST_CONFIG_XML;
        ArrayList<String> configLocations = new ArrayList<String>();
        configLocations.add(TEST_CONFIG_DEFAULTS_XML);
        configLocations.add(TEST_CONFIG_XML);
        JAXBConfigImpl config = new JAXBConfigImpl(configLocations, System.getProperties());
        config.parseConfig();
        ConfigContext.init((Config)config);
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)"Loading Spring Context...");
        }
        this.loader = new SpringResourceLoader(new QName("TestHarnessSpringContext"), DEFAULT_TEST_HARNESS_SPRING_BEANS, null);
        TestHarnessServiceLocator.setContext(this.loader.getContext());
        this.loader.start();
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)"Loading Jetty Server...");
        }
        this.jetty = new JettyServerLifecycle(Integer.parseInt(KcUnitTestBaseLifecycle.getPort()), "/kc-dev", RELATIVE_WEB_ROOT);
        this.jetty.setConfigMode(JettyServerLifecycle.ConfigMode.MERGE);
        this.jetty.start();
    }

    @Override
    protected void doPerSuiteStop() throws Throwable {
        this.jetty.stop();
        this.loader.stop();
    }

    @Override
    protected void doPerTestStart(boolean transactional) throws Throwable {
        if (transactional) {
            DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
            defaultTransactionDefinition.setTimeout(3600);
            this.perTestTransactionStatus = this.getTransactionManager().getTransaction((TransactionDefinition)defaultTransactionDefinition);
        } else {
            this.perTestTransactionStatus = null;
        }
    }

    @Override
    protected void doPerTestStop() throws Throwable {
        if (this.perTestTransactionStatus != null) {
            this.getTransactionManager().rollback(this.perTestTransactionStatus);
        }
    }

    private PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (PlatformTransactionManager)KraServiceLocator.getService((String)DEFAULT_TRANSACTION_MANAGER_NAME);
        }
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

