/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.test.infrastructure.test;

import org.junit.Test;
import org.kuali.kra.bo.ScienceKeyword;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class DbTransactionTest
extends KcUnitTestBase {
    private static final String KEYWORD_1 = "TK1";
    private static final String KEYWORD_2 = "TK2";

    @Test
    public void testRollback1() throws Throwable {
        this.rollbackTest(KEYWORD_1, KEYWORD_2);
    }

    @Test
    public void testRollback2() throws Throwable {
        this.rollbackTest(KEYWORD_2, KEYWORD_1);
    }

    public void rollbackTest(String newMessage, String oldMessage) {
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        ScienceKeyword newKeyword = new ScienceKeyword();
        newKeyword.setScienceKeywordCode(newMessage);
        newKeyword.setDescription(newMessage);
        boService.save((PersistableBusinessObject)newKeyword);
        ScienceKeyword keyword = (ScienceKeyword)boService.findBySinglePrimaryKey(ScienceKeyword.class, (Object)newMessage);
        DbTransactionTest.assertNotNull((String)"BO did not save", (Object)keyword);
        DbTransactionTest.assertEquals((String)"BO did not save properly", (Object)keyword.getDescription(), (Object)newMessage);
        keyword = (ScienceKeyword)boService.findBySinglePrimaryKey(ScienceKeyword.class, (Object)oldMessage);
        DbTransactionTest.assertNull((String)"Previous test rollback failed", (Object)keyword);
    }
}

