/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.document.authorization;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.document.authorization.TimeAndMoneyDocumentAuthorizer;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class TimeAndMoneyDocumentAuthorizerTest
extends KcUnitTestBase {
    private TimeAndMoneyDocument timeAndMoneyDocument;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private TimeAndMoneyDocumentAuthorizer authorizer;
    private Person quickstart;
    private Person borst;
    private Person irbAdmin;
    private Person iacucAdmin;

    @Before
    public void setup() throws Exception {
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.timeAndMoneyDocument = (TimeAndMoneyDocument)this.documentService.getNewDocument(TimeAndMoneyDocument.class);
        this.authorizer = new TimeAndMoneyDocumentAuthorizer();
        this.quickstart = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("quickstart");
        this.borst = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("borst");
        this.irbAdmin = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("irbAdmin");
        this.iacucAdmin = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("iacucAdmin");
        this.addIrbAdminToAGroupWithTimeAndMoneyPerm();
        this.addIacucAdminToTimeAndMoneyRole();
    }

    @After
    public void teardown() {
        this.documentService = null;
        this.businessObjectService = null;
        this.timeAndMoneyDocument = null;
        this.authorizer = null;
        this.quickstart = null;
        this.borst = null;
        this.irbAdmin = null;
        this.iacucAdmin = null;
    }

    private void addIrbAdminToAGroupWithTimeAndMoneyPerm() {
        RoleService rs = (RoleService)KraServiceLocator.getService(RoleService.class);
        Role timeAndMoneyModifier = rs.getRoleByNamespaceCodeAndName("KC-T", "Time And Money Modifier");
        GroupService gs = (GroupService)KraServiceLocator.getService(GroupService.class);
        gs.createGroup(Group.Builder.create((String)"KC-T", (String)"TimeAndMoneyTestGroup", (String)"21").build());
        Group timeAndMoneyTestGroup = gs.getGroupByNamespaceCodeAndName("KC-T", "TimeAndMoneyTestGroup");
        gs.addPrincipalToGroup(this.irbAdmin.getPrincipalId(), timeAndMoneyTestGroup.getId());
        String groupId = timeAndMoneyTestGroup.getId();
        String namespaceCode = timeAndMoneyModifier.getNamespaceCode();
        String roleName = timeAndMoneyModifier.getName();
        rs.assignGroupToRole(groupId, namespaceCode, roleName, new HashMap());
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("ROLE_ID", timeAndMoneyModifier.getId());
        fieldValues.put("MBR_ID", timeAndMoneyTestGroup.getId());
        Collection roleMembers = this.businessObjectService.findMatching(RoleMemberBo.class, fieldValues);
        RoleMemberBo roleMember = (RoleMemberBo)roleMembers.iterator().next();
        RoleMemberAttributeDataBo attrData = new RoleMemberAttributeDataBo();
        attrData.setAttributeValue("000001");
        attrData.setKimAttributeId("47");
        attrData.setKimTypeId("69");
        attrData.setAssignedToId(roleMember.getId());
        RoleMemberAttributeDataBo attrDataTwo = new RoleMemberAttributeDataBo();
        attrDataTwo.setAttributeValue("Y");
        attrDataTwo.setKimAttributeId("48");
        attrDataTwo.setKimTypeId("69");
        attrDataTwo.setAssignedToId(roleMember.getId());
        roleMember.getAttributeDetails().add(attrData);
        roleMember.getAttributeDetails().add(attrDataTwo);
        this.businessObjectService.save((PersistableBusinessObject)roleMember);
        this.businessObjectService.save((PersistableBusinessObject)attrData);
        this.businessObjectService.save((PersistableBusinessObject)attrDataTwo);
    }

    private void addIacucAdminToTimeAndMoneyRole() {
        RoleService rs = (RoleService)KraServiceLocator.getService(RoleService.class);
        Role timeAndMoneyModifier = rs.getRoleByNamespaceCodeAndName("KC-T", "Time And Money Modifier");
        String namespaceCode = timeAndMoneyModifier.getNamespaceCode();
        String roleName = timeAndMoneyModifier.getName();
        rs.assignPrincipalToRole(this.iacucAdmin.getPrincipalId(), namespaceCode, roleName, new HashMap());
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("ROLE_ID", timeAndMoneyModifier.getId());
        fieldValues.put("MBR_ID", this.iacucAdmin.getPrincipalId());
        Collection roleMembers = this.businessObjectService.findMatching(RoleMemberBo.class, fieldValues);
        RoleMemberBo roleMember = (RoleMemberBo)roleMembers.iterator().next();
        RoleMemberAttributeDataBo attrData = new RoleMemberAttributeDataBo();
        attrData.setAttributeValue("000001");
        attrData.setKimAttributeId("47");
        attrData.setKimTypeId("69");
        attrData.setAssignedToId(roleMember.getId());
        RoleMemberAttributeDataBo attrDataTwo = new RoleMemberAttributeDataBo();
        attrDataTwo.setAttributeValue("Y");
        attrDataTwo.setKimAttributeId("48");
        attrDataTwo.setKimTypeId("69");
        attrDataTwo.setAssignedToId(roleMember.getId());
        roleMember.getAttributeDetails().add(attrData);
        roleMember.getAttributeDetails().add(attrDataTwo);
        this.businessObjectService.save((PersistableBusinessObject)roleMember);
        this.businessObjectService.save((PersistableBusinessObject)attrData);
        this.businessObjectService.save((PersistableBusinessObject)attrDataTwo);
    }

    @Test
    public void verifyRoleStuff() {
        RoleService rs = (RoleService)KraServiceLocator.getService(RoleService.class);
        Role timeAndMoneyModifier = rs.getRoleByNamespaceCodeAndName("KC-T", "Time And Money Modifier");
        GroupService gs = (GroupService)KraServiceLocator.getService(GroupService.class);
        Group timeAndMoneyTestGroup = gs.getGroupByNamespaceCodeAndName("KC-T", "TimeAndMoneyTestGroup");
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("ROLE_ID", timeAndMoneyModifier.getId());
        fieldValues.put("MBR_ID", timeAndMoneyTestGroup.getId());
        Collection roleMembers = this.businessObjectService.findMatching(RoleMemberBo.class, fieldValues);
        RoleMemberBo roleMember = (RoleMemberBo)roleMembers.iterator().next();
        boolean foundUnit = false;
        boolean foundHierarchFlag = false;
        for (RoleMemberAttributeDataBo rmb : roleMember.getAttributeDetails()) {
            if (StringUtils.equalsIgnoreCase((String)rmb.getAttributeValue(), (String)"000001")) {
                foundUnit = true;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)rmb.getAttributeValue(), (String)"Y")) continue;
            foundHierarchFlag = true;
        }
        TimeAndMoneyDocumentAuthorizerTest.assertEquals((long)2L, (long)roleMember.getAttributeDetails().size());
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)foundUnit);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)foundHierarchFlag);
    }

    @Test
    public void testAddRoleQualificationObjectMapOfStringString() {
        HashMap roleQual = new HashMap();
        this.authorizer.addRoleQualification((Object)this.timeAndMoneyDocument, roleQual);
        TimeAndMoneyDocumentAuthorizerTest.assertNotNull(roleQual.get("unitNumber"));
    }

    @Test
    public void testCanInitiate() {
        boolean canQuickstart = this.authorizer.canInitiate("TimeAndMoneyDocument", this.quickstart);
        boolean canBorst = this.authorizer.canInitiate("TimeAndMoneyDocument", this.borst);
        boolean canIrbAdmin = this.authorizer.canInitiate("TimeAndMoneyDocument", this.irbAdmin);
        boolean canIaccucAdmin = this.authorizer.canInitiate("TimeAndMoneyDocument", this.iacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertFalse((boolean)canBorst);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIaccucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIrbAdmin);
    }

    @Test
    public void testCanEdit() {
        boolean canQuickstart = this.authorizer.canEdit((Document)this.timeAndMoneyDocument, this.quickstart);
        boolean canBorst = this.authorizer.canEdit((Document)this.timeAndMoneyDocument, this.borst);
        boolean canIrbAdmin = this.authorizer.canEdit((Document)this.timeAndMoneyDocument, this.irbAdmin);
        boolean canIacucAdmin = this.authorizer.canEdit((Document)this.timeAndMoneyDocument, this.iacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertFalse((boolean)canBorst);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIrbAdmin);
    }

    @Test
    public void testCanAnnotate() {
        boolean canQuickstart = this.authorizer.canAnnotate((Document)this.timeAndMoneyDocument, this.quickstart);
        boolean canBorst = this.authorizer.canAnnotate((Document)this.timeAndMoneyDocument, this.borst);
        boolean canIrbAdmin = this.authorizer.canAnnotate((Document)this.timeAndMoneyDocument, this.irbAdmin);
        boolean canIacucAdmin = this.authorizer.canAnnotate((Document)this.timeAndMoneyDocument, this.iacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertFalse((boolean)canBorst);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
    }

    @Test
    public void testCanReload() {
        boolean canQuickstart = this.authorizer.canReload((Document)this.timeAndMoneyDocument, this.quickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
    }

    @Test
    public void testCanClose() {
        boolean canQuickstart = this.authorizer.canClose((Document)this.timeAndMoneyDocument, this.quickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
    }

    @Test
    public void testCanSave() {
        boolean canQuickstart = this.authorizer.canSave((Document)this.timeAndMoneyDocument, this.quickstart);
        boolean canBorst = this.authorizer.canSave((Document)this.timeAndMoneyDocument, this.borst);
        boolean canIrbAdmin = this.authorizer.canSave((Document)this.timeAndMoneyDocument, this.irbAdmin);
        boolean canIacucAdmin = this.authorizer.canSave((Document)this.timeAndMoneyDocument, this.iacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertFalse((boolean)canBorst);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIrbAdmin);
    }

    @Test
    public void testCanRoute() {
        boolean canQuickstart = this.authorizer.canRoute((Document)this.timeAndMoneyDocument, this.quickstart);
        boolean canBorst = this.authorizer.canRoute((Document)this.timeAndMoneyDocument, this.borst);
        boolean canIrbAdmin = this.authorizer.canRoute((Document)this.timeAndMoneyDocument, this.irbAdmin);
        boolean canIacucAdmin = this.authorizer.canRoute((Document)this.timeAndMoneyDocument, this.iacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertFalse((boolean)canBorst);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIrbAdmin);
    }

    @Test
    public void testCanCancel() {
        boolean canQuickstart = this.authorizer.canCancel((Document)this.timeAndMoneyDocument, this.quickstart);
        boolean canBorst = this.authorizer.canCancel((Document)this.timeAndMoneyDocument, this.borst);
        boolean canIrbAdmin = this.authorizer.canCancel((Document)this.timeAndMoneyDocument, this.irbAdmin);
        boolean canIacucAdmin = this.authorizer.canCancel((Document)this.timeAndMoneyDocument, this.iacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertFalse((boolean)canBorst);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIrbAdmin);
    }

    @Test
    public void testHasCreatePermission1() {
        boolean canQuickstart = this.authorizer.hasCreatePermission(this.timeAndMoneyDocument, this.quickstart);
        boolean canBorst = this.authorizer.hasCreatePermission(this.timeAndMoneyDocument, this.borst);
        boolean canIrbAdmin = this.authorizer.hasCreatePermission(this.timeAndMoneyDocument, this.irbAdmin);
        boolean canIacucAdmin = this.authorizer.hasCreatePermission(this.timeAndMoneyDocument, this.iacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canQuickstart);
        TimeAndMoneyDocumentAuthorizerTest.assertFalse((boolean)canBorst);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIacucAdmin);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)canIrbAdmin);
    }

    @Test
    public void testQuickStartPerm() {
        RoleService rs = (RoleService)KraServiceLocator.getService(RoleService.class);
        Role timeAndMoneyModifier = rs.getRoleByNamespaceCodeAndName("KC-T", "Time And Money Modifier");
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("ROLE_ID", timeAndMoneyModifier.getId());
        fieldValues.put("MBR_ID", this.quickstart.getPrincipalId());
        Collection roleMembers = this.businessObjectService.findMatching(RoleMemberBo.class, fieldValues);
        RoleMemberBo roleMember = (RoleMemberBo)roleMembers.iterator().next();
        boolean foundUnit = false;
        boolean foundHierarchFlag = false;
        for (RoleMemberAttributeDataBo rmb : roleMember.getAttributeDetails()) {
            if (StringUtils.equalsIgnoreCase((String)rmb.getAttributeValue(), (String)"000001")) {
                foundUnit = true;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)rmb.getAttributeValue(), (String)"Y")) continue;
            foundHierarchFlag = true;
        }
        TimeAndMoneyDocumentAuthorizerTest.assertEquals((long)2L, (long)roleMember.getAttributeDetails().size());
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)foundUnit);
        TimeAndMoneyDocumentAuthorizerTest.assertTrue((boolean)foundHierarchFlag);
    }
}

