/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.service.impl.ActivePendingTransactionsServiceImpl;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ActivePendingTransactionServiceImplTest {
    public static final KualiDecimal TEN_THOUSAND = new KualiDecimal(10000);
    public static final KualiDecimal TWENTY_THOUSAND = new KualiDecimal(20000);
    public static final KualiDecimal ZERO = new KualiDecimal(0);
    public static final String awardNumber1 = "000021-00001";
    public static final String awardNumber2 = "000021-00002";
    public static final String awardNumber3 = "000021-00003";
    public static final String awardNumber4 = "000021-00004";
    public static final String awardNumber5 = "000021-00005";
    public static final String awardNumber6 = "000021-00006";
    public static final String awardNumber7 = "000021-00007";
    ActivePendingTransactionsServiceImpl activePendingTransactionsServiceImpl;
    Map<String, AwardHierarchyNode> awardHierarchyNodes;
    AwardHierarchyNode awardHierarchyNode;
    PendingTransaction pt;

    @Before
    public void setUp() throws Exception {
        this.activePendingTransactionsServiceImpl = new ActivePendingTransactionsServiceImpl();
        this.awardHierarchyNodes = new HashMap<String, AwardHierarchyNode>();
        this.awardHierarchyNode = new AwardHierarchyNode();
        this.pt = new PendingTransaction();
    }

    @After
    public void tearDown() throws Exception {
        this.activePendingTransactionsServiceImpl = null;
        this.awardHierarchyNodes = null;
        this.awardHierarchyNode = null;
        this.pt = null;
    }

    @Test
    public void testIndirectParentChildRelationshipExists() {
        this.addAwardHierarchyNode(awardNumber1, "000000-00000", awardNumber1);
        this.addAwardHierarchyNode(awardNumber1, awardNumber1, awardNumber2);
        this.addAwardHierarchyNode(awardNumber1, awardNumber1, awardNumber3);
        this.addAwardHierarchyNode(awardNumber1, awardNumber2, awardNumber4);
        AwardHierarchyNode parent = new AwardHierarchyNode();
        Assert.assertTrue((boolean)this.activePendingTransactionsServiceImpl.parentChildRelationshipExists(awardNumber1, awardNumber2, this.awardHierarchyNodes, parent));
        Assert.assertEquals((Object)awardNumber1, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertTrue((boolean)this.activePendingTransactionsServiceImpl.parentChildRelationshipExists(awardNumber1, awardNumber3, this.awardHierarchyNodes, parent));
        Assert.assertEquals((Object)awardNumber1, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertTrue((boolean)this.activePendingTransactionsServiceImpl.parentChildRelationshipExists(awardNumber1, awardNumber4, this.awardHierarchyNodes, parent));
        Assert.assertEquals((Object)awardNumber1, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertFalse((boolean)this.activePendingTransactionsServiceImpl.parentChildRelationshipExists(awardNumber2, awardNumber3, this.awardHierarchyNodes, parent));
        Assert.assertEquals(null, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertTrue((boolean)this.activePendingTransactionsServiceImpl.parentChildRelationshipExists(awardNumber2, awardNumber4, this.awardHierarchyNodes, parent));
        Assert.assertEquals((Object)awardNumber2, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertTrue((boolean)this.activePendingTransactionsServiceImpl.childParentRelationshipExists(awardNumber1, awardNumber2, this.awardHierarchyNodes, parent));
        Assert.assertEquals((Object)awardNumber1, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertTrue((boolean)this.activePendingTransactionsServiceImpl.childParentRelationshipExists(awardNumber1, awardNumber3, this.awardHierarchyNodes, parent));
        Assert.assertEquals((Object)awardNumber1, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertTrue((boolean)this.activePendingTransactionsServiceImpl.childParentRelationshipExists(awardNumber1, awardNumber4, this.awardHierarchyNodes, parent));
        Assert.assertEquals((Object)awardNumber1, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertFalse((boolean)this.activePendingTransactionsServiceImpl.childParentRelationshipExists(awardNumber2, awardNumber3, this.awardHierarchyNodes, parent));
        Assert.assertEquals(null, (Object)parent.getAwardNumber());
        parent = new AwardHierarchyNode();
        Assert.assertTrue((boolean)this.activePendingTransactionsServiceImpl.childParentRelationshipExists(awardNumber2, awardNumber4, this.awardHierarchyNodes, parent));
        Assert.assertEquals((Object)awardNumber2, (Object)parent.getAwardNumber());
    }

    public void testProcessPendingTransaction() {
    }

    @Test
    public void testUpdateAmountFields() {
        AwardAmountInfo aai = new AwardAmountInfo();
        aai.setAmountObligatedToDate(TEN_THOUSAND);
        aai.setAntDistributableAmount(TEN_THOUSAND);
        aai.setObliDistributableAmount(TEN_THOUSAND);
        aai.setAnticipatedTotalAmount(TEN_THOUSAND);
        AwardAmountInfo nai = new AwardAmountInfo();
        nai.setAmountObligatedToDate(TEN_THOUSAND);
        nai.setAntDistributableAmount(TEN_THOUSAND);
        nai.setObliDistributableAmount(TEN_THOUSAND);
        nai.setAnticipatedTotalAmount(TEN_THOUSAND);
        this.pt.setSourceAwardNumber("000000-00000");
        this.pt.setDestinationAwardNumber(awardNumber1);
        this.pt.setObligatedAmount(TEN_THOUSAND);
        this.pt.setAnticipatedAmount(TEN_THOUSAND);
        this.activePendingTransactionsServiceImpl.updateAmountFields(false, false, this.pt, aai, nai);
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAntDistributableAmount());
        Assert.assertEquals((Object)TWENTY_THOUSAND, (Object)nai.getAnticipatedTotalAmount());
        Assert.assertEquals((Object)TWENTY_THOUSAND, (Object)nai.getAmountObligatedToDate());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getObliDistributableAmount());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getObligatedChange());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAnticipatedChange());
        this.pt.setSourceAwardNumber(awardNumber1);
        this.pt.setDestinationAwardNumber(awardNumber3);
        this.pt.setObligatedAmount(TEN_THOUSAND);
        this.pt.setAnticipatedAmount(TEN_THOUSAND);
        this.activePendingTransactionsServiceImpl.updateAmountFields(false, false, this.pt, aai, nai);
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAntDistributableAmount());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAnticipatedTotalAmount());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAmountObligatedToDate());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getObliDistributableAmount());
        Assert.assertEquals((Object)ZERO, (Object)nai.getObligatedChange());
        Assert.assertEquals((Object)ZERO, (Object)nai.getAnticipatedChange());
        this.pt.setSourceAwardNumber(awardNumber1);
        this.pt.setDestinationAwardNumber(awardNumber3);
        this.pt.setObligatedAmount(TEN_THOUSAND);
        this.pt.setAnticipatedAmount(TEN_THOUSAND);
        this.activePendingTransactionsServiceImpl.updateAmountFields(true, true, this.pt, aai, nai);
        Assert.assertEquals((Object)TWENTY_THOUSAND, (Object)nai.getAntDistributableAmount());
        Assert.assertEquals((Object)TWENTY_THOUSAND, (Object)nai.getAnticipatedTotalAmount());
        Assert.assertEquals((Object)TWENTY_THOUSAND, (Object)nai.getAmountObligatedToDate());
        Assert.assertEquals((Object)TWENTY_THOUSAND, (Object)nai.getObliDistributableAmount());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getObligatedChange());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAnticipatedChange());
        this.pt.setSourceAwardNumber(awardNumber1);
        this.pt.setDestinationAwardNumber(awardNumber3);
        this.pt.setObligatedAmount(TEN_THOUSAND);
        this.pt.setAnticipatedAmount(TEN_THOUSAND);
        this.activePendingTransactionsServiceImpl.updateAmountFields(true, false, this.pt, aai, nai);
        Assert.assertEquals((Object)ZERO, (Object)nai.getAntDistributableAmount());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAnticipatedTotalAmount());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAmountObligatedToDate());
        Assert.assertEquals((Object)ZERO, (Object)nai.getObliDistributableAmount());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getObligatedChange());
        Assert.assertEquals((Object)TEN_THOUSAND, (Object)nai.getAnticipatedChange());
    }

    public void testValidateAntiDistributableAmount() {
        AwardAmountInfo awardAmountInfo = new AwardAmountInfo();
        this.pt.setSourceAwardNumber("000000-00000");
        this.pt.setDestinationAwardNumber(awardNumber1);
        this.pt.setObligatedAmount(TEN_THOUSAND);
        this.pt.setAnticipatedAmount(TEN_THOUSAND);
        KualiDecimal totalPendingAnticipated = TEN_THOUSAND;
        this.activePendingTransactionsServiceImpl.validateAntiDistributableAmount(this.pt, awardAmountInfo, totalPendingAnticipated);
    }

    @Test
    public void testFindCommonParent() {
        this.addAwardHierarchyNode(awardNumber1, "000000-00000", awardNumber1);
        this.addAwardHierarchyNode(awardNumber1, awardNumber1, awardNumber2);
        this.addAwardHierarchyNode(awardNumber1, awardNumber1, awardNumber3);
        this.addAwardHierarchyNode(awardNumber1, awardNumber2, awardNumber4);
        this.addAwardHierarchyNode(awardNumber1, awardNumber2, awardNumber5);
        this.addAwardHierarchyNode(awardNumber1, awardNumber3, awardNumber6);
        this.addAwardHierarchyNode(awardNumber1, awardNumber3, awardNumber7);
        Assert.assertEquals((Object)awardNumber1, (Object)this.activePendingTransactionsServiceImpl.findCommonParent(this.awardHierarchyNodes, awardNumber1, awardNumber2, awardNumber3));
        Assert.assertEquals((Object)awardNumber1, (Object)this.activePendingTransactionsServiceImpl.findCommonParent(this.awardHierarchyNodes, awardNumber1, awardNumber2, awardNumber4));
        Assert.assertEquals((Object)awardNumber1, (Object)this.activePendingTransactionsServiceImpl.findCommonParent(this.awardHierarchyNodes, awardNumber1, awardNumber4, awardNumber6));
        Assert.assertEquals((Object)awardNumber2, (Object)this.activePendingTransactionsServiceImpl.findCommonParent(this.awardHierarchyNodes, awardNumber1, awardNumber4, awardNumber5));
        Assert.assertEquals((Object)awardNumber3, (Object)this.activePendingTransactionsServiceImpl.findCommonParent(this.awardHierarchyNodes, awardNumber1, awardNumber6, awardNumber7));
        Assert.assertEquals((Object)awardNumber1, (Object)this.activePendingTransactionsServiceImpl.findCommonParent(this.awardHierarchyNodes, awardNumber1, awardNumber2, awardNumber7));
        Assert.assertEquals((Object)awardNumber1, (Object)this.activePendingTransactionsServiceImpl.findCommonParent(this.awardHierarchyNodes, awardNumber1, awardNumber3, awardNumber4));
    }

    private void addAwardHierarchyNode(String rootAwardNumber, String parentAwardNumber, String awardNumber) {
        this.awardHierarchyNode = new AwardHierarchyNode();
        this.awardHierarchyNode.setAwardNumber(awardNumber);
        this.awardHierarchyNode.setParentAwardNumber(parentAwardNumber);
        this.awardHierarchyNode.setRootAwardNumber(rootAwardNumber);
        this.awardHierarchyNodes.put(awardNumber, this.awardHierarchyNode);
    }
}

