/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.service.impl;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.timeandmoney.service.impl.AwardFnaDistributionServiceImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

@RunWith(value=JMock.class)
public class AwardFnaDistributionServiceImplTest {
    private static final String DISABLED = "D";
    private static final String MANDATORY = "M";
    private static final String OPTIONAL = "O";
    private AwardFnaDistributionServiceImpl awardFnaDistributionServiceImpl;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.awardFnaDistributionServiceImpl = new AwardFnaDistributionServiceImpl();
    }

    @After
    public void tearDown() throws Exception {
        this.awardFnaDistributionServiceImpl = null;
    }

    private ParameterService getParameterService(final String parmVal) {
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parameterService)).getParameterValueAsString("KC-AWARD", "Document", "AWARD_FNA_DISTRIBUTION");
                this.will(1.returnValue((Object)parmVal));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parameterService)).getParameterValueAsString("KC-AWARD", "Document", "AWARD_FNA_DISTRIBUTION");
                this.will(2.returnValue((Object)parmVal));
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.one(parameterService)).getParameterValueAsString("KC-AWARD", "Document", "AWARD_FNA_DISTRIBUTION");
                this.will(3.returnValue((Object)parmVal));
            }
        });
        return parameterService;
    }

    @Test
    public void testDisabledParm() {
        this.awardFnaDistributionServiceImpl.setParameterService(this.getParameterService(DISABLED));
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.displayAwardFAndADistributionEqualityValidationAsWarning());
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.displayAwardFAndADistributionEqualityValidationAsError());
        Assert.assertTrue((boolean)this.awardFnaDistributionServiceImpl.disableFAndADistributionEqualityValidation());
        Assert.assertTrue((boolean)this.awardFnaDistributionServiceImpl.isDisabled(DISABLED));
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.isMandatory(DISABLED));
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.isOptional(DISABLED));
    }

    @Test
    public void testMandatoryParm() {
        this.awardFnaDistributionServiceImpl.setParameterService(this.getParameterService(MANDATORY));
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.displayAwardFAndADistributionEqualityValidationAsWarning());
        Assert.assertTrue((boolean)this.awardFnaDistributionServiceImpl.displayAwardFAndADistributionEqualityValidationAsError());
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.disableFAndADistributionEqualityValidation());
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.isDisabled(MANDATORY));
        Assert.assertTrue((boolean)this.awardFnaDistributionServiceImpl.isMandatory(MANDATORY));
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.isOptional(MANDATORY));
    }

    @Test
    public void testOptionalParm() {
        this.awardFnaDistributionServiceImpl.setParameterService(this.getParameterService(OPTIONAL));
        Assert.assertTrue((boolean)this.awardFnaDistributionServiceImpl.displayAwardFAndADistributionEqualityValidationAsWarning());
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.displayAwardFAndADistributionEqualityValidationAsError());
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.disableFAndADistributionEqualityValidation());
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.isDisabled(OPTIONAL));
        Assert.assertFalse((boolean)this.awardFnaDistributionServiceImpl.isMandatory(OPTIONAL));
        Assert.assertTrue((boolean)this.awardFnaDistributionServiceImpl.isOptional(OPTIONAL));
    }
}

