/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.util;

import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.util.NaturalStringComparator;

public class NaturalStringComparatorTest {
    private NaturalStringComparator comparator;
    private String[] sorted = new String[]{null, "", "1", "5", "10", "10ab", "f001a", "f1a", "f30a", "f200a"};
    private String[] unsorted = new String[]{"10", "f30a", "1", "f200a", "5", null, "10ab", "f001a", "", "f1a"};

    @Before
    public void setUp() throws Exception {
        this.comparator = new NaturalStringComparator();
    }

    @After
    public void tearDown() throws Exception {
        this.comparator = null;
    }

    @Test
    public void testNullComparison() throws Exception {
        int val = this.comparator.compare(this.sorted[0], this.sorted[5]);
        Assert.assertTrue((val < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyStringComparison() throws Exception {
        int val = this.comparator.compare(this.sorted[1], this.sorted[5]);
        Assert.assertTrue((val < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNumericStringComparison() throws Exception {
        int val = this.comparator.compare(this.sorted[3], this.sorted[4]);
        Assert.assertTrue((val < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMixedStringComparison() throws Exception {
        int val = this.comparator.compare(this.sorted[8], this.sorted[9]);
        Assert.assertTrue((val < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListSorting() throws Exception {
        Assert.assertFalse((boolean)Arrays.equals(this.sorted, this.unsorted));
        Arrays.sort(this.unsorted, this.comparator);
        Assert.assertTrue((boolean)Arrays.equals(this.sorted, this.unsorted));
    }
}

