/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.action;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.web.struts.action.AuditMapSorter;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;

public class AuditMapSorterTest {
    private Map<String, AuditCluster> fooBarErrorMap;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setupFooBarMap() {
        this.fooBarErrorMap = new HashMap<String, AuditCluster>();
        AuditCluster a = new AuditCluster();
        ArrayList<AuditError> auditErrorList = new ArrayList<AuditError>();
        auditErrorList.add(new AuditError("fe", "fi", "fo", new String[]{"fum"}));
        auditErrorList.add(new AuditError("fee", "fii", "foo", new String[]{"fumm"}));
        a.setAuditErrorList(auditErrorList);
        this.fooBarErrorMap.put("foo", a);
        a = new AuditCluster();
        auditErrorList = new ArrayList();
        auditErrorList.add(new AuditError("fe", "fi", "fo", new String[]{"fum"}));
        auditErrorList.add(new AuditError("fee", "fii", "foo", new String[]{"fumm"}));
        a.setAuditErrorList(auditErrorList);
        this.fooBarErrorMap.put("bar", a);
    }

    @Test(expected=NullPointerException.class)
    public void testNullAuditErrorsMap() {
        new AuditMapSorter(null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullCompMap() {
        new AuditMapSorter(new HashMap()).sort(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyCompMap() {
        new AuditMapSorter(new HashMap()).sort(new HashMap());
    }

    @Test(expected=NullPointerException.class)
    public void testNullCompInMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("foo", null);
        new AuditMapSorter(this.fooBarErrorMap).sort(m);
    }

    @Test
    public void testSortHappensSingle() {
        HashMap<String, Comparator> compMap = new HashMap<String, Comparator>();
        final Comparator comp = (Comparator)this.context.mock(Comparator.class);
        compMap.put("bar", comp);
        this.fooBarErrorMap.remove("foo");
        Assert.assertEquals((long)1L, (long)this.fooBarErrorMap.size());
        Assert.assertTrue((String)"does not contain key bar", (boolean)this.fooBarErrorMap.containsKey("bar"));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                AuditError e0 = (AuditError)((AuditCluster)AuditMapSorterTest.this.fooBarErrorMap.get("bar")).getAuditErrorList().get(0);
                AuditError e1 = (AuditError)((AuditCluster)AuditMapSorterTest.this.fooBarErrorMap.get("bar")).getAuditErrorList().get(1);
                ((Comparator)this.oneOf(comp)).compare(e0, e1);
            }
        });
        new AuditMapSorter(this.fooBarErrorMap).sort(compMap);
        this.context.assertIsSatisfied();
    }

    @Test
    public void testSortHappensMult() {
        HashMap<String, Comparator> compMap = new HashMap<String, Comparator>();
        final Comparator comp = (Comparator)this.context.mock(Comparator.class);
        compMap.put(".*", comp);
        Assert.assertEquals((long)2L, (long)this.fooBarErrorMap.size());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                AuditError e0 = (AuditError)((AuditCluster)AuditMapSorterTest.this.fooBarErrorMap.get("bar")).getAuditErrorList().get(0);
                AuditError e1 = (AuditError)((AuditCluster)AuditMapSorterTest.this.fooBarErrorMap.get("bar")).getAuditErrorList().get(1);
                ((Comparator)this.oneOf(comp)).compare(e0, e1);
                AuditError e3 = (AuditError)((AuditCluster)AuditMapSorterTest.this.fooBarErrorMap.get("foo")).getAuditErrorList().get(0);
                AuditError e4 = (AuditError)((AuditCluster)AuditMapSorterTest.this.fooBarErrorMap.get("foo")).getAuditErrorList().get(1);
                ((Comparator)this.oneOf(comp)).compare(e3, e4);
            }
        });
        new AuditMapSorter(this.fooBarErrorMap).sort(compMap);
        this.context.assertIsSatisfied();
    }
}

