/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.workflow.test;

import java.sql.Date;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

@Ignore
public class ProposalDevelopmentDocumentAlternateRoutingTest
extends KcUnitTestBase {
    private DocumentService documentService = null;
    private static final String WORKFLOW_ADMIN_GROUP_ID = "1";
    private static final String USER_PRINCIPLE_ID = "jtester";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.documentService = KRADServiceLocatorWeb.getDocumentService();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        this.documentService = null;
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        this.logAfterRun();
    }

    @Test
    public void testAlternateRoutingPath() throws Exception {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.documentService.getNewDocument("ProposalDevelopmentDocument");
        Date requestedStartDateInitial = new Date(System.currentTimeMillis());
        Date requestedEndDateInitial = new Date(System.currentTimeMillis());
        document.getDocumentHeader().setDocumentDescription("TestAltRoutingPath-1");
        document.getDevelopmentProposal().setSponsorCode("005770");
        document.getDevelopmentProposal().setTitle("AltRoutingPath");
        document.getDevelopmentProposal().setRequestedStartDateInitial(requestedStartDateInitial);
        document.getDevelopmentProposal().setRequestedEndDateInitial(requestedEndDateInitial);
        document.getDevelopmentProposal().setActivityTypeCode(WORKFLOW_ADMIN_GROUP_ID);
        document.getDevelopmentProposal().setProposalTypeCode(WORKFLOW_ADMIN_GROUP_ID);
        document.getDevelopmentProposal().setOwnedByUnitNumber("000001");
        this.documentService.saveDocument((Document)document);
        ProposalDevelopmentDocument savedDocument = (ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(document.getDocumentNumber());
        ProposalDevelopmentDocumentAlternateRoutingTest.assertNotNull((Object)savedDocument);
        WorkflowDocument workflowDoc = savedDocument.getDocumentHeader().getWorkflowDocument();
        workflowDoc.complete("test");
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)workflowDoc.getDocumentId());
        reportCriteriaBuilder.setTargetPrincipalIds(Collections.singletonList(USER_PRINCIPLE_ID));
        reportCriteriaBuilder.setActivateRequests(true);
        WorkflowDocumentActionsService info = (WorkflowDocumentActionsService)GlobalResourceLoader.getService((String)"rice.kew.workflowDocumentActionsService");
        DocumentDetail results1 = info.executeSimulation(reportCriteriaBuilder.build());
        List actionRequests = results1.getActionRequests();
        ProposalDevelopmentDocumentAlternateRoutingTest.assertNotNull((Object)actionRequests);
        ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((long)4L, (long)actionRequests.size());
        for (ActionRequest actionRequest : actionRequests) {
            if (actionRequest.getNodeName().equalsIgnoreCase("Initiated")) {
                ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((Object)"U", (Object)actionRequest.getRecipientType().getCode());
                ProposalDevelopmentDocumentAlternateRoutingTest.assertNotNull((Object)actionRequest.getPrincipalId());
                ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((Object)"quickstart", (Object)actionRequest.getPrincipalId());
                continue;
            }
            if (actionRequest.getNodeName().equalsIgnoreCase("FirstApproval")) {
                ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((Object)"U", (Object)actionRequest.getRecipientType().getCode());
                ProposalDevelopmentDocumentAlternateRoutingTest.assertNotNull((Object)actionRequest.getPrincipalId());
                ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((Object)USER_PRINCIPLE_ID, (Object)actionRequest.getPrincipalId());
                continue;
            }
            if (actionRequest.getNodeName().equalsIgnoreCase("SecondApproval")) {
                ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((Object)"U", (Object)actionRequest.getRecipientType().getCode());
                ProposalDevelopmentDocumentAlternateRoutingTest.assertNotNull((Object)actionRequest.getPrincipalId());
                ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((Object)"quickstart", (Object)actionRequest.getPrincipalId());
                continue;
            }
            if (actionRequest.getNodeName().equalsIgnoreCase("FinalApproval")) {
                ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((Object)"W", (Object)actionRequest.getRecipientType().getCode());
                ProposalDevelopmentDocumentAlternateRoutingTest.assertNotNull((Object)actionRequest.getGroupId());
                ProposalDevelopmentDocumentAlternateRoutingTest.assertEquals((Object)WORKFLOW_ADMIN_GROUP_ID, (Object)actionRequest.getGroupId());
                continue;
            }
            ProposalDevelopmentDocumentAlternateRoutingTest.fail((String)"Unexpected ActionRequest generated for ProposalDevelopmentDocument");
        }
    }
}

