/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.workflow.test;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.web.ProposalDevelopmentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;

@Ignore
public class ProposalDevelopmentDocumentRoutingSeleniumTest
extends KcSeleniumTestBase {
    private static final String APPROVER = "jtester";
    private static final String WORKFLOW_ADMIN_GROUP_ID = "1";
    private ProposalDevelopmentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProposalDevelopmentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAlternateRoutingWithMultipleApproval() throws Exception {
        this.helper.createProposalDevelopment();
        this.helper.addKeyPersonnel();
        this.helper.addCustomData();
        this.helper.addPermissions();
        this.helper.addQuestions();
        this.helper.clickProposalDevelopmentActionsPage();
        this.helper.routeDocument();
        this.helper.clickYesAnswer();
        this.helper.assertRoute();
        String documentNumber = this.helper.getDocumentNumber();
        this.helper.closeDocument();
        this.helper.loginBackdoor(APPROVER);
        this.helper.click("Action List");
        this.helper.click(documentNumber);
        this.helper.clickProposalDevelopmentActionsPage();
        this.helper.approveDocument();
        this.helper.clickYesAnswer();
        ProposalDevelopmentDocument savedDocument = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        ProposalDevelopmentDocumentRoutingSeleniumTest.assertNotNull((Object)savedDocument);
        WorkflowDocument workflowDoc = savedDocument.getDocumentHeader().getWorkflowDocument();
        ProposalDevelopmentDocumentRoutingSeleniumTest.assertNotNull((Object)workflowDoc);
        boolean receiveFutureRequests = false;
        boolean doNotReceiveFutureRequests = false;
        Map variables = workflowDoc.getVariables();
        if (variables != null && CollectionUtils.isNotEmpty(variables.keySet())) {
            for (String variableKey : variables.keySet()) {
                String variableValue = (String)variables.get(variableKey);
                if (variableKey.startsWith("_receive_future_requests") && variableValue.toUpperCase().equals("YES") && variableKey.contains(APPROVER)) {
                    receiveFutureRequests = true;
                    break;
                }
                if (!variableKey.startsWith("_receive_future_requests") || !variableValue.toUpperCase().equals("NO") || !variableKey.contains(APPROVER)) continue;
                doNotReceiveFutureRequests = true;
                break;
            }
        }
        ProposalDevelopmentDocumentRoutingSeleniumTest.assertTrue((boolean)receiveFutureRequests);
        ProposalDevelopmentDocumentRoutingSeleniumTest.assertFalse((boolean)doNotReceiveFutureRequests);
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)workflowDoc.getDocumentId());
        reportCriteriaBuilder.setTargetPrincipalIds(Collections.singletonList(APPROVER));
        reportCriteriaBuilder.setActivateRequests(true);
        WorkflowDocumentActionsService info = (WorkflowDocumentActionsService)GlobalResourceLoader.getService((String)"rice.kew.workflowDocumentActionsService");
        DocumentDetail results1 = info.executeSimulation(reportCriteriaBuilder.build());
        ProposalDevelopmentDocumentRoutingSeleniumTest.assertNotNull((Object)results1.getActionRequests());
        ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((long)4L, (long)results1.getActionRequests().size());
        for (ActionRequest actionRequest : results1.getActionRequests()) {
            if (actionRequest.getNodeName().equalsIgnoreCase("Initiated")) {
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((Object)"U", (Object)actionRequest.getRecipientType().getCode());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertNotNull((Object)actionRequest.getPrincipalId());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((Object)"quickstart", (Object)actionRequest.getPrincipalId());
                continue;
            }
            if (actionRequest.getNodeName().equalsIgnoreCase("FirstApproval")) {
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((Object)"U", (Object)actionRequest.getRecipientType().getCode());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertNotNull((Object)actionRequest.getPrincipalId());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((Object)APPROVER, (Object)actionRequest.getPrincipalId());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertFalse((boolean)actionRequest.isPending());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertTrue((boolean)actionRequest.isDone());
                continue;
            }
            if (actionRequest.getNodeName().equalsIgnoreCase("SecondApproval")) {
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((Object)"U", (Object)actionRequest.getRecipientType().getCode());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertNotNull((Object)actionRequest.getPrincipalId());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((Object)"quickstart", (Object)actionRequest.getPrincipalId());
                continue;
            }
            if (actionRequest.getNodeName().equalsIgnoreCase("FinalApproval")) {
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((Object)"W", (Object)actionRequest.getRecipientType().getCode());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertNotNull((Object)actionRequest.getGroupId());
                ProposalDevelopmentDocumentRoutingSeleniumTest.assertEquals((Object)WORKFLOW_ADMIN_GROUP_ID, (Object)actionRequest.getGroupId());
                continue;
            }
            ProposalDevelopmentDocumentRoutingSeleniumTest.fail((String)"Unexpected ActionRequest generated for ProposalDevelopmentDocument");
        }
    }
}

