<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 sp2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://irb.mit.edu/irbnamespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-after extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="footerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="70%"/>
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row display-align="before">
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<fo:external-graphic>
													<xsl:attribute name="src">
														<xsl:text>url(</xsl:text>
														<xsl:call-template name="double-backslash">
															<xsl:with-param name="text">
																<xsl:value-of select="string(&apos;http://www.oria.cornell.edu/images/layout/ORIA_3line_4c.gif&apos;)"/>
															</xsl:with-param>
															<xsl:with-param name="text-length">
																<xsl:value-of select="string-length(string(&apos;http://www.oria.cornell.edu/images/layout/ORIA_3line_4c.gif&apos;))"/>
															</xsl:with-param>
														</xsl:call-template>
														<xsl:text>)</xsl:text>
													</xsl:attribute>
												</fo:external-graphic>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell font-family="Arial" font-size="10pt" line-height="11pt" text-align="right" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline text-align="right">
													<xsl:text>East Hill Office Building, Suite 320</xsl:text>
												</fo:inline>
												<fo:block/>
												<fo:inline text-align="right">
													<xsl:text>395 Pine Tree Road</xsl:text>
												</fo:inline>
												<fo:block/>
												<fo:inline text-align="right">
													<xsl:text>Ithaca, NY 14850</xsl:text>
												</fo:inline>
												<fo:block/>
												<fo:inline text-align="right">
													<xsl:text>p. 607-255-5138</xsl:text>
												</fo:inline>
												<fo:block/>
												<fo:inline text-align="right">
													<xsl:text>f.&#160; 607-255-0758</xsl:text>
												</fo:inline>
												<fo:block/>
												<fo:inline text-align="right">
													<xsl:text>www.irb.cornell.edu</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block/>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:block font-family="Times New Roman" padding-top="10pt" text-align="center" margin-left="(100% - 100%) div 2" margin-right="(100% - 100%) div 2" font-size="x-large" font-weight="bold" margin="0pt">
								<fo:block>
									<fo:inline font-family="Times New Roman" font-size="18pt" font-weight="bold">
										<xsl:text>Institutional Review Board for Human Participants</xsl:text>
									</fo:inline>
								</fo:block>
							</fo:block>
							<xsl:for-each select="n1:Schedule">
								<fo:block/>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block text-align="center" margin-left="(100% - 100%) div 2" margin-right="(100% - 100%) div 2" margin="0pt">
									<fo:block>
										<fo:inline font-family="Times New Roman">
											<xsl:text>Agenda</xsl:text>
										</fo:inline>
									</fo:block>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block text-align="center" margin-left="(100% - 100%) div 2" margin-right="(100% - 100%) div 2" margin="0pt">
									<fo:block>
										<xsl:for-each select="n1:ScheduleMasterData">
											<xsl:for-each select="n1:ScheduledDate">
												<xsl:choose>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;01&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>January</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;02&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>February</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;03&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>March</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;04&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>April</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;05&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>May</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;06&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>June</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;07&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>July</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;08&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>August</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;09&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>September</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;10&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>October</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;11&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>November</xsl:text>
														</fo:inline>
													</xsl:when>
													<xsl:when test="substring(  .  , 6 , 2 )  = &apos;12&apos;">
														<fo:inline font-family="Times New Roman">
															<xsl:text>December</xsl:text>
														</fo:inline>
													</xsl:when>
												</xsl:choose>
												<fo:inline>
													<xsl:text>&#160;</xsl:text>
												</fo:inline>
												<fo:inline font-family="Times New Roman">
													<xsl:value-of select="substring(  .  , 9 , 2 )"/>
												</fo:inline>
												<fo:inline>
													<xsl:text>, </xsl:text>
												</fo:inline>
												<fo:inline font-family="Times New Roman">
													<xsl:value-of select="substring(  .  , 1 , 4 )"/>
												</fo:inline>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block font-family="Times New Roman" text-align="center" margin-left="(100% - 100%) div 2" margin-right="(100% - 100%) div 2" font-size="large" font-weight="bold" margin="0pt">
											<fo:block>
												<fo:inline font-family="Times New Roman" font-size="16px" font-weight="bold">
													<xsl:text>Agenda Items</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:block>
									</fo:block>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:list-block font-family="Times New Roman" provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
											<xsl:for-each select="n1:OtherBusiness">
												<fo:list-item>
													<fo:list-item-label end-indent="label-end()" text-align="right">
														<fo:block>
															<xsl:number format="1" value="position()+0"/>.</fo:block>
													</fo:list-item-label>
													<fo:list-item-body start-indent="body-start()">
														<fo:block font-family="Times New Roman">
															<xsl:for-each select="n1:ActionItemCodeDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block font-family="Times New Roman">
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline font-family="Times New Roman">
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
															<fo:inline>
																<xsl:text>: </xsl:text>
															</fo:inline>
															<xsl:for-each select="n1:ActionItemDesc">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block font-family="Times New Roman">
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline font-family="Times New Roman">
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</fo:block>
													</fo:list-item-body>
												</fo:list-item>
											</xsl:for-each>
										</fo:list-block>
									</fo:block>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:inline-container>
									<fo:block>
										<xsl:text>&#x2029;</xsl:text>
									</fo:block>
								</fo:inline-container>
								<fo:block margin="0pt">
									<fo:block>
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:block font-family="Times New Roman" text-align="center" margin-left="(100% - 100%) div 2" margin-right="(100% - 100%) div 2" font-size="large" font-weight="bold" margin="0pt">
											<fo:block>
												<fo:inline font-family="Times New Roman" font-size="16px" font-weight="bold">
													<xsl:text>Full Board Review</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:block>
									</fo:block>
								</fo:block>
								<xsl:for-each select="n1:ProtocolSubmission">
									<xsl:choose>
										<xsl:when test="n1:SubmissionDetails/n1:ProtocolReviewTypeCode = 1 and  n1:SubmissionDetails/n1:SubmissionTypeCode = 100">
											<fo:block/>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block font-family="Times New Roman" font-size="medium" font-weight="bold" margin="0pt">
												<fo:block>
													<fo:inline font-family="Times New Roman" text-decoration="underline">
														<xsl:text>Initial Approval Request</xsl:text>
													</fo:inline>
													<fo:inline font-family="Times New Roman">
														<xsl:text> - </xsl:text>
													</fo:inline>
													<xsl:for-each select="n1:ProtocolSummary">
														<xsl:for-each select="n1:ProtocolMasterData">
															<xsl:for-each select="n1:ProtocolNumber">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:block>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table border="0" table-layout="fixed" width="100%" border-spacing="2pt">
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell font-family="Times New Roman" display-align="before" number-columns-spanned="2" padding="2pt" height="61">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Principal Investigator: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:ProtocolSummary">
																			<xsl:for-each select="n1:Investigator">
																				<xsl:if test="n1:PI_flag  = &apos;true&apos;">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Firstname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<xsl:for-each select="n1:LastName">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-family="Times New Roman" display-align="before" number-columns-spanned="2" padding="2pt" height="61">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Project Title: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:ProtocolSummary">
																			<xsl:for-each select="n1:ProtocolMasterData">
																				<xsl:for-each select="n1:ProtocolTitle">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline font-family="Arial">
																			<xsl:text>Primary Reviewer: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:SubmissionDetails">
																			<xsl:for-each select="n1:ProtocolReviewer">
																				<xsl:if test="n1:ReviewerTypeCode  = 1">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Fullname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Arial">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Arial">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block/>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline font-family="Arial">
																			<xsl:text>Secondary Reviewer: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:SubmissionDetails">
																			<xsl:for-each select="n1:ProtocolReviewer">
																				<xsl:if test="n1:ReviewerTypeCode  = 2">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Fullname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Arial">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Arial">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:block>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block/>
											</fo:block>
										</xsl:when>
										<xsl:when test="n1:SubmissionDetails/n1:ProtocolReviewTypeCode = 1 and  n1:SubmissionDetails/n1:SubmissionTypeCode = 102">
											<fo:block/>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block font-family="Times New Roman" font-size="medium" font-weight="bold" margin="0pt">
												<fo:block>
													<fo:inline font-family="Times New Roman" text-decoration="underline">
														<xsl:text>Amendment Request</xsl:text>
													</fo:inline>
													<fo:inline font-family="Times New Roman">
														<xsl:text> - </xsl:text>
													</fo:inline>
													<xsl:for-each select="n1:ProtocolSummary">
														<xsl:for-each select="n1:ProtocolMasterData">
															<xsl:for-each select="n1:ProtocolNumber">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:block>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table border="0" table-layout="fixed" width="100%" border-spacing="2pt">
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell font-family="Times New Roman" display-align="before" number-columns-spanned="2" padding="2pt" height="61">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Principal Investigator: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:ProtocolSummary">
																			<xsl:for-each select="n1:Investigator">
																				<xsl:if test="n1:PI_flag  = &apos;true&apos;">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Firstname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<xsl:for-each select="n1:LastName">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-family="Times New Roman" display-align="before" number-columns-spanned="2" padding="2pt" height="61">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Project Title: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:ProtocolSummary">
																			<xsl:for-each select="n1:ProtocolMasterData">
																				<xsl:for-each select="n1:ProtocolTitle">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline font-family="Arial">
																			<xsl:text>Primary Reviewer: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:SubmissionDetails">
																			<xsl:for-each select="n1:ProtocolReviewer">
																				<xsl:if test="n1:ReviewerTypeCode  = 1">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Fullname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Arial">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Arial">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block/>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline font-family="Arial">
																			<xsl:text>Secondary Reviewer: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:SubmissionDetails">
																			<xsl:for-each select="n1:ProtocolReviewer">
																				<xsl:if test="n1:ReviewerTypeCode  = 2">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Fullname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Arial">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Arial">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:block>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block/>
											</fo:block>
										</xsl:when>
										<xsl:when test="n1:SubmissionDetails/n1:ProtocolReviewTypeCode = 1 and  n1:SubmissionDetails/n1:SubmissionTypeCode = 101">
											<fo:block/>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block font-family="Times New Roman" font-size="medium" font-weight="bold" margin="0pt">
												<fo:block>
													<fo:inline font-family="Times New Roman" text-decoration="underline">
														<xsl:text>Continuation Request</xsl:text>
													</fo:inline>
													<fo:inline font-family="Times New Roman">
														<xsl:text> - </xsl:text>
													</fo:inline>
													<xsl:for-each select="n1:ProtocolSummary">
														<xsl:for-each select="n1:ProtocolMasterData">
															<xsl:for-each select="n1:ProtocolNumber">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:block>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block>
													<fo:inline-container>
														<fo:block>
															<xsl:text>&#x2029;</xsl:text>
														</fo:block>
													</fo:inline-container>
													<fo:table border="0" table-layout="fixed" width="100%" border-spacing="2pt">
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-column column-width="proportional-column-width(1)"/>
														<fo:table-body start-indent="0pt">
															<fo:table-row>
																<fo:table-cell font-family="Times New Roman" display-align="before" number-columns-spanned="2" padding="2pt" height="61">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Principal Investigator: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:ProtocolSummary">
																			<xsl:for-each select="n1:Investigator">
																				<xsl:if test="n1:PI_flag  = &apos;true&apos;">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Firstname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<xsl:for-each select="n1:LastName">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-family="Times New Roman" display-align="before" number-columns-spanned="2" padding="2pt" height="61">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Project Title: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:ProtocolSummary">
																			<xsl:for-each select="n1:ProtocolMasterData">
																				<xsl:for-each select="n1:ProtocolTitle">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-family="Times New Roman" number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline font-family="Times New Roman">
																			<xsl:text>Primary Reviewer: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:SubmissionDetails">
																			<xsl:for-each select="n1:ProtocolReviewer">
																				<xsl:if test="n1:ReviewerTypeCode  = 1">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Fullname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block/>
																</fo:table-cell>
															</fo:table-row>
															<fo:table-row>
																<fo:table-cell font-family="Times New Roman" number-columns-spanned="2" padding="2pt" display-align="center">
																	<fo:block>
																		<fo:inline font-family="Times New Roman">
																			<xsl:text>Secondary Reviewer: </xsl:text>
																		</fo:inline>
																		<xsl:for-each select="n1:SubmissionDetails">
																			<xsl:for-each select="n1:ProtocolReviewer">
																				<xsl:if test="n1:ReviewerTypeCode  = 2">
																					<xsl:for-each select="n1:Person">
																						<xsl:for-each select="n1:Fullname">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline font-family="Times New Roman">
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:for-each>
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:block>
											<fo:block>
												<fo:leader leader-pattern="space"/>
											</fo:block>
											<fo:inline-container>
												<fo:block>
													<xsl:text>&#x2029;</xsl:text>
												</fo:block>
											</fo:inline-container>
											<fo:block margin="0pt">
												<fo:block/>
											</fo:block>
										</xsl:when>
									</xsl:choose>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="footerall">
		<fo:static-content flow-name="xsl-region-after">
			<fo:block>
				<fo:inline-container>
					<fo:block>
						<xsl:text>&#x2029;</xsl:text>
					</fo:block>
				</fo:inline-container>
				<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-column column-width="154"/>
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
								<fo:block>
									<fo:block text-align="center">
										<fo:leader top="-37pt" leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
									</fo:block>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell font-size="10pt" padding="0" text-align="left" display-align="center">
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell font-size="10pt" padding="0" text-align="right" display-align="center">
								<fo:block>
									<fo:page-number font-weight="bold"/>
									<fo:inline font-weight="bold">
										<xsl:text> of </xsl:text>
									</fo:inline>
									<fo:page-number-citation ref-id="SV_RefID_PageTotal" font-weight="bold"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
