<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.8in" margin-right="0.8in">
				<fo:region-body margin-top="1.35in" margin-bottom="0.15in"/>
				<fo:region-before extent="1.35in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="35%"/>
								<fo:table-column column-width="20%"/>
								<fo:table-column column-width="45%"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell border-bottom-style="none" border-bottom-width="0" font-family="Verdana" font-size="9pt" margin-bottom="0" padding-bottom="0" display-align="0" padding="2pt" text-align="left">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block border-bottom-style="none" border-bottom-width="0" font-family="Verdana" font-size="9pt" margin-bottom="0" padding-bottom="0" display-align="0" margin="0pt">
													<fo:block>
														<xsl:for-each select="printCertification">
															<xsl:for-each select="OfficeName">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block color="#800040" font-weight="bold">
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline color="#800040" font-weight="bold">
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-bottom-style="none" border-bottom-width="0" font-size="xx-small" margin-bottom="0" padding-bottom="0" display-align="0" padding="2pt" text-align="left">
											<fo:block>
												<fo:external-graphic>
													<xsl:attribute name="src">
														<xsl:text>url(</xsl:text>
														<xsl:call-template name="double-backslash">
															<xsl:with-param name="text">
																<xsl:value-of select="string(concat(printCertification/LogoPath,&apos;printCertificationLogo.gif&apos;))"/>
															</xsl:with-param>
															<xsl:with-param name="text-length">
																<xsl:value-of select="string-length(string(concat(printCertification/LogoPath,&apos;printCertificationLogo.gif&apos;)))"/>
															</xsl:with-param>
														</xsl:call-template>
														<xsl:text>)</xsl:text>
													</xsl:attribute>
												</fo:external-graphic>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-bottom-style="none" border-bottom-width="0" font-family="Verdana" font-size="9pt" margin-bottom="0" padding-bottom="0" display-align="0" padding="2pt" text-align="justify">
											<fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block border-bottom-style="none" border-bottom-width="0" font-family="Verdana" font-size="9pt" margin-bottom="0" display-align="0" margin="0pt">
													<fo:block>
														<xsl:for-each select="printCertification">
															<xsl:for-each select="organizationInfo">
																<xsl:for-each select="OrganizationName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block color="#800040" font-family="Verdana" font-size="9pt" font-weight="bold">
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline color="#800040" font-family="Verdana" font-size="9pt" font-weight="bold">
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:block>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:block border-bottom-style="none" border-bottom-width="0" font-family="Verdana" font-size="9pt" margin-bottom="0" display-align="0" margin="0pt">
													<fo:block>
														<xsl:choose>
															<xsl:when test="boolean(  printCertification/organizationInfo/ContactName  )  and  boolean(  printCertification/organizationInfo/Address1 )  and  not(boolean(  printCertification/organizationInfo/Address2  ) ) and  not(boolean(  printCertification/organizationInfo/Address3  ))">
																<xsl:for-each select="printCertification">
																	<xsl:for-each select="organizationInfo">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="ContactName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<xsl:for-each select="Address1">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="boolean(  printCertification/organizationInfo/ContactName  )  and  boolean(  printCertification/organizationInfo/Address1 )  and  boolean(  printCertification/organizationInfo/Address2  ) and  not(boolean(  printCertification/organizationInfo/Address3  ))">
																<xsl:for-each select="printCertification">
																	<xsl:for-each select="organizationInfo">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="ContactName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="Address1">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<xsl:for-each select="Address2">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="boolean(  printCertification/organizationInfo/ContactName  )  and  boolean(  printCertification/organizationInfo/Address1 )  and  not(boolean(  printCertification/organizationInfo/Address2  )) and  boolean(  printCertification/organizationInfo/Address3  )">
																<xsl:for-each select="printCertification">
																	<xsl:for-each select="organizationInfo">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="ContactName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="Address1">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<xsl:for-each select="Address3">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="boolean(  printCertification/organizationInfo/ContactName  )  and  not(boolean(  printCertification/organizationInfo/Address1 ))  and  boolean(  printCertification/organizationInfo/Address2 ) and  boolean(  printCertification/organizationInfo/Address3  )">
																<xsl:for-each select="printCertification">
																	<xsl:for-each select="organizationInfo">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="ContactName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="Address2">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<xsl:for-each select="Address3">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="boolean(  printCertification/organizationInfo/ContactName  )  and  not(boolean(  printCertification/organizationInfo/Address1 ))  and  not(boolean(  printCertification/organizationInfo/Address2 )) and  boolean(  printCertification/organizationInfo/Address3  )">
																<xsl:for-each select="printCertification">
																	<xsl:for-each select="organizationInfo">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="ContactName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<xsl:for-each select="Address3">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="boolean(  printCertification/organizationInfo/ContactName  )  and  not(boolean(  printCertification/organizationInfo/Address1 ))  and  boolean(  printCertification/organizationInfo/Address2 ) and  not(boolean(  printCertification/organizationInfo/Address3 ) )">
																<xsl:for-each select="printCertification">
																	<xsl:for-each select="organizationInfo">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="ContactName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<xsl:for-each select="Address2">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="boolean(  printCertification/organizationInfo/ContactName  )  and  not(boolean(  printCertification/organizationInfo/Address1 ))  and  not(boolean(  printCertification/organizationInfo/Address2 )) and  not(boolean(  printCertification/organizationInfo/Address3 ) )">
																<xsl:for-each select="printCertification">
																	<xsl:for-each select="organizationInfo">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="ContactName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:when>
															<xsl:otherwise>
																<xsl:for-each select="printCertification">
																	<xsl:for-each select="organizationInfo">
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="ContactName">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="Address1">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<fo:block>
																			<fo:leader leader-pattern="space"/>
																		</fo:block>
																		<fo:inline-container>
																			<fo:block>
																				<xsl:text>&#x2029;</xsl:text>
																			</fo:block>
																		</fo:inline-container>
																		<fo:block margin="0pt">
																			<fo:block>
																				<xsl:for-each select="Address2">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</fo:block>
																		</fo:block>
																		<xsl:for-each select="Address3">
																			<xsl:variable name="value-of-template">
																				<xsl:apply-templates/>
																			</xsl:variable>
																			<xsl:choose>
																				<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																					<fo:block>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:block>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline>
																						<xsl:copy-of select="$value-of-template"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																	</xsl:for-each>
																</xsl:for-each>
															</xsl:otherwise>
														</xsl:choose>
													</fo:block>
												</fo:block>
												<xsl:for-each select="printCertification">
													<xsl:for-each select="organizationInfo">
														<xsl:if test="boolean(  City  )">
															<xsl:for-each select="City">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:if>
														<xsl:choose>
															<xsl:when test="boolean(  City  )  and boolean(  State  )">
																<xsl:for-each select="State">
																	<fo:inline>
																		<xsl:text>, </xsl:text>
																	</fo:inline>
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:when>
															<xsl:when test="not(boolean(  City  ) ) and boolean(  State  )  and  State != null">
																<xsl:for-each select="State">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:when>
														</xsl:choose>
														<xsl:for-each select="PostCode">
															<fo:inline>
																<xsl:text>&#160;</xsl:text>
															</fo:inline>
															<xsl:variable name="value-of-template">
																<xsl:apply-templates/>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																	<fo:block>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:block>
																</xsl:when>
																<xsl:otherwise>
																	<fo:inline>
																		<xsl:copy-of select="$value-of-template"/>
																	</fo:inline>
																</xsl:otherwise>
															</xsl:choose>
														</xsl:for-each>
														<xsl:if test="not(  boolean(  State  )  )">
															<xsl:for-each select="Country">
																<fo:inline>
																	<xsl:text> , </xsl:text>
																</fo:inline>
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:if>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="35%"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell border-top-style="none" border-top-width="0" color="#800040" font-size="larger" font-weight="bolder" line-height="0" margin="0" margin-bottom="0" padding="0" padding-bottom="0" padding-top="0" top="0" display-align="0" height="24" text-align="left">
											<fo:block>
												<fo:inline border-top-style="none" border-top-width="0" line-height="0" margin="0" padding="0" padding-top="0">
													<xsl:text>__________________________________________________________________________</xsl:text>
												</fo:inline>
												<fo:inline>
													<xsl:text>_______________________________________________________________________________________________</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block/>
							<xsl:choose>
								<xsl:when test="printCertification/certifications/questionID = &quot;P1&quot;">
									<fo:block/>
									<fo:block/>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="20%"/>
										<fo:table-column column-width="80%"/>
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding="2pt" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-size="9pt" font-weight="bold" padding-bottom="0" padding-top="0" padding="2pt" height="19" display-align="center">
													<fo:block>
														<fo:inline font-weight="bold">
															<xsl:text>Date:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" height="19" display-align="center">
													<fo:block>
														<xsl:for-each select="printCertification">
															<xsl:for-each select="CurrentDate">
																<fo:inline>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																	<xsl:text>/</xsl:text>
																	<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																</fo:inline>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-size="9pt" font-weight="bold" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline font-weight="bold">
															<xsl:text>Investigator:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="printCertification">
															<xsl:for-each select="investigator">
																<xsl:for-each select="PersonName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-size="9pt" font-weight="bold" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline font-weight="bold">
															<xsl:text>Proposal Number:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="printCertification">
															<xsl:for-each select="proposalNumber">
																<xsl:variable name="value-of-template">
																	<xsl:apply-templates/>
																</xsl:variable>
																<xsl:choose>
																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																		<fo:block>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:block>
																	</xsl:when>
																	<xsl:otherwise>
																		<fo:inline>
																			<xsl:copy-of select="$value-of-template"/>
																		</fo:inline>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-size="9pt" font-weight="bold" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline font-weight="bold">
															<xsl:text>Agency:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="printCertification">
															<xsl:for-each select="sponsor">
																<xsl:for-each select="sponsorName">
																	<xsl:variable name="value-of-template">
																		<xsl:apply-templates/>
																	</xsl:variable>
																	<xsl:choose>
																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																			<fo:block>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:block>
																		</xsl:when>
																		<xsl:otherwise>
																			<fo:inline>
																				<xsl:copy-of select="$value-of-template"/>
																			</fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell font-size="9pt" font-weight="bold" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block>
														<fo:inline font-weight="bold">
															<xsl:text>Subject:</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell font-size="9pt" padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block>
														<xsl:for-each select="printCertification">
															<xsl:for-each select="proposalTitle">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:block padding-bottom="0" padding-top="0" white-space="pre" white-space-collapse="false" margin="0pt">
																	<fo:block>
																		<fo:inline>
																			<xsl:text>Certification for proposal entitled &quot;</xsl:text>
																		</fo:inline>
																		<xsl:variable name="value-of-template">
																			<xsl:apply-templates/>
																		</xsl:variable>
																		<xsl:choose>
																			<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																				<fo:block>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:block>
																			</xsl:when>
																			<xsl:otherwise>
																				<fo:inline>
																					<xsl:copy-of select="$value-of-template"/>
																				</fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																		<fo:inline>
																			<xsl:text>&quot;</xsl:text>
																		</fo:inline>
																	</fo:block>
																</fo:block>
															</xsl:for-each>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
									<fo:inline-container>
										<fo:block>
											<xsl:text>&#x2029;</xsl:text>
										</fo:block>
									</fo:inline-container>
									<fo:table font-family="Verdana" font-size="10pt" table-layout="fixed" width="100%" border-spacing="2pt">
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-column column-width="proportional-column-width(1)"/>
										<fo:table-body start-indent="0pt">
											<fo:table-row>
												<fo:table-cell padding="0" number-columns-spanned="17" display-align="center">
													<fo:block>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="20%"/>
															<fo:table-column column-width="80%"/>
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
																		<fo:block/>
																	</fo:table-cell>
																	<fo:table-cell padding-bottom="0" padding-top="0" padding="2pt" display-align="center">
																		<fo:block/>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell number-columns-spanned="17" padding="2pt" display-align="center">
													<fo:block>
														<fo:block/>
														<fo:inline>
															<xsl:text>My signature below certifies that I hereby authorize MIT to submit the above referenced proposal as an institutionally authorized proposal.</xsl:text>
														</fo:inline>
														<fo:block/>
														<fo:inline>
															<xsl:text>Further, as a Principal Investigator/Co-Principal Investigator/Co-Investigator I certify that:
</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" number-columns-spanned="17" display-align="center">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" number-columns-spanned="17" display-align="center">
													<fo:block>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="5%"/>
															<fo:table-column column-width="95%"/>
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>1</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:choose>
																				<xsl:when test="printCertification/certifications[ questionID = &quot;P1&quot; and   answer = &apos;Y&apos; ]">
																					<fo:inline>
																						<xsl:text>The information submitted within the application is true, complete and accurate to the best of my knowledge.&#160; Any false, fictitious, or fraudulent statements or claims may subject me, as the PI/Co-PI/Co-I to criminal, civil or administrative penalties.&#160; I agree to accept responsibility for the scientific conduct of the project and to provide the required progress reports if an award is made as a result of this application.&#160; </xsl:text>
																					</fo:inline>
																					<fo:inline font-size="9pt" font-style="italic">
																						<xsl:text>This certification is being added at this time to meet a specific NIH requirement.&#160; It also reflects current federal regulations.</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="printCertification/certifications[ questionID = &quot;P1&quot; and   answer = &apos;N&apos; ]">
																					<fo:inline>
																						<xsl:text>Please contact your department head, center or laboratory director, or Vice-President for research if you cannot certify the following:</xsl:text>
																					</fo:inline>
																					<fo:block/>
																					<fo:inline>
																						<xsl:text>I cannot certify that this application is true, complete and accurate to the best of my knowledge; that I understand that any false, fictitious, or fraudulent statements or claims may subject me, as the PI/Co-PI/Co-I to criminal, civil or administrative penalties or that I agree to accept responsibility for the scientific conduct of the project and to provide the required progress reports if an award is made as a result of this application.&#160; </xsl:text>
																					</fo:inline>
																					<fo:inline font-size="9pt" font-style="italic">
																						<xsl:text>This certification is being added at this time to meet a specific NIH requirement, and it also reflects current federal regulations</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:text>. </xsl:text>
																					</fo:inline>
																				</xsl:when>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<fo:inline>
																				<xsl:text>2</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:choose>
																				<xsl:when test="printCertification/certifications[questionID = &quot;P2&quot; and   answer = &quot;N&quot;]">
																					<fo:inline>
																						<xsl:text>I do not have a perceived, potential or real conflict of interest as defined in MIT policies and procedures with regard to the proposed activity.</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="printCertification/certifications[questionID = &quot;P2&quot; and   answer = &quot;Y&quot;]">
																					<fo:inline>
																						<xsl:text>I have identified a perceived, potential or real financial conflict of interest with regard to the proposed research of this proposal.&#160; I have (or will) seek advice and guidance to eliminate or to manage the conflict, by reviewing the circumstances with my department head, center or laboratory director, or with the Director of the Office of Sponsored Programs.</xsl:text>
																					</fo:inline>
																				</xsl:when>
																			</xsl:choose>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:if test="printCertification/sponsor/sponsorType  = &quot;FED&quot;">
																				<fo:inline>
																					<xsl:text>3</xsl:text>
																				</fo:inline>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:if test="printCertification/sponsor/sponsorType  = &quot;FED&quot;">
																				<xsl:choose>
																					<xsl:when test="printCertification/certifications[questionID = &quot;P3&quot; and   answer = &quot;Y&quot;]">
																						<fo:inline>
																							<xsl:text>I submitted the required Financial Disclosure for this NIH/NSF proposal via the web based COEUS Conflict of Interest module on&#160;&#160; _____________________.</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="printCertification/certifications[questionID = &quot;P3&quot; and   answer = &quot;N&quot;]">
																						<fo:inline>
																							<xsl:text>I have not submitted the required Financial Disclosure for this NIH/NSF proposal in COEUS and I understand that this proposal cannot be submitted until I have completed this disclosure.</xsl:text>
																						</fo:inline>
																					</xsl:when>
																				</xsl:choose>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:if test="printCertification/sponsor/sponsorType  = &quot;FED&quot;">
																				<fo:inline>
																					<xsl:text>4</xsl:text>
																				</fo:inline>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:if test="printCertification/sponsor/sponsorType  = &quot;FED&quot;">
																				<xsl:choose>
																					<xsl:when test="printCertification/certifications[questionID = &quot;H4&quot; and   answer = &quot;N&quot;]">
																						<fo:inline>
																							<xsl:text>I have not and will not lobby any federal agency on behalf of this proposal nor do I have any knowledge of anyone else doing so. </xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="printCertification/certifications[questionID = &quot;H4&quot; and   answer = &quot;Y&quot;]">
																						<fo:inline>
																							<xsl:text>I have and/or will lobby a federal agency on behalf of this proposal or I plan to have others do so.&#160; </xsl:text>
																						</fo:inline>
																						<fo:inline font-size="9pt" font-style="italic">
																							<xsl:text>I have completed the Report on Lobbying Activity and have submitted it to the Office of Sponsored Programs, E19-750.</xsl:text>
																						</fo:inline>
																						<fo:inline font-style="italic">
																							<xsl:text>&#160; </xsl:text>
																						</fo:inline>
																					</xsl:when>
																				</xsl:choose>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:if test="printCertification/sponsor/sponsorType  = &quot;FED&quot;">
																				<fo:inline>
																					<xsl:text>5</xsl:text>
																				</fo:inline>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:if test="printCertification/sponsor/sponsorType  = &quot;FED&quot;">
																				<xsl:choose>
																					<xsl:when test="printCertification/certifications[questionID = &quot;P5&quot; and   answer = &quot;N&quot;]">
																						<fo:inline>
																							<xsl:text>I am not debarred, suspended, proposed for debarment, declared ineligible or voluntarily excluded from the current transaction by a federal department or agency.</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="printCertification/certifications[questionID = &quot;P5&quot; and   answer = &quot;Y&quot;]">
																						<fo:inline>
																							<xsl:text>I am currently debarred, suspended, proposed for debarment, declared ineligible or voluntarily excluded from the current transaction by a federal department or agency.&#160; </xsl:text>
																						</fo:inline>
																						<fo:inline font-size="9pt" font-style="italic">
																							<xsl:text>I have notified the Office of Sponsored Programs and understand that I am precluded from receiving federally funded grant or contract awards or from being paid with federal funds.</xsl:text>
																						</fo:inline>
																						<fo:inline font-size="9pt">
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																				</xsl:choose>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
																<fo:table-row>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:if test="printCertification/sponsor/sponsorType = &quot;FED&quot;">
																				<fo:inline>
																					<xsl:text>6</xsl:text>
																				</fo:inline>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell padding="2pt" display-align="before">
																		<fo:block>
																			<xsl:if test="printCertification/sponsor/sponsorType = &quot;FED&quot;">
																				<xsl:choose>
																					<xsl:when test="printCertification/certifications[questionID = &quot;P6&quot; and   answer = &quot;Y&quot;]">
																						<fo:inline>
																							<xsl:text>I am familiar with the requirements of the Procurement Integrity Act [(OFPP, Section 27 b103)] (</xsl:text>
																						</fo:inline>
																						<fo:inline text-decoration="underline">
																							<xsl:text>http://web.mit.edu/osp/www/Procuint.htm</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:text>) and will report any violations to the Office of Sponsored Programs.</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="printCertification/certifications[questionID = &quot;P6&quot; and   answer = &quot;N&quot;]">
																						<fo:inline>
																							<xsl:text>I am not familiar with the requirements of the Procurement Integrity Act [(OFPP, Section 27 b103)] (</xsl:text>
																						</fo:inline>
																						<fo:inline text-decoration="underline">
																							<xsl:text>http://web.mit.edu/osp/www/Procuint.htm</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:text>) and will not be able report any violations to the Office of Sponsored Programs.</xsl:text>
																						</fo:inline>
																					</xsl:when>
																				</xsl:choose>
																			</xsl:if>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell number-columns-spanned="17" padding="2pt" display-align="center">
													<fo:block>
														<fo:block/>
														<xsl:if test="position()  =  last()">
															<fo:block break-after="page">
																<fo:leader leader-pattern="space"/>
															</fo:block>
														</xsl:if>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0" number-columns-spanned="17" display-align="center">
													<fo:block>
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
															<fo:table-column column-width="65%"/>
															<fo:table-column column-width="35%"/>
															<fo:table-body start-indent="0pt">
																<fo:table-row>
																	<fo:table-cell padding-left="30pt" padding-right="18pt" padding="2pt" display-align="center">
																		<fo:block>
																			<fo:block/>
																			<fo:block text-align="center">
																				<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																			</fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>Signature</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																	<fo:table-cell margin-bottom="0" padding-left="18pt" padding-right="38pt" padding="2pt" display-align="after">
																		<fo:block>
																			<fo:block/>
																			<fo:block text-align="center">
																				<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																			</fo:block>
																			<fo:inline font-weight="bold">
																				<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Date</xsl:text>
																			</fo:inline>
																		</fo:block>
																	</fo:table-cell>
																</fo:table-row>
															</fo:table-body>
														</fo:table>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="printCertification/certifications/questionID !=  &quot;P1&quot;   and  boolean( printCertification/certifications/statement )">
										<fo:inline-container>
											<fo:block>
												<xsl:text>&#x2029;</xsl:text>
											</fo:block>
										</fo:inline-container>
										<fo:table font-family="Verdana" font-size="10pt" table-layout="fixed" width="100%" border-spacing="2pt">
											<fo:table-column column-width="proportional-column-width(1)"/>
											<fo:table-body start-indent="0pt">
												<fo:table-row>
													<fo:table-cell padding="2pt" text-align="center" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" text-align="center" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" text-align="center" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" text-align="center" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																<fo:table-column column-width="20%"/>
																<fo:table-column column-width="80%"/>
																<fo:table-body start-indent="0pt">
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Investigator</xsl:text>
																				</fo:inline>
																				<xsl:choose>
																					<xsl:when test="printCertification/investigator/principalInvFlag  = &apos;true&apos;">
																						<fo:inline font-weight="bold">
																							<xsl:text>(PI):</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline font-weight="bold">
																							<xsl:text>:</xsl:text>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="printCertification">
																					<xsl:for-each select="investigator">
																						<xsl:for-each select="PersonName">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Proposal Number:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="printCertification">
																					<xsl:for-each select="proposalNumber">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Agency:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="printCertification">
																					<xsl:for-each select="sponsor">
																						<xsl:for-each select="sponsorName">
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:inline font-weight="bold">
																					<xsl:text>Proposal Title:</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<xsl:for-each select="printCertification">
																					<xsl:for-each select="proposalTitle">
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:block white-space="pre" white-space-collapse="false" margin="0pt">
																							<fo:block>
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</fo:block>
																						</fo:block>
																					</xsl:for-each>
																				</xsl:for-each>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block>
															<fo:block/>
															<fo:inline>
																<xsl:text>As a principal or co-principal investigator on the above referenced proposal, I certify that:</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" display-align="center">
														<fo:block>
															<xsl:for-each select="printCertification">
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<xsl:if test="certifications">
																	<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																		<fo:table-column column-width="5%"/>
																		<fo:table-column column-width="95%"/>
																		<fo:table-body start-indent="0pt">
																			<xsl:for-each select="certifications">
																				<fo:table-row>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="stmt_number">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																								<fo:inline>
																									<xsl:text> )</xsl:text>
																								</fo:inline>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																					<fo:table-cell padding="2pt" display-align="center">
																						<fo:block>
																							<xsl:for-each select="statement">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</fo:block>
																					</fo:table-cell>
																				</fo:table-row>
																			</xsl:for-each>
																		</fo:table-body>
																	</fo:table>
																</xsl:if>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="2pt" display-align="center">
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0" display-align="center">
														<fo:block>
															<fo:inline-container>
																<fo:block>
																	<xsl:text>&#x2029;</xsl:text>
																</fo:block>
															</fo:inline-container>
															<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																<fo:table-column column-width="10%"/>
																<fo:table-column column-width="90%"/>
																<fo:table-body start-indent="0pt">
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:block/>
																				<fo:inline font-weight="bold">
																					<xsl:text>Signature</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell margin-bottom="0" padding-left="8pt" padding="2pt" display-align="after">
																			<fo:block>
																				<fo:block/>
																				<fo:block/>
																				<fo:block text-align="center">
																					<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																				</fo:block>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																	<fo:table-row>
																		<fo:table-cell padding="2pt" display-align="center">
																			<fo:block>
																				<fo:block/>
																				<fo:inline font-weight="bold">
																					<xsl:text>Date</xsl:text>
																				</fo:inline>
																			</fo:block>
																		</fo:table-cell>
																		<fo:table-cell margin-bottom="0" padding-left="8pt" padding="2pt" display-align="center">
																			<fo:block>
																				<fo:block/>
																				<fo:block/>
																				<fo:block text-align="center">
																					<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																				</fo:block>
																			</fo:block>
																		</fo:table-cell>
																	</fo:table-row>
																</fo:table-body>
															</fo:table>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block/>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
